#include "mbed.h"
#include "TextLCD.h"
#include "AnalogIn.h"
#include "Serial.h"

TextLCD lcd(PTD3, PTA12, PTA4, PTA5, PTC8, PTC9, TextLCD::LCD16x2);
AnalogIn presionin(PTB2);
DigitalOut evalvula(PTE1);
float caspresion;
int  tipobanio=0, cont=0, ev= 1;
Serial pc(USBTX, USBRX);

void presion()
{
    caspresion = presionin.read() * 3.3;
    pc.printf("analogin %.2f\n\r", caspresion);

    switch(tipobanio) {
        case 0:                             //baño rapido
            if(caspresion >= 2.2) {         //se lleno
                pc.printf("se lleno y apago ev\n\r");
                ev = 0;
            }
            if(caspresion <=  1.53) {        //se vacio
                cont++;
                pc.printf("se vacio\n\r");
                pc.printf("%d\n\r", cont);
                if(cont > 20) {           //contador
                    ev = 1;
                    cont = 0;
                    pc.printf("se activa la ev\n\r");
                }
            }
            break;
        case 1:                             //baño normal
            if(caspresion >= 2.6) {         //se lleno
                pc.printf("se lleno y apago ev\n\r");
                ev = 0;
            }
            if(caspresion <= 1.53) {        //se vacio
                cont++;
                pc.printf("se vacio\n\r");
                pc.printf("%d\n\r", cont);
                if(cont == 20) {           //contador
                    ev = 1;
                    cont = 0;
                    pc.printf("se activa la ev\n\r");
                }
            }
            break;
    }                                       //fin switch
    evalvula.write(ev);
}                                           //funcion

int main()
{
    pc.baud(115200);
    while (true) {
        pc.printf("llama funcion ev=%d\n\r",ev);
        presion();
        wait(1);
    }                                           //fin while
}                                               //fin main
