#include "mbed.h"
#include "AnalogIn.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX);
AnalogIn externo(PTC2);
AnalogIn interno(PTB3);
InterruptIn sw1(SW1);
InterruptIn sw3(SW3);
DigitalIn llave(PTA1);

 
TextLCD lcd(PTD3, PTA12, PTA4, PTA5, PTC8, PTC9, TextLCD::LCD16x2);

int temp = 26;
char tipo;
int sel = 1;
float casinterno;
float casexterno;
float tinterno;
float texterno;
char modo = 'M';  

void menu (){
    lcd.cls();
    switch (sel){
        case 1:                      
            lcd.locate(0,0);
            lcd.printf("auto");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 2;
            break;
        case 2:
            lcd.locate(0,0);
            lcd.printf("manual");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 3;
            break;
        case 3:            
            lcd.locate(0,0);
            lcd.printf("reloj");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 1;
            break;
        case 4:           
            lcd.locate(0,0);
            lcd.printf("temperatura");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 5;
            break;
        case 5:
            lcd.locate(0,0);
            lcd.printf("tipo banio");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 6;
            break;
        case 6:            
            lcd.locate(0,0);
            lcd.printf("horarios");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 9;
            break;
        case 7:            
            lcd.locate(0,0);
            lcd.printf("temperatura");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 8;
            break;
        case 8:           
            lcd.locate(0,0);
            lcd.printf("tipo banio");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 10;
            break;
        case 9:           
            lcd.locate(0,0);
            lcd.printf("salir");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 4;
            break;
        case 10:
            lcd.locate(0,0);
            lcd.printf("salir");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
            sel = 7;
            break;        
            }       
}

void selec(){
    switch (sel){
        case 2:
            modo = 'A';       
            sel = 4;
            menu();
            break;
        case 3:
            modo = 'M';
            sel = 7;
            menu();
            break;
        case 1:
            pc.printf("aca ingresaria la hora\r\n");
            wait(1.5);
            break;
        case 5:
            pc.printf("aca ingresaria la temperatura\r\n");
            wait(1.5);
            break;
        case 6:
            pc.printf("aca ingresaria el tipo de banio\r\n");
            wait(1.5);
            break;
        case 4:
            sel = 1;
            menu();                    //salida1
            break;
        case 8:
            pc.printf("aca ingresaria la temperatura2\r\n");
            wait(1.5);
            break;
        case 7:
            sel = 2;
            menu();
            break;
        case 9:
            pc.printf("aca ingresaria el horario\r\n");
            wait(1.5);
            break;
        case 10:
            pc.printf("aca ingresaria tipo banio\r\n");
            wait(1.5);
            break;
            }
    
    }

int main() {

    pc.baud(115200);

    int comp;

    while(1){
        
        sw1.fall(&menu);
        sw3.fall(&selec);
//convierte voltaje a temperatura        
        casexterno = externo.read() * 3.3;
        texterno = (casexterno + 0.2) * 100 / 5;        
        casinterno = interno.read() * 3.3;
        tinterno = (casinterno + 2) * 100 / 8;
        
        lcd.locate(0,1);
        lcd.printf("%.0fC %.0fC %c ho:ra", texterno, tinterno, modo);
          
        comp = tinterno;
        if(comp == temp)
            pc.printf("las temperaturas son iguales\n\r");
        else
            pc.printf("temperaturas distintas\n\r");
            wait(1);
    }
}