#include "mbed.h"
#include "TextLCD.h"
#include "AnalogIn.h"
#include "Serial.h"
#include <TimerEvent.h>

//clases
Ticker timeout;
Serial pc(USBTX, USBRX);
TextLCD lcd(PTD3, PTA12, PTA4, PTA5, PTC8, PTC9, TextLCD::LCD16x2);

//entradas
DigitalIn key1(PTE31),key2(PTE19), key3(PTE18), key4(PTE17);
InterruptIn Enable(PTA13);
AnalogIn externo(PTC2),interno(PTB3), presionin(PTB2), pident(PTB1);
AnalogOut vref(PTE30);
PwmOut pwmsal(PTD2);
DigitalOut evalvula(PTE1);
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

//declaracion de variables
char tipo, modo = 'M';
float tinterno, texterno, presion, casexterno, casinterno, caspresion, valorpwm, valorpid, vrefe;
float tres, optimo=0;
int i = 0, j = 0, sel = 1, hora=0, min=0, seg=0, horain = 8, minin = 0, horafin = 22, minfin = 0, temp = 26, cont=0, ev= 1;
int hh1, hh0, mm0, mm1, B1, B2, B3, B4, num, tempauto = 0, tipobanio = 0, pdig, sdig, tempmanual = 35, set = 0;
void menu();
void selec();
void func();

void attimeout()
{
    min++;
    if (min == 60) {
        min = 0;
        hora++;
    }
    if (hora == 24) {
        hora = 0;
        min = 0;
    }

}


void funpresion()                                              //funcion de vaciado llenado
{
    caspresion = presionin.read() * 3.3;
    pc.printf("analogin %.2f\n\r", caspresion);

    switch(tipobanio) {
        case 0:                             //baño rapido
            if(caspresion >= 2.2) {         //se lleno
                pc.printf("se lleno y apago ev\n\r");
                ev = 0;
            }
            if(caspresion <=  1.53) {        //se vacio
                cont++;
                pc.printf("se vacio\n\r");
                pc.printf("%d\n\r", cont);
                if(cont > 20) {           //contador
                    ev = 1;
                    cont = 0;
                    pc.printf("se activa la ev\n\r");
                }
            }
            break;
        case 1:                             //baño normal
            if(caspresion >= 2.6) {         //se lleno
                pc.printf("se lleno y apago ev\n\r");
                ev = 0;
            }
            if(caspresion <= 1.53) {        //se vacio
                cont++;
                pc.printf("se vacio\n\r");
                pc.printf("%d\n\r", cont);
                if(cont == 20) {           //contador
                    ev = 1;
                    cont = 0;
                    pc.printf("se activa la ev\n\r");
                }
            }
            break;
    }                                       //fin switch
    evalvula.write(ev);
}                                           //fin funcion

//recibe tension de referencia cambiar por que reciba la de el teclado o del externo
void modotemp()
{
    if (modo == 'A') {
        switch (tempauto) {

            case 0:
                if ((hora > horain||(hora == horain && min >= minin)) && ( hora < horafin ||(hora == horafin && min <= minfin))) {
                    optimo= -(11/10*texterno)+50;
                    if (optimo > 25 && optimo < 65) {
                        tres = optimo;
                    } else {
                        tres = tinterno;
                    }
                } else {
                    tres = tinterno;
                }
                break;
            case 1:
                if ((hora > horain||(hora == horain && min >= minin)) && ( hora < horafin ||(hora == horafin && min <= minfin))) {
                    optimo= -(11/10*texterno)+55;
                    if (optimo > 25 && optimo < 65) {
                        tres = optimo;
                    } else {
                        tres = tinterno;
                    }
                } else {
                    tres = tinterno;
                }
                break;
            case 2:
                if ((hora > horain||(hora == horain && min >= minin)) && ( hora < horafin ||(hora == horafin && min <= minfin))) {
                    optimo= -(11/10*texterno)+65;
                    if (optimo > 25 && optimo < 65 ) {
                        tres = optimo;

                    } else {
                        tres = tinterno;
                    }
                } else {
                    tres = tinterno;
                }
                break;
        }
    }
    if (modo == 'M') {
        tres = tempmanual;
    }
    vrefe = ((tres * 8 / 100) - 2) / 3.3;
    pc.printf("vrefe= %.2f tres= %.0f\n\r",vrefe, tres);
    wait(2);
}
//funcion del pwm

void pwm()
{
    if(vrefe <= 1 && vrefe >= 0) {
        vref.write(vrefe);
        pc.printf("vrefe= %.4f de salida vref\n\r",vrefe);
    }
    valorpid = pident.read() * 3.3;
    if(valorpid > 1 && ev == 0) {
        pwmsal.write(1);
        pc.printf("vrefe= %.4f del 1 if\n\r",vrefe);
        led_green = 0;
    } else if(valorpid <= 1 && valorpid >= 0.69 && ev == 0) {
        valorpwm = 2.5 * valorpid - 1.5;
        pc.printf("vrefe= %.4f del 2 if\n\r",vrefe);
        pwmsal.write(valorpwm);
        led_green = 0;
    } else if(valorpid <= 0.69) {
        pwmsal.write(0);
        pc.printf("vrefe= %.4f del else\n\r",vrefe);
        led_green = 1;

    }
    pc.printf("valorpid=%.4f\n\r",valorpid);
}

//funcion de set de hora
void sethora()
{
    if(i == 0) {                                                              //set de primer digito hora
        if(num > 2) {
            lcd.locate(0,0);
            lcd.printf("valor invalido");
            wait(.7);
            func();
        } else {
            hh1 = num;
            lcd.cls();
            lcd.printf("%dx:xx",hh1);
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            wait(.7);
            i++;
        }
    } else                                                                      //fin de set 1er digito hora ok
        if(i == 1) {
            //inicio 2do digito hora
            if(hh1 == 2 && num > 4) {
                lcd.locate(0,0);
                lcd.printf("valor invalido");
                wait(.7);
                func();
            } else {
                hh0 = num;
                lcd.cls();
                lcd.printf("%d%d:xx",hh1,hh0);
                lcd.locate(0,1);
                lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                wait(.7);
                i++;
            }
        } else                                                              //fin 2do digito hora
            if(i == 2) {                  //inicio 1er digito minuto
                if(num > 6) {
                    lcd.locate(0,0);
                    lcd.printf("valor invalido");
                    wait(.7);
                    func();
                } else {
                    mm1 = num;
                    lcd.cls();
                    lcd.printf("%d%d:%dx",hh1,hh0,mm1);
                    lcd.locate(0,1);
                    lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                    wait(.7);
                    i++;
                }
            } else                                                           //fin 2do digito minuto
                if(i == 3) {      //inicio 2do digito minuto
                    if(mm1 == 6) {
                        mm0 = 0;
                    } else {
                        mm0 = num;
                    }
                    lcd.cls();
                    lcd.printf("%d%d:%d%d",hh1,hh0,mm1,mm0);
                    lcd.locate(0,1);
                    lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                    i++;
                }                                                           //fin 2do digito minuto
}
// fin funcion set de hora

//funcion que imprime la hora
void imprimehora()
{
    lcd.locate(11,1);
    if(min < 10 && hora >= 10)
        lcd.printf("%2i:0%i", hora, min);
    if(hora < 10 && min >= 10)
        lcd.printf("0%i:%2i", hora, min);
    if(hora < 10 && min < 10)
        lcd.printf("0%i:0%i", hora, min);
    if(hora >= 10 && min >= 10)
        lcd.printf("%i:%i", hora, min);
}

//lectura de teclado y navegacion por menu
void func()
{
    led_red = 1;
    wait(.2);
    led_red = 0;
    B1 = key1.read();
    B2 = key2.read();
    B3 = key3.read();
    B4 = key4.read();
    num = 2*2*2*B1 + 2*2*B2 + 2*B3 + B4;
    if(num == 10) {
        set = 0;
        menu();
    } else if(num == 11) {
        set = 0;
        selec();
    } else if(num != 10 && num != 11) {


        switch(set) {
            case 0:
                break;
            case 1:                                                  //seteo hora  
                sethora();
                if(i == 4) {                                        //pasa la hora al reloj
                    hora = (hh1 * 10) + hh0;
                    min = (mm1 * 10) + mm0;
                    hh0 = hh1 = mm1 = mm0 = 0;
                    lcd.locate(0,0);
                    lcd.printf("reloj          ");
                    lcd.locate(0,1);
                    lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                    i = 0;
                }
                break;                                                              //fin pasa hora al reloj
            case 2:               //set temperaturas auto
                if(num == 0 || num == 1 || num == 2) {
                    tempauto = num;
                    lcd.locate(0,0);
                    if(num == 0)
                        lcd.printf("tipo frio    ");
                    else if(num == 1)
                        lcd.printf("tipo normal  ");
                    else
                        lcd.printf("tipo caliente");
                    wait(1);
                    lcd.cls();
                    lcd.printf("temperatura");
                    set = 0;
                } else {
                    lcd.locate(0,0);
                    lcd.printf("valor invalido");
                    wait(1);
                    lcd.printf("tipo banio");
                    lcd.cls();
                }
                break;
            case 3:                                                                         //tipo de baño
                if(num == 0 || num == 1) {
                    tipobanio = num;
                    lcd.locate(0,0);
                    if(num == 0)
                        lcd.printf("banio rapido  ");
                    else
                        lcd.printf("banio normal  ");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                    set = 0;
                } else {
                    lcd.locate(0,0);
                    lcd.printf("valor invalido");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                }
                break;
            case 4:                                                             //set de horarios
                sethora();
                if(i == 4 && j == 0) {                                          //pasa la hora al reloj
                    horain = (hh1 * 10) + hh0;
                    minin = (mm1 * 10) + mm0;
                    hh0 = hh1 = mm1 = mm0 = 0;
                    lcd.locate(0,0);
                    lcd.printf("horario         ");
                    lcd.locate(0,1);
                    lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                    i = 0;
                    j = 1;
                }
                if(i == 4 && j == 1) {                                        //pasa la hora al reloj
                    horafin = (hh1 * 10) + hh0;
                    minfin = (mm1 * 10) + mm0;
                    hh0 = hh1 = mm1 = mm0 = 0;
                    lcd.locate(0,0);
                    lcd.printf("horario         ");
                    lcd.locate(0,1);
                    lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
                    i = 0;
                    j = 0;
                }
                break;
            case 5:                                                 //set temperatura manual
                if(i == 0) {
                    pdig = num;
                } else if(i == 1) {
                    sdig = num;
                    tempmanual = (pdig * 10) + sdig;
                    if(tempmanual >= 65) {
                        tempmanual = 65;
                    }
                    if(tempmanual <= 25) {
                        tempmanual = 25;
                    }
                    imprimehora();
                    lcd.locate(0,0);
                    lcd.printf("temperatura a %d",tempmanual);
                    wait(1);
                    lcd.locate(0,0);
                    lcd.printf("temperatura     ");
                }
                i++;
                if(i == 2) {
                    i = 0;
                }
                break;
            case 6:                                                     //tipo de banio manual
                if(num == 0 || num == 1) {
                    tipobanio = num;
                    lcd.locate(0,0);
                    if(num == 0)
                        lcd.printf("banio rapido  ");
                    else
                        lcd.printf("banio normal  ");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                    set = 0;
                } else {
                    lcd.locate(0,0);
                    lcd.printf("valor invalido");
                    wait(1);
                    lcd.cls();
                    lcd.printf("tipo banio  ");
                }
                break;
        }
    }
}

//impresion de menu
void menu ()
{
    lcd.cls();
    imprimehora();
    switch (sel) {
        case 1:
            lcd.locate(0,0);
            lcd.printf("auto");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 2;
            break;
        case 2:
            lcd.locate(0,0);
            lcd.printf("manual");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 3;
            break;
        case 3:
            lcd.locate(0,0);
            lcd.printf("reloj");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 1;
            break;
        case 4:
            lcd.locate(0,0);
            lcd.printf("temperatura");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 5;
            break;
        case 5:
            lcd.locate(0,0);
            lcd.printf("tipo banio  ");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 6;
            break;
        case 6:
            lcd.locate(0,0);
            lcd.printf("horarios");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 9;
            break;
        case 7:
            lcd.locate(0,0);
            lcd.printf("temperatura");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 8;
            break;
        case 8:
            lcd.locate(0,0);
            lcd.printf("tipo banio  ");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 10;
            break;
        case 9:
            lcd.locate(0,0);
            lcd.printf("salir");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 4;
            break;
        case 10:
            lcd.locate(0,0);
            lcd.printf("salir");
            lcd.locate(0,1);
            lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
            sel = 7;
            break;
    }
}

void selec()
{
    switch (sel) {
        case 2:
            modo = 'A';
            sel = 4;
            menu();
            break;
        case 3:
            modo = 'M';
            sel = 7;
            menu();
            break;
        case 1:
            lcd.locate(0,0);
            lcd.printf("ingrese datos");
            set = 1;
            break;
        case 5:
            lcd.locate(0,0);
            lcd.printf(" 0_F 1_N 2_C");
            set = 2;
            break;
        case 6:
            lcd.locate(0,0);
            lcd.printf(" 0_rap 1_norm");
            set = 3;
            break;
        case 4:
            sel = 1;
            menu();                                                         //salida1
            break;
        case 8:
            lcd.locate(0,0);
            lcd.printf("ingrese temperat");
            set = 5;
            break;
        case 7:
            sel = 2;
            menu();
            break;
        case 9:
            set = 4;
            break;
        case 10:
            lcd.locate(0,0);
            lcd.printf(" 0_rap 1_norm");
            set = 6;
            break;
    }
}

//programa principal
int main()
{
    timeout.attach(&attimeout, 60);
    pc.baud(115200);
    Enable.rise(&func);

    while(1) {
        modotemp();

        imprimehora();

//convierte voltaje a temperatura
        casexterno = externo.read() * 3.3;
        texterno = (casexterno + 0.2) * 100 / 5;
        casinterno = interno.read() * 3.3;
        tinterno = (casinterno + 2) * 100 / 8;

        lcd.locate(0,1);
        lcd.printf("%.0fC %.0fC %c ", texterno, tinterno, modo);
        funpresion();
        pwm();
    }           //fin wile
}