#include "mbed.h"
#include "DHT11.h"
#include "HMC5883L.h"
#include "gps.h"

#define PRINT_CALCULATED
#define PRINT_SPEED 500 // 500 ms between prints


//-------Pin Connection----///
DHT11 sensor(D4);//D4= dht11 data
HMC5883L bouss(PB_9, PB_8); // HMC5883L(PinName sda, PinName scl) PB_8 + PB_9
Serial rfid(PA_9, PA_10); // pa9=d8 pa10=d2
Serial serial(PA_0,PA_1);  /*PA_0=A0=TX PA_1=A0=RX*/
AnalogIn inputx(PC_0); // input A5 for X axis
AnalogIn inputy(PC_1); // input A4 for Y axis
AnalogIn inputz(PB_1); // input A3 for Z axis

float x=0,y=0,z=0; // variables for x,y,z axes

int H, T, s;
float Boussole;
int Head;
char buff[55];
int RFIDA;

int DHT_Start_Temper()
{
    s = sensor.readData();
    T=sensor.readTemperature();
    return T;
}

int DHT_Start_Humid()
{
    s = sensor.readData();
    H=sensor.readHumidity();
    return H;
}


int Boussole_Start()
{
    //Head is divided by 2 because of sending data to actoboard the value is limit to 255
    bouss.init();
    Boussole= bouss.getHeadingXYDeg();
    Head=((int)Boussole)/2;
    serial.printf("\r\n-----Boussole-----\r\n%2f\r\n-----Boussole-----\r\n",Boussole);
    return Head;
}

int Accelerometre_Start_x()
{
    x = inputx;
    serial.printf("\r\n-----Accelerometre-----\r\nX:%f,Y: %f,Z: %f \r\n-----Accelerometre-----\r\n",x,y,z);
    return x;
}

int Accelerometre_Start_y()
{
    y = inputy;
    serial.printf("\r\n-----Accelerometre-----\r\nX:%f,Y: %f,Z: %f \r\n-----Accelerometre-----\r\n",x,y,z);
    return y;
}

int Accelerometre_Start_z()
{
    z = inputz;
    serial.printf("\r\n-----Accelerometre-----\r\nX:%f,Y: %f,Z: %f \r\n-----Accelerometre-----\r\n",x,y,z);
    return z;
}



void RFID_Start()
{
    int i;
    int tag[15];

    for(i=0; i<5; i++)
        tag[i]=rfid.getc();

    sprintf(buff,"%d%d%d%d%d",tag[0],tag[1],tag[2],tag[3],tag[4]);
    serial.printf("\r\n-----Tag RFID-----\r\n%s \r\n-----Tag RFID-----\r\n",buff);

}
//---------------

int main()
{
    //serial config
    serial.baud(9600);
    serial.format(8,SerialBase::None,1);

    serial.printf("\r\n Bracelet Orientation\r\n****************\r\n");

    char *p1lat, *p2lat, *p3lat;
    int intp1lat, intp2lat, intp3lat;
    char *p1long, *p2long, *p3long;
    int intp1long, intp2long, intp3long;


    while(1) {
        T=DHT_Start_Temper();
        H=DHT_Start_Humid();
        Head=Boussole_Start();
        x=Accelerometre_Start_x();
        y=Accelerometre_Start_y();
        z=Accelerometre_Start_z();
        getGPSstring();


        RFID_Start();
        RFIDA=atoi(buff);
        RFIDA=RFIDA/10000000;

        //traitement Latitude
        p1lat = strtok(lati,"'");
        p2lat= strtok(NULL, "'");//the second
        p3lat= strtok(NULL, ".");//the third    

        //conversion latitude
        intp1lat=atoi(p1lat);
        intp2lat=atoi(p2lat);
        intp3lat=atoi(p3lat);
        //concatcénation lati
        int latitude_complet_int;
        char latitude_complet[6];
        strcat(latitude_complet,p1lat);
        strcat(latitude_complet,p2lat);
        strcat(latitude_complet,p3lat);
        latitude_complet_int=atoi(latitude_complet);



        //traitement longitude
        p1long = strtok(longi,"'");
        p2long= strtok(NULL, "'");//the second
        p3long= strtok(NULL, ".");//the third
        intp1long=atoi(p1long);
        intp2long=atoi(p2long);
        intp3long=atoi(p3long);

        //concatcénation longitude
        int longitude_complet_int;
        char longitude_complet[6];
        strcat(longitude_complet,p1long);
        strcat(longitude_complet,p2long);
        strcat(longitude_complet,p3long);
        longitude_complet_int=atoi(longitude_complet);

        serial.printf("AT$SS=%x%x%x%x%x0%x%x%x%x%x\r\n",T,H,intp1lat,intp2lat,intp3lat,intp1long,intp2long,intp3long,RFIDA,Head);

        wait(5);
    }
}
