#include "mbed.h"
    
char lati[20], longi[20];
int Ilati, Ilongi;

Serial pc(PA_0,PA_1);       // tx, rx

char gpsString[1024];
char tmp[20] = {}; 
char tmp2[20] = {}; 
char gga1[1024];
char * gga2;
char * fix;
uint8_t sep;
uint8_t mode = 2; //mode=1 fix information; mode=2 normal

typedef struct {
    uint8_t heure;
    uint8_t minute;
    uint8_t seconde;
} tim_t;
 
typedef struct {
uint8_t deg;
uint8_t min;
double sec;
char azimute;
} pos_t;

typedef struct {
    tim_t tim;
    pos_t lat;
    pos_t lon;
    uint8_t sat; // Nombre de satellites utilisés pour calculer les coordonnées
    uint8_t fix; // Fix qualification : (0 = non valide, 1 = Fix GPS, 2 = Fix DGPS), Type de positionnement (le 1 est un positionnement GPS)
    float prs; // Précision horizontale ou HDOP (Horizontal dilution of precision)
    float alt; // Altitude, en Metres, au dessus du MSL (mean see level) niveau moyen des Océans.
    char unitAlt; // Unité de l'altitude (en mètre dans la majorité des trames)
} gps_t;

// structure contenant les données de la trame GGA à envoyer
gps_t GPGGA;

char * convert(char* ch, pos_t* pos) {
    
    double f = atof(ch);
    
    pos->deg = (uint8_t)(f / 100.0);
    pos->min = (uint8_t)(f - ((pos->deg) * 100.0));
    pos->sec = 60.0*(f - ((pos->deg)*100.0) - (pos->min));
    
    char *s = (char*)calloc(14,sizeof(char));
    
    sprintf(s,"%3d'%2d'%5.3f\"",pos->deg,pos->min,pos->sec);
    
    return s;
}

char * time(char* ch, tim_t* tim) {
    
    char hh[3], mm[3], ss[7];
    //hhmmss.nnn
    memcpy(hh, &ch[0], 2);
    memcpy(mm, &ch[2], 2);
    memcpy(ss, &ch[4], 6);
    
    tim->heure = atoi(hh); 
    tim->minute = atoi(mm); 
    tim->seconde = atoi(ss); //cast de double vers intteger, on perd la précision des millisecondes
    tim->heure++; //convertion des heures de UTC vers UTC+1
    
    char *s = (char*)calloc(14,sizeof(char)); 
    
    sprintf(s,"%02d:%02d:%02d",tim->heure,tim->minute,tim->seconde); 
    
    return s;
}
/**************************************/


uint8_t parseGGA() {
                    gga2 = strtok(gga1, ",");
                    while (gga2 != NULL) {                        
                        switch (sep) {
                            case 1: // heure d'envoi de la trame
                                if (mode == 2) {
                                    strcpy(tmp2,time( gga2,&(GPGGA.tim) ));
                                    pc.printf("\r\n-----Donnees GPS-----\r\nTim: %s\r\n",tmp2);                                   
                                    
                                }
                            break;
                            case 2 : // latitude
                                if (mode == 2) {
                                    strcpy(tmp,convert( gga2,&(GPGGA.lat) )); 
                                    sprintf(lati,"\r%s",tmp);
                                    pc.printf("\r%s",lati);
                                    
                                }
                            break;
                            case 3 : // N: Nord, S : Sud
                                if (mode == 2) {
                                    GPGGA.lat.azimute = gga2[0];
                                    pc.printf("%s\n\r",gga2);
                                    wait(0.25);
                                }
                            break;
                            case 4 : // longitude
                                if (mode == 2) {
                                    strcpy(tmp,convert( gga2,&(GPGGA.lat) ));
                                    sprintf(longi,"\r%s",tmp);
                                    pc.printf("\r%s",longi);
                                }
                            break;
                            case 5 : // E: Est, W: Ouest
                                if (mode == 2) {
                                    GPGGA.lat.azimute = gga2[0];
                                    pc.printf("%s\n\r-----Donnees GPS-----\r\n",gga2);
                                    
                                    wait(0.25);
                                }
                            break;
                            case 6:
                                if (mode == 1) {
                                    if (gga2 == "0") {
                                        fix = "Invalid";
                                    }
                                    if (gga2 == "1") {
                                        fix = "GPS Fix (SPS)";
                                    }
                                    if (gga2 == "2") {
                                        fix = "DGPS Fix";
                                    }
                                    if (gga2 == "3") {
                                        fix = "PPS Fix";
                                    }
                                    if (gga2 == "4") {
                                        fix = "Real Time Kinematic";
                                    }
                                    if (gga2 == "5") {
                                        fix = "Float RTK";
                                    }
                                    if (gga2 == "6") {
                                        fix = "Estimated (Dead Reckoning)";
                                    }
                                    if (gga2 == "7") {
                                        fix = "Manual Input Mode";
                                    }
                                    if (gga2 == "8") {
                                        fix = "Simulation Mode";
                                    }
                                    GPGGA.fix = atoi(gga2);
                                    pc.printf("FIX: %s_%s",gga2,fix);
                                }
                            break;
                            case 7 : // Nombre de satellites
                                if (mode == 2) {
                                    GPGGA.sat = atoi(gga2);
                                    pc.printf("Inf: Sat:%s",gga2);
                                }
                            break;
                            case 8 : // Precision
                                if (mode == 2) {
                                    GPGGA.prs = atof(gga2);
                                    pc.printf(" Prs:%s",gga2);
                                }
                            break;
                            case 9 : // Altitude
                                if (mode == 2) {
                                    GPGGA.alt = atof(gga2);
                                    pc.printf(" Alt:%s",gga2);
                                }
                            break;
                            case 10 : // Unité altitude
                                if (mode == 2) {
                                    GPGGA.unitAlt = gga2[0];
                                    pc.printf("%s\n\r",gga2);
                                }
                            break;
                        }                        
                        gga2 = strtok(NULL, ",");
                        sep++;
                    }
                    sep = 1;
    return *gga2;
    
}

uint8_t getGPSstring() { // str used to choose between GPS trame type, here we have only GPGGA wich is available
uint8_t str=1; 
    if (pc.scanf("%s", &gpsString) ==1) {
       if(str==1) {
            if (sscanf(gpsString, "$GPGGA,%s",gga1) >=1) 
            {
                sep = 1;              
                parseGGA();
            }
        return *gga2;
        }
    }
    else
    {
        pc.printf("NO GPGGA DATA RECEIVED\n\r");        
    }
    return 0;
}

