#include "mbed.h"
#include "DHT11.h"
#include "HMC5883L.h"



//-------Pin Connection----///
DHT11 sensor(D4);//D4=jeremy
HMC5883L bouss(PB_9, PB_8); // HMC5883L(PinName sda, PinName scl) PB_8 + PB_9
Serial rfid(PA_9, PA_10); // pa9=d8 pa10=d2
AnalogIn inputx(PC_0); // input PC_0 for X axis
AnalogIn inputy(PC_1); // input PC_1 for Y axis
AnalogIn inputz(PB_1); // input PB_1 for Z axis
//---------------

int main()
{
    //serial config
    Serial serial(PA_0,PA_1);  /*PA_0=A0=TX PA_1=A0=RX*/
    serial.baud(9600);
    serial.format(8,SerialBase::None,1);
    serial.printf("\r\nDHT Test program");
    serial.printf("\r\n****************\r\n");
    //char tmp[30];//="AT$SS=00 12 FF 42 \r\n";//$SS 
    float x=0,y=0,z=0; // variables for x,y,z axes
    
    
    while(1){

//----------------DHT/start------------------//
    int s,T,H;
    s = sensor.readData();
    T=sensor.readTemperature();
    H=sensor.readHumidity();
    if (s != DHT11::OK) {
        serial.printf("Error!\r\n");
    }
    else {
        serial.printf("AT$SS=%x%x\r\n", T,H);
    }
//----------------DHT/end------------------//

//----------------Boussole/start------------------//
bouss.init();
double test=5;
test= bouss.getHeadingXYDeg(); 
serial.printf("\r\n%2f\r\n",test);
//----------------Boussole/end------------------//

//----------------Accelerometre/start------------------//
        x = inputx;
        y = inputy;
        z = inputz;
        serial.printf("X:%f,Y: %f,Z: %f *\r\n",x,y,z); 
//----------------Accelerometre/end------------------//
    
    
//-----------------------RFID----------------------------//
 #define PRINT_CALCULATED
 #define PRINT_SPEED 500 // 500 ms between prints
     serial.printf("Verification\r\n");

     int i;
     int tag[15];
     char buff[55];


         for(i=0;i<5;i++)
             tag[i]=rfid.getc();

         sprintf(buff,"%d%d%d%d%d",tag[0],tag[1],tag[2],tag[3],tag[4]);
         serial.printf("%s \r\n",buff);

//-----------------------RFID----------------------------//

    wait(5);
}
}
