// Provide a serial pass-through between the PC and an external UART
 
#include "mbed.h"

Serial pc(PA_0,PA_1);       // tx, rx
//Serial gps(PA_9, PA_10);       // tx, rx

uint8_t buffer[64]; // buffer array for data receive over serial port
uint8_t count=0; 

typedef struct {
uint8_t heure;
uint8_t minute;
uint8_t seconde;
} temps;
 
typedef struct {
uint8_t degre;
uint8_t minut;
double secon;
char azimut;
} latitude;
 
typedef struct {
uint8_t degre;
uint8_t minut;
double secon;
char azimut;
} longiture;

void initSerial()
{
        pc.baud(9600);
        pc.format(8,SerialBase::None,1);
        //gps.baud(9600);
        //gps.format(8,SerialBase::None,1);
}

void clearBufferArray() // function to clear buffer array
{
    for (int i=0; i<count;i++)
    {
        buffer[i]=NULL;
    } // clear all index of array with command NULL
}

void writeBufferArray()
{
    for (int i=0; i<count;i++)
    {
        pc.putc(buffer[i]);
    } // write all index of array
}

int main() 
{
    initSerial();
    while(1)
    {
        temps tmp;
        if (pc.readable())                     // if date is coming from software serial port ==> data is coming from SoftSerial shield
        {
            while(pc.readable())               // reading data into char array
            {
                buffer[count++]=pc.getc();      // writing data into array
                if(count == 64)break;
            }
            /*
            if (sscanf(buffer, "$GPGGA, %2d%2D%lf", &tmp.heure, &tmp.minute, &tmp.seconde) == 3)
            {
                pc.printf("%dh, %dm, %fs\n", tmp.heure, tmp.minute, tmp.seconde);
            }
            else
            {
                pc.printf("error parsing message bro\n");
            }
            */
            
            writeBufferArray();
            //pc.write(buffer,count); // if no data transmission ends, write buffer to hardware serial port
            clearBufferArray(); // call clearBufferArray function to clear the stored data from the array
            count = 0;          // set counter of while loop to zero
     
     
        }
        //if (Serial.available())                 // if data is available on hardware serial port ==> data is coming from PC or notebook
        //SoftSerial.write(Serial.read());        // write it to the SoftSerial shield
    }
 
}
