#include "mbed.h"
#include "DHT11.h"

DHT11 sensor(D4);



//---------------
int main()
{
    //serial config
    Serial serial(PA_0,PA_1);  /*PA_0=A0=TX PA_1=A0=RX*/
    serial.baud(9600);
    serial.format(8,SerialBase::None,1);
    serial.printf("\r\nDHT Test program");
    serial.printf("\r\n****************\r\n");
    //char tmp[30];//="AT$SS=00 12 FF 42 \r\n";//$SS
    
    
    while(1){

    int s,T,H;
    s = sensor.readData();
    T=sensor.readTemperature();
    H=sensor.readHumidity();
    if (s != DHT11::OK) {
        serial.printf("Error!\r\n");
    }
    else {
        serial.printf("AT$SS=%x%x\r\n", T,H);
    }
    
    wait(60);
}
}
