#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "ds1338.h"
#include "horloge.h"
#include "Ecran.h"
#include "SDFileSystem.h"
//définition de la zone tactile dans l'ecran principal
#define TOUCHADMINISTRATEUR ((TS_State.touchDetected) && ( TS_State.touchX[0]>0) &&( TS_State.touchX[0]< 240)&& ( TS_State.touchY[0]>0) && (TS_State.touchY[0] < 272))
#define TOUCHUTILISATEUR ((TS_State.touchDetected) && ( TS_State.touchX[0]> 240) &&( TS_State.touchX[0]< 480)&& ( TS_State.touchY[0]> 0) && (TS_State.touchY[0] < 272))

// définitions des touches tactiles qui interviennent dans l'écran 1
#define TOUCHTIMEDATE ((TS_State.touchDetected) && ( TS_State.touchX[0]>10) && (TS_State.touchX[0]< 165)&& (TS_State.touchY[0]>50) && (TS_State.touchY[0] < 180))
#define TOUCHFREQ ((TS_State.touchDetected) && ( TS_State.touchX[0]>170) && (TS_State.touchX[0]< 328)&& (TS_State.touchY[0]>60) && (TS_State.touchY[0] < 180))        
#define TOUCHAFFICHAGE ((TS_State.touchDetected) && ( TS_State.touchX[0]>333) &&( TS_State.touchX[0]< 475)&& ( TS_State.touchY[0]> 60) && (TS_State.touchY[0] < 180))

//définitions des touches tactiles qui intervient dans les écrans paramettrable  
#define TOUCHRETOUR ((TS_State.touchDetected) && ( TS_State.touchX[0]>30) &&( TS_State.touchX[0]< 110)&& ( TS_State.touchY[0]> 210) && (TS_State.touchY[0] < 240))
#define TOUCHMoins ((TS_State.touchDetected) && ( TS_State.touchX[0]>145) &&( TS_State.touchX[0]< 225)&& ( TS_State.touchY[0]> 210) && (TS_State.touchY[0] < 240))
#define TOUCHPlus ((TS_State.touchDetected) && ( TS_State.touchX[0]> 245) &&( TS_State.touchX[0]< 325)&& ( TS_State.touchY[0]> 210) && (TS_State.touchY[0] < 240))
#define TOUCHOK ((TS_State.touchDetected) && ( TS_State.touchX[0]> 360) &&( TS_State.touchX[0]< 440)&& ( TS_State.touchY[0]> 210) && (TS_State.touchY[0] < 240))

//définitions des touches tactiles pour régler l'heure et la date 
#define TOUCHDAY ((TS_State.touchDetected) && ( TS_State.touchX[0]> 30) &&( TS_State.touchX[0]< 85)&& ( TS_State.touchY[0]> 82) && (TS_State.touchY[0] < 110))       
#define TOUCHMonth ((TS_State.touchDetected) && ( TS_State.touchX[0]> 100) &&( TS_State.touchX[0]< 160)&& ( TS_State.touchY[0]> 82) && (TS_State.touchY[0] < 110))           
#define TOUCHYear ((TS_State.touchDetected) && ( TS_State.touchX[0]> 170) &&( TS_State.touchX[0]< 240)&& ( TS_State.touchY[0]> 82) && (TS_State.touchY[0] < 110))    
#define TOUCHHour ((TS_State.touchDetected) && ( TS_State.touchX[0]> 30) &&( TS_State.touchX[0]< 60)&& ( TS_State.touchY[0]> 164) && (TS_State.touchY[0] < 204))    
#define TOUCHMinute ((TS_State.touchDetected) && ( TS_State.touchX[0]> 100) &&( TS_State.touchX[0]< 159)&& ( TS_State.touchY[0]> 164) && (TS_State.touchY[0] < 204))    
#define TOUCHSeconde ((TS_State.touchDetected) && ( TS_State.touchX[0]> 172) &&( TS_State.touchX[0]< 240)&& ( TS_State.touchY[0]> 164) && (TS_State.touchY[0] < 204))  

//définition des touches tactiles pour le réglage de la fréquence d'envoi des données sur la carte SD 
#define TOUCHAcquire ((TS_State.touchDetected) && ( TS_State.touchX[0]> 25) &&( TS_State.touchX[0]< 175)&& ( TS_State.touchY[0]> 115) && (TS_State.touchY[0] < 145))
#define TOUCHPerDay ((TS_State.touchDetected) && ( TS_State.touchX[0]> 245) &&( TS_State.touchX[0]< 405)&& ( TS_State.touchY[0]> 115) && (TS_State.touchY[0] < 145))
#define TOUCHPerWeek ((TS_State.touchDetected) && ( TS_State.touchX[0]> 25) &&( TS_State.touchX[0]< 175)&& ( TS_State.touchY[0]> 155) && (TS_State.touchY[0] < 185))
#define TOUCHPermonth ((TS_State.touchDetected) && ( TS_State.touchX[0]> 245) &&( TS_State.touchX[0]< 405)&& ( TS_State.touchY[0]> 155) && (TS_State.touchY[0] < 185))  

//définition de l'attente avant l'affichage d'un nouvel écran
#define ATTENTE wait(0.2);

// définition des touche des chiffres pour la saisie du mot passe

#define TOUCH1 (( TS_State.touchDetected) && ( TS_State.touchX[0]>135) &&( TS_State.touchX[0]<185)&& ( TS_State.touchY[0]>90) && (TS_State.touchY[0]<115))
#define TOUCH2 (( TS_State.touchDetected) && ( TS_State.touchX[0]>215) &&( TS_State.touchX[0]<260)&& ( TS_State.touchY[0]>90) && (TS_State.touchY[0]<115))
#define TOUCH3 (( TS_State.touchDetected) && ( TS_State.touchX[0]>295) &&( TS_State.touchX[0]<345)&& ( TS_State.touchY[0]>90) && (TS_State.touchY[0]<115))
#define TOUCH4 (( TS_State.touchDetected) && ( TS_State.touchX[0]>135) &&( TS_State.touchX[0]<185)&& ( TS_State.touchY[0]>130) && (TS_State.touchY[0]<155))
#define TOUCH5 (( TS_State.touchDetected) && ( TS_State.touchX[0]>215) &&( TS_State.touchX[0]<260)&& ( TS_State.touchY[0]>130) && (TS_State.touchY[0]<155))
#define TOUCH6 (( TS_State.touchDetected) && ( TS_State.touchX[0]>295) &&( TS_State.touchX[0]<345)&& ( TS_State.touchY[0]>130) && (TS_State.touchY[0]<155))
#define TOUCH7 (( TS_State.touchDetected) && ( TS_State.touchX[0]>135) &&( TS_State.touchX[0]<185)&& ( TS_State.touchY[0]>170) && (TS_State.touchY[0]<195))
#define TOUCH8 (( TS_State.touchDetected) && ( TS_State.touchX[0]>215) &&( TS_State.touchX[0]<260)&& ( TS_State.touchY[0]>170) && (TS_State.touchY[0]<195))
#define TOUCH9 (( TS_State.touchDetected) && ( TS_State.touchX[0]>295) &&( TS_State.touchX[0]<345)&& ( TS_State.touchY[0]>170) && (TS_State.touchY[0]<195))
#define TOUCHVALID (( TS_State.touchDetected) && ( TS_State.touchX[0]>210) &&( TS_State.touchX[0]<280)&& ( TS_State.touchY[0]>210) && (TS_State.touchY[0]<235))
/////affichage de l'heure
#define TOUCHSHOWTIME ((TS_State.touchDetected) && ( TS_State.touchX[0]>395 ) &&( TS_State.touchX[0]<475)&& ( TS_State.touchY[0]>10) && (TS_State.touchY[0] <40)) 

int affiche=0;
int password=0;


TS_DISCO_F746NG ts;  

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);
                  
  int main()
  {
    unsigned int day =00;
unsigned int month =00;
unsigned int year=2000;
unsigned int hour =00;
unsigned int min =00;
unsigned int sec=00;
    SDFileSystem sd(D11,D12,D13 , D3, "sd");
    AnalogIn Vpan(A0);
    AnalogIn Ipan(A1);
    AnalogIn Tpan(A2);
    AnalogIn Irr(A3);
    AnalogIn Vbat(A4);
    AnalogIn Ibat(A5);
    DS1338 ds1338(D14,D15);
    LCD_DISCO_F746NG lcd;
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"WELCOME TO LAOS PROJET", CENTER_MODE);  
    wait(1); 
    affiche=1; 
    
    struct tm time;
       
    
      TS_StateTypeDef TS_State;
      ts.Init(480, 272);
      
    time.tm_sec=0;
    time.tm_min=28;
    time.tm_hour=11;
    time.tm_mday=19;
    time.tm_year=116;
    time.tm_mon=9;
    time.tm_wday=3;
    time.tm_yday=0;
    time.tm_isdst=0;
    ds1338.writeTime(&time);
    
          while(1)
      {
         ts.GetState(&TS_State);  
        
         ds1338.readTime(&time);
        
         
    typedef enum  {etat0, etat1,etat_reg_minute, etat_mot_de_passe,Etat_ecran_affichage,Etat_ecranUtilis,etat3,etat2, etat_reg_day, etat_reg_month,etat_reg_year, etat_reg_hour} type_etat;
    static type_etat etat= etat0;
    
    switch (etat)
         { 
         case etat0:
         if (affiche==1)
          { 
           Ecranprincipal ();
           affiche=0;
          }  

         if (TOUCHUTILISATEUR)
            { 
          etat= Etat_ecranUtilis;
          affiche=1;
           ATTENTE
             }  
             
          if (TOUCHADMINISTRATEUR)
             { 
             etat= etat_mot_de_passe;
             affiche=1;
             ATTENTE
             }               
             break;
//////////////////////Mot de passe///////////////////////
               
             case etat_mot_de_passe:
             if(affiche==1)
          { 
          MotDePasse ();
          affiche=0;
         password=0;
          }  
         if (TOUCH2)
          {
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.DisplayStringAt(180, LINE(1), (uint8_t *)"*",LEFT_MODE);
                password=2;}
         if(password==2&&TOUCH7)
           {
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.DisplayStringAt(210, LINE(1), (uint8_t *)"*",LEFT_MODE);
                    password=7;}
         if(password==7&&TOUCH5)
              {
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.SetTextColor(LCD_COLOR_BLACK);
                lcd.DisplayStringAt(240, LINE(1), (uint8_t *)"*",LEFT_MODE);
                password=5;}
         if(password==5&&TOUCHVALID)
         {
            etat= etat1;
             affiche=1;
            ATTENTE
             }
             
         if ( TOUCH1|| TOUCH3 || TOUCH4 || TOUCH6|| TOUCH8|| TOUCH9)
       
           { 
           lcd.SetBackColor(LCD_COLOR_WHITE);
           lcd.SetTextColor(LCD_COLOR_BLACK);
           lcd.DisplayStringAt(140, LINE(2), (uint8_t *)"pass invalid",LEFT_MODE); 
           wait (1);
           affiche=1;
           
          if(affiche==1)
          { 
          MotDePasse ();
          affiche=0;
         password=0;
          } 
           }
           if(TOUCHRETOUR)
           {
              etat= etat0;
             affiche=1;
             ATTENTE
            } 
             break;
             
             ////////////////////////////////////////////////////////
             
           case etat1: 
          if (affiche==1)
          { 
           ATTENTE
           EcranAdminis ();
            
           affiche=0;
            }  

           if (TOUCHTIMEDATE)     
             {
              etat= etat2;
             affiche=1; 
             }
           if  (TOUCHFREQ) 
           {
             etat= etat3;
             affiche=1; 
            } 
          if (TOUCHAFFICHAGE)
             {
               ATTENTE
              etat=Etat_ecran_affichage;
              affiche=1;
             }
          if (TOUCHSHOWTIME)     
             {
              reg_time();
              affiche=1; 
             }    
          if (TOUCHRETOUR)
              {
                etat= etat0;
                affiche=1;
                 ATTENTE;
              }   
          break;
          
         case etat2:   
            if (affiche==1)
            { 
            Ecran2();
            affiche=0;
            }  
            if (TOUCHRETOUR)
              {
                etat= etat1;
                affiche=1;
                 ATTENTE
              }
               if (TOUCHDAY)
                {
             etat= etat_reg_day;
             affiche=1; 
            } 
              if (TOUCHMonth)
             {
               etat=etat_reg_month; 
               affiche=1; 
             }
           if (TOUCHYear)
             {
               etat=etat_reg_year; 
               affiche=1; 
             }
              if (TOUCHHour)
             {
               etat=etat_reg_hour; 
               affiche=1; 
             } 
              if (TOUCHMinute)
             {
               etat=etat_reg_minute; 
               affiche=1; 
             }
              if (TOUCHRETOUR)
              {
                etat= etat1;
                affiche=1;
                ATTENTE
              } 
           if (TOUCHSeconde)
             {
               time.tm_sec=0; 
               affiche=1; 
             } 
             if (TOUCHSHOWTIME)     
             {
              reg_time();
              affiche=1; 
             }           
          break;
          
      
      
           
            
         case etat_reg_day:   
            if (affiche==1)
            {   
            Ecran2_Day();
            affiche=0;
            }
            
            if(TOUCHPlus){
                 day=day+1;
                 ATTENTE
                 Ecran2_Day();
                 if(day>30) day=0;
            }
            if(TOUCHMoins)
             {
                 day=day-1;
                 wait (0.3);
                 Ecran2_Day();
                 if(day<2) day=32;
             }    
           if ( (TOUCHOK)||(TOUCHRETOUR) )
              {
                etat= etat2;
                affiche=1;
                 ATTENTE
              }
       break;
           
         case etat_reg_month:   
            if (affiche==1){   
                Ecran2_Month();
                affiche=0;
                }
            if(TOUCHPlus)
             {
                 month=month+1;
                  ATTENTE
                 Ecran2_Month();
                 if(month>11) month=0;
                 }
            if(TOUCHMoins)
             {
                  month=month-1;
                  ATTENTE
                 Ecran2_Month();
                  if(month<2) month=13;
                 
            }
            if ( (TOUCHOK)|| (TOUCHRETOUR))
              {
                etat= etat2;
                affiche=1;
                 ATTENTE
              }    
              
          break;
       case etat_reg_year:   
              if (affiche==1){  
                  Ecran2_Year ();
                  affiche=0;
                   }          
            
                if(TOUCHPlus)
                 {
                   year=year+1;
                   ATTENTE
                     Ecran2_Year();
                   if(year>3000) year=2000;
                 }
                if(TOUCHMoins)
                  {
                   year=year-1;
                   ATTENTE
                   Ecran2_Year();
                   if(year<2000) year=3000;
                   }
                if ((TOUCHOK) ||(TOUCHRETOUR))
                  {
                   etat= etat2;
                   affiche=1;
                   ATTENTE
                  }      
           
       break;
       
        case etat_reg_hour:   
            if (affiche==1){  
                affiche=0;
                Ecran2_Hour();
            }     
            
                if(TOUCHPlus){
                    hour=hour+1;
                    ATTENTE
                     Ecran2_Hour();
                    if(hour>22) hour=0;
                }
                if(TOUCHMoins){
                    hour=hour-1;
                    ATTENTE
                     Ecran2_Hour();
                    if(hour<1) hour=24;
                }
            
            if ((TOUCHOK)||(TOUCHRETOUR)){
                etat= etat2;
                affiche=1;
                ATTENTE
            }        
       break;  
       
       
       case etat_reg_minute:   
            if (affiche==1)
            {   Ecran2_Minutes();
                 affiche=0;
              } 
           
            if(TOUCHPlus)
             {
                 min=min+1;
                 ATTENTE
                 Ecran2_Minutes();
                 if(min>58) min=0;
                 }
            if(TOUCHMoins)
             {
                min=min-1;
                wait (0.3);
                 Ecran2_Minutes();
                if(min>2) min=59;
                 }
            if ((TOUCHOK) || (TOUCHRETOUR)){
                etat= etat2;
                affiche=1;
                ATTENTE
            }              
       break;  
        case etat3: 
         if (affiche==1)
         { 
             Ecran3();
             affiche=0;
          } 
          
          if(TOUCHAcquire)
            {
                printf("debut d'acquisition!\n");   
 
                mkdir("/sd/mydir", 0777);
    
                FILE *fp = fopen("/sd/mydir/Aquisition panneau.txt", "w");
                if(fp == NULL) {
                    error("Could not open file for write\n");
                             }
                       fprintf(fp,"valeur d'irradiation %f\n",Vpan.read()*3.3);
                       fprintf(fp," valeur tension panneau %f\n",Ipan.read()*3.3);
                       fprintf(fp," valeur temperature panneau %f\n",Tpan.read()*3.3);
                       fprintf(fp," valeur irradiation panneau %f\n",Irr.read()*3.3);
                       fprintf(fp," valeur tension batterie %f\n",Vbat.read()*3.3);
                       fprintf(fp," valeur courant batterie %f\n",Ibat.read()*3.3);
                       fclose(fp); 
 
                         printf("acquisition reussi!\n");
                         
            }   
            if (TOUCHSHOWTIME)     
             {
              reg_time();
              affiche=1; 
             }      
          if (TOUCHRETOUR)
              {
                etat= etat1;
                affiche=1;
                 ATTENTE
              }
        break;
    /////////////////
        case Etat_ecran_affichage:
         if (((Vpan.read())||(Ipan.read())||(Tpan.read())||(Irr.read())||(Vbat.read())||(Ibat.read()))&&affiche==1)
        { 
           EcranUtilis_ok();
           affiche=0;
          
        } if(~((Vpan.read())||(Ipan.read())||(Tpan.read())||(Irr.read())||(Vbat.read())||(Ibat.read()))&&affiche==1)
        {   
               EcranUtilis_fail();
                affiche=0;
               }
        if (TOUCHSHOWTIME)     
             {
              reg_time();
              affiche=1; 
             }    
         if (TOUCHRETOUR)
          {
          etat= etat1;
          affiche=1;
           ATTENTE
          }
        break; 
        /////////////
         case Etat_ecranUtilis:
         if (((Vpan.read())||(Ipan.read())||(Tpan.read())||(Irr.read())||(Vbat.read())||(Ibat.read()))&&affiche==1)
        { 
           EcranUtilis_ok();
           affiche=0;
          
        }else if(affiche==1){   
               EcranUtilis_fail();
                affiche=0;
               }
        if (TOUCHSHOWTIME)     
             {
              reg_time();
              affiche=1; 
             }    
         if (TOUCHRETOUR)
          {
          etat= etat0;
          affiche=1;
           ATTENTE
          }
        break; 
       }   
     } 
   }

   