/*
Carte: Hublex_lock V1.5 avec modification hardware port CS de la flash --> port 26 au lieu du port 25
Gyropode : Carte Hublex V2.6
Changer de badge administrateur --> modifier variable tag_su

Fonctionnement :

Appuyer sur le bouton poussoir met en route le système.

Badger avec un tag autorisé pour utiliser le gyropode.

Pour entrer dans la phase d’ajout de nouveaux utilisateurs il suffit de maintenir le badge administrateur durant 5 secondes sur le lecteur, puis scanner les différents badges à autoriser.

Pour réinitialiser le système et effacer tous les utilisateurs ajoutés, il faut maintenir le badge administrateur durant 10 secondes sur le lecteur.

By Yoann ARNOULD || Jean Mezyr
Tuteur de projet : Gilles Raynaud
S4' 2017







*/

#include "mbed.h"
#include "RFIDer.h"
#include "S25FL216K.h"
// Clignotement led ticker
Ticker clignotement_led;
Ticker clignotement_led2;
Ticker clignotement_RAZ;


S25FL216K flash(PA_7,PA_6,PA_5,PB_3);
RFIDer RFID_reader(PA_8, PA_10, PA_9);
DigitalOut io1(PA_0);
DigitalOut io2(PA_1);
DigitalOut io3(PA_4);
DigitalOut io4(PA_11);
DigitalOut led(PB_0);
Serial PC(USBTX,USBRX);

// Prototypes des fonctions utilises //
void RFID_init(void);
bool read_flash_and_valid_tag(void);
void save_tag_flash(void);
int get_tag (void);
void automate(void);
void  flip (void);
void  flip2 (void);
void  flip3 (void);
void read_all_tag_flash(void);

// Declaration des variables globales
int tag;
char* tag_char;
bool flag=1;
bool flip_led, flip_led_2, flip_led_RAZ;
bool time_count;
int var_time;
bool tag_su_bool;
int tag_su=14007229;
char flash_read;
char flash_write;
bool tag_read_valid;
bool flag_printf=1;


 

int main ()
{ 
    //Gestion clignotement de la led du bp
    clignotement_led.attach(&flip, 1.0);
    clignotement_led2.attach(&flip2, 0.2);
    clignotement_RAZ.attach(&flip3, 0.05);

    while(1) {
        automate();
    }
}

void automate(void)
{
    // Les differents etats de l'automate
    // -------------------------------------------------------------------------
    typedef enum {etat_init=0, scan_rfid=1, get_rfid_tag=2, verif_tag=3, start_gyro=4, wait_add_user=5, wait_reset_user=6, scan_rfid_add_user=7, add_user=8, raz_user=9, Tag_no_valid=10} type_etat;
    type_etat etat_actuel;
    static type_etat etat_futur=etat_init;


    // gestion du diagramme de transition\\
    // ----------------------------------
    etat_actuel = etat_futur;
    
    switch(etat_actuel) {

        case etat_init :

            etat_futur = scan_rfid;

            break;

        case scan_rfid :

            if(RFID_reader.isTagAvailable())
                etat_futur = get_rfid_tag;
                
            break;

        case get_rfid_tag :
        
            etat_futur = verif_tag;
            
            break;

        case verif_tag :

            if(tag_read_valid||tag==tag_su)
                etat_futur = start_gyro;
            else {
                etat_futur = Tag_no_valid;
            }
            
            break;

        case start_gyro :
        
            if(tag==tag_su)
                etat_futur = wait_add_user;
                
            break;

        case Tag_no_valid:
        
            etat_futur = scan_rfid;
            
            break;

        case wait_add_user :
        
            if(var_time>5) {
                etat_futur = wait_reset_user;
            } else {
                etat_futur = start_gyro;
            }
            
            break;

        case wait_reset_user :
        
            if(var_time>10) {
                etat_futur = raz_user;
            }
            if(var_time==0) {
                etat_futur = scan_rfid_add_user;
            }
            
            break;

        case scan_rfid_add_user :
        
            if(RFID_reader.isTagAvailable())
                etat_futur = add_user;

            break;

        case add_user :
        
            etat_futur = scan_rfid_add_user;
            
            break;

        case raz_user :
        
            etat_futur = etat_init;
            
            break;

    }

// gestion des sorties
    // -------------------
    switch(etat_actuel) {

        case etat_init :
            RFID_init();
            led=1;
            
            break;

        case scan_rfid :

            flip_led=1;
            
            break;

        case get_rfid_tag :

            tag=get_tag();
            printf("tag read RFID=%d\n\r",tag);
            if(tag!=tag_su)
                tag_read_valid=read_flash_and_valid_tag();

            break;

        case verif_tag :
        
            flip_led=0;
            flag=1;
            
            break;

        case start_gyro :
        
            led=1;
            time_count=1;

            if(flag) {
                io2=1;
                io3=0;
                flag=0;
            }
            if(tag==tag_su) {
                tag_su_bool=1;
            }
            
            break;

        case Tag_no_valid :
        
            if(flag) {
                io3=1;
                io2=0;
                flag=0;
                led=0;
            }
            flip_led_2=1;
            wait(2);
            flip_led_2=0;
            
            break;


        case wait_reset_user :
        
            flip_led_2=1;

            break;


        case scan_rfid_add_user :

            flip_led_2=1;
            if(flag_printf)
                printf("attente du badge\n\r");
            flag_printf=0;

            break;

        case add_user :

            bool tag_already_save=0;
            tag=get_tag();
            tag_already_save=read_flash_and_valid_tag();
            printf("tag_already_save= %d\n\r",tag_already_save);
            if(tag_already_save==0) {
                printf("user_add\n\r");
                save_tag_flash();
                flip_led_2=0;
                led=1;
                wait(3);
                led=0;
            }
            
            break;

        case raz_user :

            bool flash_eraseChip;

            flip_led_2=0;
            flip_led=0;
            flip_led_RAZ=1;
            printf("\n\rFlash en cour d'effacement\n\r");
            flash.eraseChip(flash_eraseChip);
            flip_led_RAZ=0;
            if (flash_eraseChip)
                printf("Memoire flash efface\n\r");
            else
                printf("Erreur effacement memoire flash");

            break;

    }
}

 //Fonctions qui permet de stocker le tag lu dans la flash \\
 
void save_tag_flash(void)
{

    char flash_read=0;
    bool flag_write_tag=1;
    int j=0;
    while(flag_write_tag) {
        flash_read=0;
        flash.read(j,&flash_read,1);
        if (flash_read==255) {
            flash.write(j,&tag_char[2],1);
            flash.write(j+1,&tag_char[3],1);
            flash.write(j+2,&tag_char[4],1);
            flag_write_tag=0;
            printf(" flash_read_adresse_ecriture=%d\n\r",j);
        }

        else {
            j=j+4;

        }

    }
}



 //Fonction qui parcours la flash et retourne 1 si le tag scanné est present dans la flash \\
 
bool read_flash_and_valid_tag(void)
{
    bool flash_valid=0;
    int t=0;
    int tag_read;
    char flash_read;
    while(flash_valid==0&&flash_read!=255) {
        flash.read(t,&flash_read,1);
        tag_read=flash_read*100000;
        flash.read(t+1,&flash_read,1);
        tag_read=tag_read+(256*flash_read);
        flash.read(t+2,&flash_read,1);
        tag_read=tag_read+flash_read;
        if(tag_read==tag) {
            flash_valid=1;
            printf("tag read in flash=%d\n\r",tag_read);
        } else {
            t=t+4;
        }

    }
    return flash_valid;
}

// Fonction d'initialisation du RFID et test de la flash \\

void RFID_init(void)
{
    bool flash_test;

    flash_test=flash.testConnection();
    RFID_reader.setComPeriod(40);
    RFID_reader.setClockFrequency(8000000);
    RFID_reader.setSamplingTime(40);
    RFID_reader.startReadingTag();
    if(flash_test) {
        printf("\n\rInitialisation RFID || flash fonctionnelle\n\r");
        read_all_tag_flash();
    } else
        printf("\n\rInitialisation RFID || flash non fonctionnelle\n\r");
}

// Fonction qui permet de recuperer un tag\\

int get_tag (void)
{

    int tag;
    if(RFID_reader.isTagAvailable()) {
        tag_char = RFID_reader.getTag();
        tag=(int)tag_char[2]*100000+tag_char[3]*256+tag_char[4];

        //PC.printf("%d",tag);
        //printf("\n\r");
        flag=1;
    }



    return tag;
}



// Fonction qui permet d'afficher avec un terminal tous les tags enregistré dans la flash DEBBUGGING


void read_all_tag_flash(void)
{
    int t=0;
    int tag_read;
    char flash_read;

    printf("\n\r / tags in flash \\ \n\r");

    while(flash_read!=255) {
        flash.read(t,&flash_read,1);
        tag_read=flash_read*100000;
        flash.read(t+1,&flash_read,1);
        tag_read=tag_read+(256*flash_read);
        flash.read(t+2,&flash_read,1);
        tag_read=tag_read+flash_read;
        t=t+4;
        if(flash_read!=255)
            printf("%d\n\r",tag_read);
    }
    printf("/ end tag in flash \\ \n\r ");
}





// Les 3 fonctions qui gere le clignotement de la led pour les differents etats et le comptage du temps de presence du badge devant le lecteure\\

void  flip ()
{

    if(RFID_reader.isTagAvailable()&&time_count&&tag_su_bool) {
        var_time++;
        printf(" time=%d ",var_time);

    } else {
        var_time=0;
    }

    tag=get_tag();
    if(tag!=tag_su) {  // test en permanance si tag SU est bien lu pour autorisé le deconmptage pour entree dans RAZ ou add user
        tag_su_bool=0;
    } else {
        tag_su_bool=1;
    }
    if(flip_led==1)
        led =! led;
}

void  flip2 ()
{
    if(flip_led_2==1)
        led =! led;
}

void  flip3 ()
{
    if(flip_led_RAZ==1)
        led =! led;
}