#include "S25FL216K.h"

S25FL216K::S25FL216K(PinName mosi, PinName miso, PinName sclk, PinName cs):_spi(mosi, miso, sclk), _cs(cs) {
    _spi.format(8,3);
    _cs=1;
}

bool S25FL216K::testConnection( void ) {
    _cs=0;
    _spi.write(S25FL216K_JEDEC);
    wait_us(10);
    
    char manID = _spi.write(0x00);
    char memType = _spi.write(0x00);
    char memCap = _spi.write(0x00);
    
    _cs=1;
    
    //We only check memType/Cap:
    
    if ((memType == 0x40) && (memCap == 0x16)) // 16 au lieu de 15
        return true;
    else
        return false;
}

void S25FL216K::read(int address, char *buffer, int length) {
    _cs=0;
    _spi.write(S25FL216K_READ);
    _spi.write(address>>16);
    _spi.write(address>>8);
    _spi.write(address);
    for (int i = 0; i<length; i++)
        buffer[i]=_spi.write(0x00);
     
    _cs=1;
}

void S25FL216K::write(int address, char *buffer, int length, bool block) {
    setWriteEnable();
    _cs=0;
    _spi.write(S25FL216K_WRITE);
    _spi.write(address>>16);
    _spi.write(address>>8);
    _spi.write(address);
    
    for (int i = 0; i<length; i++)
        _spi.write(buffer[i]);
     
    _cs=1;
    
    if (block)
        while(isBusy());
}

void S25FL216K::eraseSector(int address, bool block) {
    setWriteEnable();
    _cs=0;
    _spi.write(S25FL216K_SECTOR_ERASE);
    _spi.write(address>>16);
    _spi.write(address>>8);
    _spi.write(address);
     
    _cs=1;
    
    if (block)
        while(isBusy());
}

void S25FL216K::eraseBlock(int address, bool block) {
    setWriteEnable();
    _cs=0;
    _spi.write(S25FL216K_BLOCK_ERASE);
    _spi.write(address>>16);
    _spi.write(address>>8);
    _spi.write(address);
     
    _cs=1;
    
    if (block)
        while(isBusy());
}

void S25FL216K::eraseChip(bool block) {
    setWriteEnable();
    _cs=0;
    _spi.write(S25FL216K_CHIP_ERASE);
     
    _cs=1;
    
    if (block)
        while(isBusy());
}

void S25FL216K::setWriteEnable( void ) {
    _cs=0;
    _spi.write(S25FL216K_WREN);
    _cs=1;
    }

char S25FL216K::getStatus( void ) {
    _cs=0;
    _spi.write(S25FL216K_RDSR);
    
    char retval = _spi.write(0);
    _cs=1;
    return retval;
}

bool S25FL216K::isBusy( void ) {
    char retval = getStatus();
    retval = retval & 0x01;
    return retval;
}