
#include "mbed.h"
/*************** Variables globales **************************/
volatile int flag_timer_etat=0; //ce timer séquence l'alimaentation des phases du moteur, sa fréquence est réglable avec le potentiomètre + trame vitesse
volatile int flag_timer_reglage_vitesse=0; //ce timer lit le réglage de la vitesse tous les 0.1 s
volatile int flag_fc_haut=0; //interruption sur SW2
volatile int flag_contact=0; //interruption sur SW3
/*************** Interfaces utilisés *************************/
Serial pc(USBTX, USBRX,9600); // liaison USB
Ticker timer_etat;                     // Interruptions temporelles (timout)
Ticker timer_reglage_vitesse;         
DigitalOut IN1(PTD3);          // sorties logiques
DigitalOut IN2(PTC4);
DigitalOut IN3(PTD1);
DigitalOut IN4(PTC12);
DigitalOut ENA(PTA1);
DigitalOut ENB(PTD2);
AnalogIn ain0(A0);             //(lecture potentiometre vitesse) // entrées analogiques
AnalogIn ain1(A1);             // (lecture potentiometre lecture position)
InterruptIn fc_haut(SW2);       // SW2 est associé à une interruption kbi s'appelant fc_haut
InterruptIn contact(SW3);       // SW3 est associé à une interruption kbi s'appelant contact
/*************** Programmes d'interruption *******************/
void IT_timer_etat() {          // sequencement phases moteur dont la fréquence est réglable potentiomètre/trame
    flag_timer_etat=1;
    }
void IT_timer_reglage_vitesse() { // reglage de la vitesse tous les 100 ms
    flag_timer_reglage_vitesse=1;
    }
void IT_fc_haut(){                  // position haute atteinte (raz)
    flag_fc_haut=1;
    } 
void IT_contact(){                  // contact avec echantillon (OK)
    flag_contact=1;
    }  
/*************** Programme Principal *************************/
int main() {
    // declaration des variables
    signed char etat=0; // etat varie de 0 à 7 pour représenter les 8 posiions du mpp
    signed char sens=0; // -1 : recule / 0 : stop / 1 : avance
    float Vpot,Vpos,periode,position_mesuree,frequence; // Vpot potentiomètre reglage vitesse
                                                        // Vpos capteur de position monté sur vérin
                                                        // position_mesurée : position estimée avec Vpos
                                                        // periode : periode de l'IT etat (pilotage moteur)
                                                        // frequence : frequence de l'IT etat (pilotage moteur)
    char command[30];    // buffer de réception du message
    int Nb_pas =0;    // comptage du nombre de 1/2 pas
    int consigne_position =0;
   // dans le cas du firgelli :
    float a=127.47; // coefficient etalonnage capteur de position
    float b=-6.23; // coefficient etalonnage capteur de position
    // Initialisations
    IN1=0; // moteur non alimenté
    IN2=0;
    IN3=0;
    IN4=0;
    timer_etat.attach(&IT_timer_etat, 0.01); // mise à jour de la commande moteur toutes les 10ms (100Hz)
    timer_reglage_vitesse.attach(&IT_timer_reglage_vitesse, 0.1); // mise à jour de la vitesse moteur  par potentiomètre toutes les 0,1s
    fc_haut.fall(&IT_fc_haut);  // declaration des programmes kbi (SW2)
    contact.fall(&IT_contact);  // declaration des programmes kbi (SW3)
    // boucle programme principal
    while(1) {
        // on traite la liaison serie
        if (pc.readable()){                 // test liaison serie
            pc.scanf("%s",command);         // ecrit dans "command" la chaine reçue
            if(strcmp(command,"stop")==0) {
               sens=0;                      // si j'ai reçu "stop" désactivation du L298 et sens = 0
               ENA=0;
               ENB=0;
                }
            else if (strcmp(command,"avant")==0){
                sens=1;                     // si j'ai reçu "avant" activation du L298 et sens = 1
                ENA=1;
                ENB=1;
                }
            else if (strcmp(command,"arriere")==0){
                sens=-1;                    // si j'ai reçu "arriere" activation du L298 et sens = -1
                ENA=1;
                ENB=1;
                }
            else if (strcmp(command,"fc_haut")==0){
                sens=0;                     // si j'ai reçu "fc_haut" désactivation du L298 et position = 0
                ENA=0;                      // (réinitialisation du  nombre de pas)
                ENB=0;
                Nb_pas=0;
                }
            else if (strcmp(command,"contact")==0){
                sens=0;                     // si j'ai reçu "contact" désactivation du L298 et position = 0
                ENA=0;
                ENB=0;
                /***********************************************************************************************************/
                /******************** Traitement contact si firgelli *******************************************************/
                /***********************************************************************************************************/
                /*// en mode test sur système avec capteur de position 
                Vpos=ain1.read();               // lecture du capteur de position (firgelli)          
                position_mesuree=a*Vpos+b;      // calcule la position (firgelli)
                printf("Npas : %d , Vpos : %f , Position mesuree : %f \n", position,Vpos,position_mesuree);     
                // sur le vrai système
                //position_mesuree=position*0.0125;
                //printf("nb pas = %d\n", position_mesuree);        */
                 /***********************************************************************************************************/
                /******************** Traitement contact si moteur pas à pas ************************************************/
                /***********************************************************************************************************/
                // en mode test sur système avec capteur de position 
                position_mesuree=Nb_pas*0.0125;
                printf("Npas : %d , Vpos : %f , Position mesuree : %f \n", Nb_pas,Vpos,position_mesuree);                              
                }
            else if(strcmp(command,"vitesse")==0) { // trame vitesse : "vitesse<CR>XXXX<CR>" où XXXX représente la frequence de pilotage du moteur
                pc.scanf("%s",command); // lecture de XXXX la frequence de pilotage
                frequence=atoi(command); // change la chaine de caractères en entier
                periode=1/float(frequence);
                timer_etat.attach(&IT_timer_etat, periode); //on fixe la periode de pilotage du moteur
                }
            else if(strcmp(command,"position")==0) {
                pc.scanf("%s",command);
                consigne_position=atoi(command);
                
                }
            }     
        // on traite la commande du moteur   
        if (flag_timer_etat==1)
        {
            if (sens ==1) {
                etat++;
                Nb_pas++;
                if (etat>7) etat=0;
                }
            else if (sens==-1){
                etat--;
                Nb_pas--;
                if (etat<0) etat=7;
                }
            switch (etat) {
            case 0 : 
                IN1=1;
                IN2=0;
                IN3=0;
                IN4=0;
                break;
            case 1 : 
                IN1=1;
                IN2=0;
                IN3=1;
                IN4=0;
                break;
            case 2 : 
                IN1=0;
                IN2=0;
                IN3=1;
                IN4=0;
                break;
            case 3 : 
                IN1=0;
                IN2=1;
                IN3=1;
                IN4=0;
                break;  
            case 4 : 
                IN1=0;
                IN2=1;
                IN3=0;
                IN4=0;
                break;
            case 5 : 
                IN1=0;
                IN2=1;
                IN3=0;
                IN4=1;
                break;
            case 6 : 
                IN1=0;
                IN2=0;
                IN3=0;
                IN4=1;
                break;
            case 7 : 
                IN1=1;
                IN2=0;
                IN3=0;
                IN4=1;               
                break;   
            default :
                etat=0;
            }  
           // printf ("etat = %d\n",etat);                  
            flag_timer_etat=0;
            }
    if (flag_fc_haut==1){       // si j'ai un appui sur BP fc_haut : désactivation du L298 et position = 0
                Nb_pas=0;
                sens=0;
                ENA=0;
                ENB=0;
                flag_fc_haut=0;
                }
    if (flag_contact==1){       // si j'ai un appui sur BP contact : désactivation du L298 et envoi de la position
                sens=0;                     // si j'ai reçu "contact" désactivation du L298 et position = 0
                ENA=0;
                ENB=0;
                /***********************************************************************************************************/
                /******************** Traitement contact si firgelli *******************************************************/
                /***********************************************************************************************************/
                /*// en mode test sur système avec capteur de position 
                Vpos=ain1.read();               // lecture du capteur de position (firgelli)          
                position_mesuree=a*Vpos+b;      // calcule la position (firgelli)
                printf("Npas : %d , Vpos : %f , Position mesuree : %f \n", position,Vpos,position_mesuree);     
                // sur le vrai système
                //position_mesuree=position*0.0125;
                //printf("nb pas = %d\n", position_mesuree);        */
                 /***********************************************************************************************************/
                /******************** Traitement contact si moteur pas à pas ************************************************/
                /***********************************************************************************************************/
                // en mode test sur système avec capteur de position 
                position_mesuree=Nb_pas*0.0125;
                printf("Npas : %d , Vpos : %f , Position mesuree : %f \n", Nb_pas,Vpos,position_mesuree);                              
                }
    if (flag_timer_reglage_vitesse==1){
                Vpot=ain0.read(); // Vpot varie de 0 à 100% (0 à 1) en fonction du réglage vitesse
                frequence= 700*(Vpot+1); // frequence varie de 700 Hz à 1400Hz)
                periode=1/float(frequence);
                timer_etat.attach(&IT_timer_etat, periode); // maj vitesse moteur par potentiomètre
                flag_timer_reglage_vitesse=0;
                }
    }
}