#include "mbed.h"  //

//-------- programme de test carte   MES432 ----------------
// chaque seconde, numérise 4 valeurs sur ch1 ch2 
// et envoie betement une trame neutre en codage duj2
//
// configuration liaison série  à 19200 bps   ( driver stlink)
// A0 et A1 sont placées en entrée analogique ( mesure sortie AOP)
// A3 et A4 sont placées en sortie analogique ( offset vers AOP)
// sorties led sur carte nommée LL , IO sur D3 , pol sur D2
// broches D0 D1  sont précablées en I2C  ( sans plus)
// connecteur (vue de face)*** I2C   I2C   IO  Ov  Ov   3.3V   ch2   ch1 ***
//------------------------------------

//****************** déclaration des broches ****************
Serial pc(SERIAL_TX, SERIAL_RX);            //  PORT SERIE SUR usb  !! 
AnalogIn  Ch1(A0) ;AnalogIn  Ch2(A1);       //  entrées ana nommées Ch1 Ch2
AnalogOut out1(A3);AnalogOut out2(A4);      //  sorties ana nommées out1 out2
I2C i2c(D0,D1);                             // (sda,scl)  canal I2C nommé i2c
DigitalOut pol(D2);                         //  polarisation à 3.3V I2C ( si à 1)
DigitalOut IO(D3);                          //  sortie TTL nommée S0
DigitalOut LL(LED1);                        //  led nommée LL ( sur module L432
// nota IO peut etre déclarée en entrée en ecrivant  DigitalIn IO(D3);
//**********************************************************************
uint16_t chi[5];  // déclaratiion d'un tableau  d'entiers 16bits sans signe
float chf[5];     // déclaration d'un tableau de float 

void init(void)  // initialisation 
    {
    pc.baud(19200);     // vitesse liaison série
    pol = 1;            // polarisation résistancesde l' I2C  
    LL = 0 ;            // led du L432 on
    out1.write(0.5);    // sortie ana A3 = 0.5 * 3.3V  soit 1.6 V
    out2.write(0.25);   // sortie ana A4 = 0.25* 3.3V  soit 0.8 V
    IO = 0 ;            // sortie I/O  mise à 0  
    }
    
int main()
    {
    init(); 
    
    while(1)        // boucle sans fin 
        {
        LL = 1 ;       // re allume Led carte
        IO = 1;        // sortie IO mise à 1 ( led hors carte )
        wait(0.5);      // delai 0.5s
        LL= 0 ;
        IO = 0 ;
        wait(0.5);
        
        chi[1] =  Ch1.read_u16();  // lecture  ch1 mise en memoire 16bits
        chf[1] =  Ch2.read();      // lecture ch2 mise en float en mémoire

       //  transfert d'une trame de  4 entiers  au protocole duj2 ( exemple)
       pc.putc('i');     // pointeur 1 = 0
       pc.putc('e'); pc.putc('0'); pc.putc('1'); pc.putc('0'); pc.putc('0');//Pt++
       pc.putc('e'); pc.putc('0'); pc.putc('1'); pc.putc('0'); pc.putc('1');
       pc.putc('e'); pc.putc('0'); pc.putc('1'); pc.putc('0'); pc.putc('2');
       pc.putc('e'); pc.putc('0'); pc.putc('1'); pc.putc('0'); pc.putc('3');
       pc.putc('q');   // mise en mémoire 
       // on verra sur Tera Term 
       // ceci " ie0100e0101e0102e0103q  "
       // cette partie sera celle qui vous servira a valider votre processing
        
        //zone pour tester la carte et son cablage ( inutile pour processing)
        printf(" chi =0x%04x "  ,  chi[1] );
        printf("     chf =%.6f \n", 3.3*( chf[1]));
        // on lira sur Tera Term ( hors modifs sur le programme)
        // ceci "   chi =0x80b8      chf =0.710769   "

        }   
    }
