
// init générales appels de lybraries 
#include "mbed.h"
#include "IUT.h"     // programmes utiles carte IUT-BED  dans le fichier IUT.h

//  après c'est la lieu de  déclaration de vos  variables et  sous programmes
//  vos varriables et vos grogrammes commenceront par un V
//  afin de  se différiencier des variables globales déja créées
float  Vpot = 0;  // V pot valeur 

Serial serial(SERIAL_TX, SERIAL_RX); // laison serie en USB par usb driver STlink
// sous programme callback  à completer  en cas de reception serie .. interruption
void callback() 
    {serial.printf("%c\n", serial.getc()); } // ( retourne le caractère arrivé 

//  debut du "main" 
int main()
{
    winit();  // ligne obligatoire pour initialiser la carte IUT BED
    serial.baud(115200);  // initialise la vitesse de serie 
    serial.attach(&callback); // autorise l'arrivée de caractère usb serie
    
     // exemples de choses à faire
    TFT.background(Black);   // fond ecran
    TFT.foreground(White);   // couleur ecriture
    TFT.cls();               // efface tout

    //Print : message 
    TFT.set_font((unsigned char*) Arial28x28);
    TFT.locate(0,5);  // 0 pix en X ,   5 en vertical
    TFT.printf("IUT-BED2021");
    
    while (true) // boucle sans fin
    {    // 
        serial.printf("carte IUT-BED2021 connectee\r\n");
        TFT.locate(0,100);
        TFT.printf("bonjour");
        
        TFT.locate(0,75);
        TFT.printf("pot=        " );
        TFT.locate(0,75);
        Vpot = pot.read();  // read (en float)  la tension sur la broche pot
        Vpot = 3.2 * Vpot ; // sortie float de 0 a 3.2 ( 1024 pas)
        TFT.printf("pot= %.2f", Vpot );

        wait(0.5);
        
        led0 = k2;     // led = etat interrupteur k2
        led1 = !led1;  // inverse led

   }
    
}



