#include "mbed.h"
#include "TextLCD.h"
#include "ds1307.h"

Serial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(PA_10,PB_3,PB_5,PB_4,PB_10,PA_8); // rs, e, d4-d7
DS1307 my1307(D14,D15);
AnalogIn capteur(PA_5);
DigitalIn bouton(USER_BUTTON);
DigitalOut myled(LED1);
DigitalOut alarme(PB_8);
DigitalOut ledverte(PB_9);


FILE *fp;
char a='%';
void affichageinf (double valhum);
void affichagesup (double valhum, double tpsdepa);
void affichageini (void);
double valhum;
double valeurcritique = 5.0; // Valeur du taux d'humidité critique en pourcent d'humidité.
int delaimesure = 2; //le delais en seconde entre deux mesures.
int tpscritique = 10*60; // le temps critique de dépassement du taux d'humidité en seconde
int tpssave = 600; //le delais en seconde entre deux sauvegardes de données dans la carte SD.


void ecritureSD(double valhum)
{
    fp =fopen ("/sd/sauvegardes.txt","a");
    if (fp == NULL) { // Si on n'arrive pas a ouvrir le fichier dans la carte SD
        lcd.cls();
        lcd.printf("Erreur carte SD"); // On affiche sur l'ecran LCD qu'il y a une erreur
    } else {    
        int sec,min, hour, day, date, month, year;
        my1307.gettime( &sec, &min, &hour, &day, &date, &month, &year);
        fprintf(fp,"%d %d-%d-%d %d:%d %.2f\n\r", date, day, month, year, hour, min, valhum); // Date = lundi (1) , mardi (2) , mercredi (3),...
        fclose(fp);
    }
}

void affichageini (void)
{
    //On affiche sur le LCD le message lié au taux supérieur à 5%Hr
    lcd.cls(); //On récupère le nombre des dizaines
    lcd.printf("INITIALISATION"); //On récupère le nombre des unités
    lcd.locate(0,1);
    lcd.printf("DU SYSTEME .");
    wait(1);
    lcd.locate(0,0);
    lcd.printf("INITIALISATION");
    lcd.locate(0,1);
    lcd.printf("DU SYSTEME ..");
    wait(1);
    lcd.locate(0,0);
    lcd.printf("INITIALISATION");
    lcd.locate(0,1);
    lcd.printf("DU SYSTEME ...");
    wait(1);
}

void affichagesup (double valhum, int tpsdepa)
{
    //On affiche sur le LCD le message lié aux taux ingérieur à 5%Hr
    int min = tpsdepa/60;
    int rs = tpsdepa%60;
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("HUM = %.2f",valhum);
    lcd.locate(12,0);
    lcd.printf("%cHR",a);
    lcd.locate(0,1);
    lcd.printf("TPS+5%c %dmin %ds",a,min,rs);
}

void affichageinf (double valhum)
{
    //On affiche sur LCD le message d'initialisation
    lcd.cls(); //utile pour signlé qu'un reset manuel (boutton) a été effectué
    lcd.locate(0,0);
    lcd.printf("HUMIDITE MESUREE");
    lcd.locate(0,1);
    lcd.printf("EST DE");
    lcd.locate(8,1);
    lcd.printf("%.2f",valhum);
    lcd.locate(12,1);
    lcd.printf("%cHR",a);

}

int main()
{
    int tpsdepa = 0;
    int compteur=0;
    alarme =0;
    ledverte=0;

    int compteursave=0;
    while(1) {
        ledverte=1;  // On allume la led verte pour signaler que le système fonctionne
        affichageini(); // On affiche sur l'ecran LCD le message d'initialisation

        while(1) { // Boucle infinie
            double valcapteur = capteur.read()*3.3f; // Récupération de la tension d'entrée du capteur,
// qui est multipliée par la tension d'alimentation. Car la tension relevée est un pourcentage de
// la tension d'alimentation (vout est comprise entre 0 et 1).
            double valhum = (valcapteur-3.3*0.1515)/(0.00636*3.3); // Conversion de la tension en taux d'humidité
            if (valhum < valeurcritique) { // Si le taux d'humidité est inférieur à 5% Hr
                affichageinf (valhum); // On affiche sur le LCD le message lié au taux est inférieur à 5% Hr
                compteur = compteur +1; // Incrémentation du compteur
                if (compteur == 5) { // remise a zéro du compteur et éxtinction de l'alarme à partir de
                    tpsdepa=0; // 5 mesures consécutives en dessous de 5%
                    compteur =0;
                    alarme =0;
                }
            }
            if (valhum >= valeurcritique) {// Si la valeur est supérieur ou égale à 5% Hr
                compteur =0; // Reset du compteur
                affichagesup (valhum,tpsdepa); // On affiche sur le LCD le message lié au taux supérieur à 5% Hr
                tpsdepa = tpsdepa+delaimesure; // Incrémentation du temps de dépassement
                if (tpsdepa > 300) { // Si le temps de dépassement est supérieur au temps critique,
                    alarme=1; // on déclenche l'alarme
                }
                if (compteursave>=tpssave) {
                    compteursave=0;
                    ecritureSD(valhum);
                }
            }
            compteursave = compteursave + delaimesure;
            wait(delaimesure);
        }
    }
}



