/* Copyright (c) 2010-2011 mbed.org, MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mbed.h"
#include "SerialGPS.h"

/** On many platforms USBTX/USBRX overlap with serial on D1/D0 pins and enabling the below will interrupt the communication.
 *  You can use an LCD display to print the values or store them on an SD card etc.
 */
Serial pc(USBTX, USBRX); Porta série da ficha SDA da placa, usa o putty ou outro terminal tipo teraterm ou mobaxterm com a porta série que o pc configura para mbed

/**
 * D1 - TX pin (RX on the GPS module side)
 * D0 - RX pin (TX on the GPS module side)
 * 4800 - GPS baud rate
 */
SerialGPS gps(PTE22, PTE23, 9600);  // PTE23 - liga no Tx do conversor e PTE23 no Rx do conversor, atenção à porta série que o teu pc atribui ao conversor

DigitalOut myled(LED1);

main(void) {
    int erro;
    while (1) {
        pc.printf("Hello World!\n\r");
        
        myled = myled ? 0 : 1;
        if (gps.sample()) {
        pc.printf("sats %d, long %f, lat %f, alt %f, geoid %f, time %f\n\r", gps.sats, gps.longitude, gps.latitude, gps.alt, gps.geoid, gps.time);
        }
        wait(1);
        
    }
}