#include "mbed.h"

Serial bt(USBTX, USBRX);
// hoeksensor pinnen
AnalogIn linksvoor(A0);
AnalogIn linksachter(A1);
AnalogIn rechtsvoor(A2);
AnalogIn rechtsachter(A3);
// lidar pinnen
AnalogIn afstand(A4);
DigitalOut steppulse(D9);
DigitalOut enable(D7);
// knop pinnen
DigitalIn button(D8);
PwmOut led(D11);
// Hbrug pinnen
PwmOut motorlfwd(D2);
PwmOut motorlrwd(D3);
PwmOut motorrfwd(D6);
PwmOut motorrrwd(D10);
// timers en tickers
Timer debounce;
Timer line;
Ticker buttontime;
Ticker sensortime;
Ticker steppertime;
Ticker lidartime;
// programma variabelen
bool robotrun;
bool sensorFL;
bool sensorFR;
bool sensorRL;
bool sensorRR;
int programmastap;
int lidarangle;
float distance;
float lidarlinks;
float lidarrechts;
//andere variabelen
float ledset;
bool ledcase;
bool laststate;
// instelbare variabelen
int turntime = 1000;
int stepsperrev = 2080;

/*
******* buttoncheck ********************************
in deze functie word de knop van de robot aangestuurd.
alle debounce word uit de knop gefilterd en hij schakelt op de falling edge.
als de knop niet in run is zal de led van de klop aan en uit dimmen.
als de knop wel in run is gaat de led normaal branden.
deze functie zit gekoppeld aan ticker buttontime zodat deze automatisch
aangeroepen word en de knop uitleest.
ook zorgt de ticker voor het dimmen van de led.
*/
void buttoncheck()
{
    if (button == 0) {
        debounce.start();
    }
    if (debounce.read_ms() >= 50) {
        debounce.reset();
        if (button == 0) {
            laststate = 1;
        }
    }
    if(button == 1&&laststate == 1) {
        laststate = 0;
        robotrun = !robotrun;
        bt.printf("robotrun is nu : %d\n",robotrun);
    }
    if (robotrun == 0) {
        switch (ledcase) {
            case 0:
                ledset = ledset + 0.01;
                if(ledset >= 1) {
                    ledcase = 1;
                }
                break;
            case 1:
                ledset = ledset - 0.01;
                if(ledset <= 0) {
                    ledcase = 0;
                }
        }
        motorlfwd = 0;
        motorlrwd = 0;
        motorrfwd = 0;
        motorrrwd = 0;
    }

    else if (robotrun == 1) {
        ledset = 1;
    }
    led = ledset;
}

/*
******* Hbrug ********************************
deze functie bestuurd de Hbrug.
de Hbrug heeft 2 ingaande variabelen.
de eerste variabele is voor de linker motor
-1 is vollop achteruit 1 is vollop vooruit 0 is stilstaan.
de tweede variabele is voor de rechter motor
-1 is vollop achteruit 1 is vollop vooruit 0 is stilstaan.
variabelen mogen ook daartussenin zijn
*/
void Hbrug(float left, float right) // motor sturing
{
    if(left > 0) {
        motorlfwd = left;
        motorlrwd = 0;
    } else if(left < 0) {
        motorlfwd = 0;
        motorlrwd = left*-1;
    } else {
        motorlfwd = 0;
        motorlrwd = 0;
    }
    if(right > 0) {
        motorrfwd = right;
        motorrrwd = 0;
    } else if(right < 0) {
        motorrfwd = 0;
        motorrrwd = right*-1;
    } else {
        motorrfwd = 0;
        motorrrwd = 0;
    }
}
/*
******* lijnsensor ********************************
deze functie controleert de lijnsensoren.
als deze onder een bepaalde waarde vallen dan word een bit hoog gemaakt.
deze word met de ticker sensortime aangeroepen.
als een lijn word gevonden dan word er een deel van het programma aangeroepen
die ervoor zorgt dat de robot wegrijdt van de lijn.
*/
void lijnsensor()
{

    float a = linksvoor;
    float b = linksachter;
    float c = rechtsvoor;
    float d = rechtsachter;
    if(a< 0.5) {
        sensorFL = 1;
        programmastap = 1;
        line.reset();
        line.start();
    } else {
        sensorFL = 0;
    }
    if(b< 0.5) {
        sensorFR = 1;
        programmastap = 2;
        line.reset();
        line.start();
    } else {
        sensorFR = 0;
    }
    if(c< 0.5) {
        sensorRL = 1;
        programmastap = 3;
        line.reset();
        line.start();
    } else {
        sensorRL = 0;
    }
    if(d< 0.5) {
        sensorRR = 1;
        programmastap = 4;
        line.reset();
        line.start();
    } else {
        sensorRR = 0;
    }
}
void lidar()
{
    int quadrant = stepsperrev/4;
    distance = afstand;
    if (distance > 0.2) {

        if(pos < stepsperrev&&pos> quadrant*3) {
            lidarlinks = (pos - quadrant*3)/quadrant;
            lidarrechts = 1;
        } else if(pos < quadrant*3 &&pos > quadrant*2) {
            lidarlinks = -1;
            lidarrechts = 1;
        }
        else if(pos < quadrant*2 && pos > quadrant){
            lidarlinks = 1;
            lidarrechts = -1;
            }
            else if(pos < quadrant&& pos > 0){
                lidarlinks = 1;
            lidarrechts = pos/quadrant;
                }
    } else {
        lidarlinks = 1;
        lidarrechts = 1;
    }
}
void setstep()
{
    steppulse = !steppulse;
    if(robotrun == 1) {
        enable = 0;
        lidarangle = lidarangle+1;
        if (lidarangle > stepsperrev) {
            lidarangle = 0;
        }
    } else {
        enable = 1;
    }
}
/*
******* main ********************************
hierin staan de programmadelen van de robot.
de andere functies kunnen stukken van dit programma starten om de robot voor een
 bepaalde tijd een opdracht te laten doen.
*/
int main()
{

    button.mode(PullUp);
    buttontime.attach(&buttoncheck, 0.005);
    sensortime.attach(&lijnsensor, 0.01);
    steppertime.attach(&setstep, 0.0008);

    bt.printf("robotrun is nu : %d\n",robotrun);
    while(1) {
        if(robotrun == 1) {
            bt.printf("programmastap = %d\n",programmastap);
            switch(programmastap) {

                case 0:
                    Hbrug(0.7,0.7);
                    break;
                case 1:
                    Hbrug(-1,-0.5);
                    if (line.read_ms() >= turntime) {
                        line.reset();
                        programmastap = 0;
                    }
                    break;
                case 2:
                    Hbrug(-0.5,-1);
                    if (line.read_ms() >= turntime) {
                        line.reset();
                        programmastap = 0;
                    }
                    break;
                case 3:
                    Hbrug(1,0.5);
                    if (line.read_ms() >= turntime) {
                        line.reset();
                        programmastap = 0;
                    }
                    break;
                case 4:
                    Hbrug(0.5,1);
                    if (line.read_ms() >= turntime) {
                        line.reset();
                        programmastap = 0;
                    }
                    break;
            }
        } else {

        }



    }
}

