#include "mbed.h"

Ticker stepperspeed;


DigitalOut steppulse(D3);
DigitalOut enable(D4);
DigitalOut dir(D2);

DigitalIn button(D8);
DigitalOut led(D1);

PwmOut motorlpwm(D6);
PwmOut motorrpwm(D12);
DigitalOut motorlfwd(D7);
DigitalOut motorlrwd(D9);
DigitalOut motorrfwd(D10);
DigitalOut motorrrwd(D11);

bool run = 0;
bool lastbuttonstate = 0;
int ledset = 0;


void setstep()
{
    steppulse = !steppulse;
}


int main()
{
    button.mode(PullUp);
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    stepperspeed.attach(&setstep, 0.0008);
    
    motorlpwm.pulsewidth_us(50);
    motorrpwm.pulsewidth_us(50);
    enable = 1;
    dir = 0;
    motorlpwm = 0.8;
    motorrpwm = 0.8;

    while (1) {

        led = 1;
        wait_ms(500);
        led = 0;
        wait_ms(500);
        led = 1;
        wait_ms(500);
        led = 0;
        wait_ms(500);
        motorlfwd = 1;
        wait_ms(1000);
        motorlfwd = 0;
        motorlrwd = 1;
        wait_ms(1000);
        motorlrwd = 0;
        motorrfwd = 1;
        wait_ms(1000);
        motorrfwd = 0;
        motorrrwd = 1;
        wait_ms(1000);
        motorrrwd = 0;
        enable = 0;
        dir = 0;
        wait_ms(2000);

        dir = 1;
        wait_ms(2000);
        enable = 1;
    }
}