#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial bt(USBTX, USBRX);


AnalogIn linksvoor(A0);
AnalogIn rechtsvoor(A1);
AnalogIn linksachter(A2);
AnalogIn rechtsachter(A3);
AnalogIn afstand(A4);

Ticker stepperspeed;

DigitalOut steppulse(D9);

DigitalOut enable(D7);

DigitalIn button(D8);
DigitalOut led(D11);


DigitalOut motorlfwd(D2);
DigitalOut motorlrwd(D3);
DigitalOut motorrfwd(D6);
DigitalOut motorrrwd(D10);

float a;
float b;
float c;
float d;
float e;
float f;
float g;

void setstep()
{
    steppulse = !steppulse;
}

int main()
{
button.mode(PullUp);
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    stepperspeed.attach(&setstep, 0.0008);
    
led = 1;
    bt.printf("lekker draadloos pik !\n");
    while(1) {
        wait(0.05);
        a = afstand;
        b = linksvoor;
        c = rechtsvoor;
        d = linksachter;
        e = rechtsachter;

        bt.printf("dis =  %f, FL =  %f, FR =  %f, RL =  %f, RR =  %f.\n", a, b, c, d, e);
       
        if (bt.readable() > 0) {
            char c = bt.getc();
            switch(c){
                case 's':
                bt.printf("stopped\n");
                
                motorlfwd = 0;
                motorrfwd = 0;
                motorlrwd = 0;
                motorrrwd = 0;
                enable = 1;
                led = 0;
                break;
                case 'q':
                bt.printf("LFWD\n");
                motorlfwd = 1;
                break;
                case 'w':
                bt.printf("RFWD\n");
                motorrfwd = 1;
                break;
                case 'e':
                bt.printf("LRWD\n");
                motorlrwd = 1;
                break;
                case 'r':
                bt.printf("RRWD\n");
                motorrrwd = 1;
                break;
                case 'a':
                bt.printf("Stepper\n");
                enable = 0;
                break;
                case 'd':
                bt.printf("led\n");
                led = 1;
                break;
                }
            
            

        }
    }

}
