#include "mbed.h"
#include "QEI.h"
#include "Filter.h"
#include "string"
#include "define.h"
#include "RoboClaw.h"

Ticker timer;
Timer T;

RoboClaw MD(115200,p9,p10);
Serial Saber(p13,p14);
Serial pc(USBTX,USBRX);
RawSerial Master(p28,p27,115200);//(tx,rx,baud);
Filter velfilter(INT_TIME);

DigitalOut fet1(p22);//shagai把持
DigitalOut fet2(p21);//shagai押出
DigitalOut fet3(p23);//shagaiハンド昇降

DigitalIn limit1(p15);//shagaiハンドlimit
DigitalIn limit2(p16);
//SENSのどっちか減るかも
DigitalIn SENS1(p18);//shagai検出
DigitalIn SENS2(p17);

DigitalIn G_limit1(p9);//gerege limit
DigitalIn G_limit2(p10);

int cmd,A;
int LIM1,LIM2;
int S1,S2;

char mode = 0x00;

double filtered_ref_qpps;

int G_LIM1=0,G_LIM2=0;

int G_cmd;

int limit_MD(int qpps,int max_qpps){
    if (qpps > max_qpps) qpps = max_qpps;
    else if (-qpps < -max_qpps) qpps = -max_qpps;
    return qpps;
}

void robo_serial(int adrs, int qpps1, int qpps2){
    MD.SpeedM1(adrs,qpps1);
    MD.SpeedM2(adrs,qpps2);
}

void Saber_Serial (int adrs, int rot, int cmd){
    Saber.putc(adrs);
    Saber.putc(rot); 
    Saber.putc(abs(cmd));
    Saber.putc((adrs + rot + abs(cmd)) & 0b01111111);
}

/*void Slave_tx(char tx_mode){                                //処理の終了を送る
    Master.printf("%c",tx_mode);
    Master.printf("%c",tx_mode);
    Master.printf("\n");
}*/

void Slave_rx() {                                           //処理内容を受け取る
    static string rx_mode = "";
    char rx_c = Master.getc();
    
    if (rx_c == '\n') {
        if (rx_mode.size() == 2){
        if (rx_mode[0] == rx_mode[1]){
        mode = rx_mode[1];       //モード切替
        }}
        rx_mode = "";
        }
    
    else {
        if (rx_mode.size() > 2) rx_mode = "";
        rx_mode += rx_c;
        }
        //pc.printf("%x\n",mode);
}

void timer_warikomi()
{
    static int qpps1 = 0;
    static int qpps2 = 0;
    static int ref_qpps1 = 0;
    static int ref_qpps2 = 0;

    LIM1=!limit1.read();
    LIM2=!limit2.read();
    S1=SENS1.read();
    S2=SENS2.read();
    static char slave_mode = 0x00;
    static int spd_count = 0;
    
    G_LIM1=!G_limit1.read();//pullupなので逆
    G_LIM2=!G_limit2.read();//pullupなので逆
    
    switch (mode) {
        case 0x99:
                break;
                
        case 0x10://初期化処理
                ref_qpps1 = 0.0;
                ref_qpps2 = 0.0;
                
                break;
                
        case 0x20://ハンド降下
                //goal_D=125;
                if(S1==0&&S2==0){
                fet1=1;
                A=1;
                }
                break;
                 
        case 0x30://ハンド上昇
                
                break;
                
        case 0x40://geregeハンド
                G_cmd=120;
                if(G_LIM1){
                    G_cmd=0;
                }
                break;
                
        case 0x50://geregeハンド
                G_cmd=-120;
                if(G_LIM2){
                    G_cmd=0;
                slave_mode = 0x55;
                }
                break;
               
        case 0x60://shagai発射
                ref_qpps1 = REF_QPPS1;
                ref_qpps2 = REF_QPPS2;
                if (qpps1 == REF_QPPS1 && qpps2 == REF_QPPS2) {
                    spd_count++;
                }
                break;
        
        case 0x90://全停止
                ref_qpps1 = 0.0;
                ref_qpps2 = 0.0;
                G_cmd = 0;
                break;
                
        default://何もしない
                break;
        }
        
    //Slave_tx(slave_mode);
    //二次遅れ系 
    if(qpps1>=QPPS_HIGH_RANGE1 && ref_qpps1 == REF_QPPS1) qpps1=ref_qpps1;
    else if(qpps1<=QPPS_HIGH_STOP && ref_qpps1 == 0) qpps1=0;
    else qpps1 = velfilter.SecondOrderLag((double)ref_qpps1);
    if(qpps2>=QPPS_HIGH_RANGE2 && ref_qpps2 == REF_QPPS2) qpps2=ref_qpps2;
    else if(qpps2<=QPPS_HIGH_STOP && ref_qpps2 == 0) qpps2=0;
    else qpps2 = velfilter.SecondOrderLag((double)ref_qpps2);
    //ローラー強制停止
    /*if (qpps <= 5.0 && ref_qpps == 0) {
        cmd3 = 0;
    }*/
    //自動押し出し
    if (spd_count >= 40){
        fet2 = 0;
        if (slave_mode != 0x60) spd_count = 0;
    }
    
    qpps1 = limit_MD( qpps1, MAX_QPPS1);
    qpps2 = limit_MD( qpps2, MAX_QPPS2);
    
    robo_serial(ROBO_ADRS, qpps1, qpps2);
    
    if (G_cmd > 0) Saber_Serial (SABER_ADDR, 4, G_cmd);
    else Saber_Serial (SABER_ADDR, 5, G_cmd);
    
    }


int main() {
    Saber.baud(19200);
    pc.baud(9600);
    fet1=0;
    fet2=1;
    fet3=0;
    
    G_limit1.mode( PullUp );    //  内蔵プルアップを使う
    G_limit2.mode( PullUp ); 
    
    velfilter.setSecondOrderPara(1.0, 0.9, 0.0);
    
    Master.attach(&Slave_rx, RawSerial::RxIrq);
    timer.attach(timer_warikomi,INT_TIME);
    
    while(1) {
        pc.printf("%lf\n", filtered_ref_qpps);
    }
}
