#include "mbed.h"
#include "string"

#include "Input.h"


Ticker Tick;
CAN Comm(p30, p29);
RawSerial Controler(p9, p10, 115200);
RawSerial pc(USBTX, USBRX, 115200);

ButtonIn fieldSw(p17);
ButtonIn startSw(p20);
ButtonIn stCzSw(p19);
ButtonIn retrySw(p18);

DigitalInOut pushLed[3] = { DigitalInOut(p27, PIN_OUTPUT, OpenDrain, 1),
                            DigitalInOut(p26, PIN_OUTPUT, OpenDrain, 1),
                            DigitalInOut(p25, PIN_OUTPUT, OpenDrain, 1) };

//(DigitalInOut(p24), (DigitalInOut(p23), (DigitalInOut(p22), (DigitalInOut(p21)};

bool mode = 0;  //0 = manual, 1 = auto
bool objB = 0;

bool swUp, swDown, swLeft, swRight, swCross, swCircle;
char x = 127, y = 127, rot = 127;

char stateUnder = 0, stateUpper = 0;         //指令
char progressUnder = 0, progressUpper = 0;   //進行度

char field = 'R';


//時間割り込み
void interTime()
{
    static int count = 0;
    count++;
    
    if(fieldSw.read()) {       //フィールド読み取り
        field = 'B';
    }
    else {
        field = 'R';
    }

    if(swCross) {                   //停止指示があったら
        char data[4] = {'u', field, 0, 0};
        while(!Comm.write(CANMessage(101, data, 4))) {}
        return;
    }
    
    if(!stCzSw.read() && startSw.state() == ButtonIn::Rise){    //自動ゾーンスタート指示が来たら
        
        mode = true;
                         //通常だったら
        stateUnder = 2;
        if(stateUpper < 10 && !objB){
            stateUpper = 10;
            progressUpper = 0;
        }
        if(stateUpper < 12 && objB){
            stateUpper = 12;
        }
            
        
    }
    
    if(stateUpper == 10 && progressUpper == 100){
        stateUnder = 6;
    }
    if(stateUnder == 4 && progressUnder == 100 && stateUpper == 10){
        stateUpper++;   //10 -> 11 , 12 -> 13
    }
    if(stateUnder == 3 && progressUnder == 100){
        if(objB){
            stateUnder = 5;
        }
        else {
            stateUnder = 4; 
        }
        progressUnder = 0;
    }
    if(stateUnder == 2 && progressUnder == 100){
        stateUnder = 3;
        progressUnder = 0;
    }
    
    
    if(count % 2) { //上半身への送信

        switch(stateUpper) {
            case 0:
                static bool preSwCircle = 1;
                if(swCircle && !preSwCircle) {
                    stateUpper = 1;
                }
                preSwCircle = swCircle;

                break;
            case 1:
                if(progressUpper == 100 && swCircle && !preSwCircle){ stateUpper = 2; }
                preSwCircle = swCircle;
                
                break;
                /*
            case 3:
            case 6:
            case 9:
                static bool preSwRight = 0;
                static bool preSwLeft = 0;
                
                if(swRight && !preSwRight && progressUpper == 100) { stateUpper++; }
                if(swLeft && !preSwLeft && progressUpper == 100) { stateUpper--; }
                
                preSwRight = swRight;
                preSwLeft = swLeft;
                
                for(int i=0; i<stateUpper/3; i++ ) { pushLed[i].write(0);}
                for(int i=2; i>=stateUpper/3; i-- ) { pushLed[i].write(1);}
                
                break;*/
                
            case 3:
                if(swCircle && !preSwCircle && progressUpper == 100) {
                    if(objB){
                        stateUpper = 10;
                        progressUpper = 0;
                    }
                    else{ stateUpper++; }
                }
                
                preSwCircle = swCircle;
            
            
            case 10:
                break;
            case 11:
                if(progressUpper == 100){
                    
                }
                
                break;
            case 12:
                break;
            case 13:
                break;
            case 16:
                break;
            case 9:
                static bool preSwRight = true;
                
                if(swRight && !preSwRight){
                    stateUpper = 14;
                }
                
                preSwRight = swRight;
            default:    //2,4,5,6,7,8,9,14,15
            
                //static bool preSwCircle = 0;
                
                if(swCircle && !preSwCircle && progressUpper == 100) {
                    stateUpper++;
                }
                
                preSwCircle = swCircle;
                break;
        }
        char data[4] = {'b', field, stateUpper, 0};
        while(!Comm.write(CANMessage(102, data, 4))) {};
    }
    else {        //下半身への送信
        if(!mode && stateUnder == 1){
            char data[6] = {'u', field, stateUnder, x, y, rot};
            while(!Comm.write(CANMessage(101, data, 6))) {};
        }
        else {
            char data[4] = {'u', field, stateUnder, 0};
            while(!Comm.write(CANMessage(101, data, 4))) {};
        }
    }
    
    pc.printf("UpS%d,\tUnS%d,\tUpP%d,\tUnP%d\n", stateUpper, stateUnder, progressUpper ,progressUnder);
    
}

//コントローラ受信機からの通信
void interRecv()
{
    static string rStr = "";
    char c = Controler.getc();

    if(c == '\n') {
        if(rStr.size() == 4) {

            x = rStr[0];
            y = rStr[1];
            rot = rStr[2];

            swUp     = (rStr[3] & 0b000001);
            swDown   = (rStr[3] & 0b000010);
            swCross  = (rStr[3] & 0b000100);
            swCircle = (rStr[3] & 0b001000);
            swLeft   = (rStr[3] & 0b010000);
            swRight  = (rStr[3] & 0b100000);

            //pc.printf("%d\n",swCross);
        }
        rStr = "";

    } else {
        rStr += c;
    }


}

//スレーブからの受信
void interComm()
{
    CANMessage rmsg;
    
    //pc.printf("i: \n");
    
    
    if(Comm.read(rmsg)){/*
        if(rmsg.data[0] == 'a' && rmsg.data[1] == 0 && rmsg.data[2] == 0 && rmsg.data[3] == 0) { //非常停止だったら
            char data[4] = {'u', field, 0, 0};
            
            while(!Comm.write(CANMessage(0002, data,4))) {}
        
            data[0] = 'b';
        
            while(!Comm.write(CANMessage(0002, data,4))) {}
        }
        else*/ if(rmsg.data[0] != 'M') {      //自分宛て以外だったら
            return;
        }
    }
    else {return;}

    
    switch( rmsg.data[1] ) {
        case 'u':
            if(rmsg.data[2] == stateUnder) { progressUnder = rmsg.data[3]; }
            break;
        case 'b':
            if(rmsg.data[2] == stateUpper) { progressUpper = rmsg.data[3]; }
            break;
    }

    //pc.printf("%c\n",rmsg.data[1]);

}

int main()
{

    if(fieldSw.read()) {
        field = 'B';
    } else {
        field = 'R';
    }
    
    while(startSw.state() != ButtonIn::Rise){}
    
    if(!retrySw.read()){ objB = true; }
    
    stateUnder = 1;

    Tick.attach(&interTime, 0.01);
    Comm.attach(&interComm, CAN::RxIrq);
    Controler.attach(&interRecv, RawSerial::RxIrq);

    while(1) {
    }
}
