#include "mbed.h"
#include <time.h>

AnalogIn sloyfe[4] = {p17, p18, p19, p20};                          // Sløyfene
DigitalOut led[4] = {LED1, LED2, LED3, LED4};                       // Led for feil
DigitalOut b[8] = {p21, p22, p23, p24, p25, p26, p27, p28};         // Bargraph
DigitalIn sb(p16);                                                  // Service bryter.
Serial pc(USBTX, USBRX);                                            //PC komunikasjon
Ticker alarm, system_paa, servic;                                   // Tikkere
int blink[4]= {0, 0, 0, 0};                                         // Global variabel med 4 elementer. Hvert element styrer sin egen led!
int amount_faild = 0;                                        // En variabel for å telle antall ganger feil inntastet passord.
void alarm_actived();                                        // Sjekker hva verdien på de analoge inngangene er og og utfører en case.
void service();                                              // Funksjon for resetting av anlegge. Anlegget blir satt i vedlikeholdsmodus med null feil.
void alblink();                                             // Blinke funksjonen.
char passord[5] = {'5','5', '5', '5', '5'};                             // Passordet.
int check_password1();                                       // Funksjon for å sjekke om inntastet passord er riktig.
void bruker(int);                                               // Valg menyen der bruker velger et ønske.
void Dato_timer();                                          //Klokke funskjonen.
LocalFileSystem local("local");                             // Fillogging

int main()
{
   set_time(1519919737); //setter tiden til sekunder verdi siden 1970
    while(1)
    {
        pc.printf("Velkommen\n");                  
        Dato_timer();                               // Viser klokke
        int x = check_password1();                      // sjekker pass er riktig og sender 1 til x om det er det.
        bruker(x);                                      
    }
}

void Dato_timer()
{
    time_t seconds = time(NULL);                            // Returnerer tiden lagret i time_t i sekunder.
    pc.printf("Mbed klokka er naa: %s", ctime(&seconds));       // Viser hva tiden er, ctime omgjør det til 
    pc.printf("\n\n\n");
    pc.printf("Hvis det ikke stemmer tast 0 ellers tast noe annet\n", ctime(&seconds));//Kun info.
    if (pc.getc() == '0')                                           // Sjekk om inntastet tegn er 0.
    {
        struct tm t;                                                            
        pc.printf("Tast inn dato og klokkeslett:\n");
        pc.printf("YYYY MM DD HH MM SS[enter]\n");
        scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday, &t.tm_hour, &t.tm_min, &t.tm_sec);// bruker ikke denne funksjonen...
        
        t.tm_year = t.tm_year - 2020;               
        t.tm_mon = t.tm_mon - 0;                        
        set_time(mktime(&t));                       
        
    }
    
}

void bruker(int riktigpassord)                          // meny funksjonen.
{   
    servic.attach(&service, 5);                          
    while(riktigpassord==1)
    {
        time_t seconds = time(NULL); 
        pc.printf("For start tast 1:\n\t");// Valg meny.
        pc.printf("For stopp tast 2:\n\t");
        pc.printf("For reset tast 3:\n\t");
        pc.printf("For status tast 4:\n\t");
        pc.printf("For utlogging tast 5:\n\t");
        pc.printf("For logg utskrift tast 6:\n\t");
    
        servic.attach(&service, 5);
        switch(pc.getc())// tall fra bruker blir til case
        {
            case '1':
            {
                FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");// File blir sendt til fp
                fprintf(fp, "\r\n Systemet paa: %s", ctime(&seconds));
                fclose(fp);
                pc.printf("System paa. \n\n");//Info til bruker.
                system_paa.attach(&alarm_actived, 2);// Tikker funksjon for alarm
                break;
            }
            case '2':
            {
                FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");
                fprintf(fp, " Systemet stoppet: %s\r\n", ctime(&seconds));
                fclose(fp);
                pc.printf("System stoppet. \n\n");
                system_paa.detach();
                for(int m=0; m < 4; m++){ blink[m]=0; led[m]=0;}
                break;
            }
            case '3':
            {
                FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");
                fprintf(fp, "\r\n Systemet resatt: %s", ctime(&seconds));
                fclose(fp);
                pc.printf("\n\n System resatt. \n\n");
                int m=0;
                while(m < 4) 
                { // variablen < 4 holder seg i løkka
                    blink[m]=0; // hvis service bryter er 1 reset alarm.
                    b[m+m]=b[m+m+1]=0;
                    led[m]=0;
                    m++;
                }
                break;
            }
            case '4':
            {
                pc.printf("\n For status paa hele anlegget tast 1: \n");
                pc.printf("\n For status paa enkelt sloyfer tast 2: \n\n\t\t");
                switch(getchar())//Ny switch cas for 4 hvis valgt
                {
                    case '1':
                    {
                        for(int m=0; m<4; m++)
                        {
                            float a=sloyfe[m];
                            if(a >= 0.30 && a <= 0.55){ pc.printf("\n Sloyfe %d alt ok. \n R1 i sloyfe %d operativ. \n R2 i sloyfe %d operativ \n\n", m+1, m+1, m+1); }
                            else if(a >= 0.58 && a <= 0.62) { pc.printf("\n Brudd i sloyfe %d. \n Brudd i R1 sloyfe %d. \n", m+1, m+1); }
                            else if(a >= 0.64 && a <= 0.80) { pc.printf("\n Brudd i sloyfe %d. \n \n Brudd i R2 sloyfe %d. \n\n", m+1, m+1); }
                            else if(a < 0.25) { pc.printf("\n Brudd i hele sloyfe %d. \n", m+1); }
                            else if(a >=0.88) { pc.printf("\n Brudd i R1 og R2 i sloyfe %d. \n", m+1); }// alt over sender beksjed hvis sant
                        }
                        break;
                    }
                    case '2':
                    {
                        pc.printf("\n For sloyfe 1 tast 1: \n For sloyfe 2 tast 2: \n For sloyfe 3 tast 3: \n For sloyfe 4 tast 4: \n\n\t\t");
                        int x = getchar();
                        if(x<49 || x>52){pc.printf("\n Ugyldig valg! \n"); break;};
                        float a=sloyfe[x-49];//x-49 er pga getchar gir en ASCII verdi som er forskjellig fra ønskelig verdi
                        if(a >= 0.30 && a <= 0.55){ pc.printf("\n R1 operativ. \n R2 operativ \n\n"); }
                        else if(a >= 0.58 && a <= 0.62) { pc.printf("\n Brudd i R1 sloyfe %d. \n", x-48); }
                        else if(a >= 0.64 && a <= 0.80) { pc.printf("\n Brudd i R2 sloyfe %d. \n\n", x-48); }
                        else if(a < 0.25) { pc.printf("\n Brudd i hele sloyfe %d. \n", x-48); }
                        else if(a >=0.88) { pc.printf("\n Brudd i R1 og R2 i sloyfe %d. \n", x-48); }
                        break;
                    }
                    default: 
                    {
                        printf("\n Ugyldig valg.\n");
                        break;
                    }
                } break;
            }
            case '5':
            {
                FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");
                fprintf(fp, "\r\n Logget av systemet: %s", ctime(&seconds));
                fclose(fp);
                pc.printf("\n\n\n\n\n\n\n\n\t\t\t\t Farvel.\n\n\n\n\n\n\n\n\n");
                riktigpassord=0;// variabel til 0 for inlogging
                break;
            }
            case '6':
            {
                FILE *fp = fopen("/local/SYSTEMLOG.txt", "r");
                int c;
                if (fp) 
                {
                    while ((c = getc(fp)) != EOF)
                    {
                        pc.putc(c);
                    }
                }
                fclose(fp);
                break;
            }
            default:
            {
                printf("\n Ugyldig valg.\n");
                break;//valgfri break men har den her selvom default overskriver
            }
        }
    }
}   
int check_password1()
{
    time_t seconds = time(NULL); // Henter tid
    pc.printf("\n Skriv inn passord for adgang til alarmsystemet: ");
    int riktigpass=0; int n=0; char sjekk[4];
    while(1) 
    {
        if(pc.readable() && n < 4) 
            {
                sjekk[n++] = pc.getc();// Lagre inntastet tegn i sjekk arrayet i element n og inkrementer n med 1.
                if(n == 4) { break; } 
            }
    }
    for(n=0; n<4; n++) { if(sjekk[n]==passord[n]) { riktigpass++; } }
    
    if(riktigpass == 4) 
    {
        FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");
        fprintf(fp, "\r\n Riktig passord inntastet: %s", ctime(&seconds));//beskjed som blir loggført med klokketid.
        fclose(fp);
        pc.printf("\n Riktig passord.\n\n");
        amount_faild=0;
        return 1;
    }
    else 
    { // Dersom passordet er feil kjør dette
        amount_faild++;
        FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");
        fprintf(fp, "\r\n Feil passord inntastet, %d ganger: %s", amount_faild, ctime(&seconds));//beskjed til logg
        fclose(fp);
        pc.printf("\n\nFeil Passord, prov igjen!\n\n"); }
    return 0;
}

void alblink()//Blinke funksjon for sløyfene.
{
    int n;
    for(n=0; n < 4; n++) 
    { 
        if(blink[n]==1) { led[n] = !led[n]; } 
    }
}

void service()// service bryter funksjon.
{
    time_t seconds = time(NULL); 
    if(sb==1) 
    { // Hvis service bryter på
        FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");                          
        fprintf(fp, "\r\n Service bryter aktivert: %s", ctime(&seconds));           //beksjed til logg
        fclose(fp);                         
        pc.printf("\n\n Vedlikehold paa anlegget. \n\n\n\n");//beskjed om at det er vedlikehold
        int m=0;            //Lokal variabel.
        while(sb==1) 
        {                                                           // hvis servicebryter er inne så er denne i løkke
            while(m < 2) 
            {                                                                   
                blink[m] = 0;                                                  
                b[m+m]=b[m+m+1] = 0;                
                led[m] = 0;                         // Sett alle led[] til 0.
                m++;                                                               
            }
        }
        system_paa.detach();                            // Frakobler system_paa fra ticker.
        pc.printf("\n\n Tast 1 for igangsetting \n\n");
    }
}

void alarm_actived()// .
{
    time_t seconds = time(NULL); 
    alarm.attach(&alblink, 0.1); // alblink kjøres 10 ganger i sekundet. 
    int analog_verdi=0;
    for(int i = 0; i < 4; i++) // Løkke for alle sløyfene for og sjekke analog verdi
    {
        float a=sloyfe[i];
        if(a >= 0.30 && a <= 0.55) { analog_verdi = 1; }// alt ok, sett analog_verdi til 1.
        else if(a >= 0.58 && a <= 0.62) { analog_verdi = 2; } // R1 brudd  gi analog_verdi 2.
        else if(a >= 0.64 && a <= 0.80) { analog_verdi = 3; } 
        else if(a < 0.25 || a >=0.88) { analog_verdi = 4; } 
 
        switch(analog_verdi) 
        {
            case 1: 
            { 
                
                if(blink[i]==0 && led[i]==0) // globale arrayet blink[i] og led[i] er av så...
                {
                    if(i==0) { led[i]=1; }     //  i=0 sett led[i] på. 
                    else if(i==1) { led[i]=1; }//  i=1 sett led[i] på.
                    else if(i==2) { led[i]=1; }//  i=2 sett led[i] på.
                    else if(i==3) { led[i]=1; }//  i=3 sett led[i] på.
                }
                break;
            }
            case 2: 
            {
                
                blink[i]=1;
                if(b[i+i]==0) 
                {
                    FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");
                    fprintf(fp, "\r\n Brudd i R1 i Sloyfe %d:  %s", i+1, ctime(&seconds));
                    fclose(fp);
                    b[i+i]=1;// Led på bargraf med element nr i+i blir satt til en for å indikere feil på R1 i denne sløyfen. Partall, altså b0, b2, b4 og b6.
                }
                break;//  Ferdig med hva som er blitt bedt av den og avlutter case 2 går tilbake til for løkken.
            }
            case 3: 
            {
                 // Dersom denne verdien er 3 gå inn her og utfør dette også gå ut av case 3 tilbake til for løkken.
                blink[i]=1;// Blink[i] får verdien 1 og led[i] begynner å blinke.
                if(b[i+i+1]==0) 
                {
                    FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");// File blir peket til fp og fp blir åpnet for skriving.
                    fprintf(fp, "\r\n Brudd i R2 i Sloyfe %d: %s", i+1, ctime(&seconds));//Kun en beskjed som blir loggført med klokketid.
                    fclose(fp);//Stenger filen fp.
                    b[i+i+1]=1;// Led på bargraf med element nr i+i+1 blir satt til en for å indikere feil på R2 i denne sløyfen. Oddetall altså b1, b3, b5 og b7.
                }
                break;// Ferdig med hva som er blitt bedt av den og avlutter case 3 går tilbake til for løkken.
            }
            case 4: 
            {
               // Dersom denne verdien er 4 gå inn her og utfør dette også gå ut av case 4 tilbake til for løkken.
                blink[i]=1;// Blink[i] får verdien 1 og led[i] begynner å blinke.
                if(b[i+i] == 0 || b[i+i+1] == 0) 
                {
                    FILE *fp = fopen("/local/SYSTEMLOG.txt", "a");// File blir peket til fp og fp blir åpnet for skriving.
                    if(a < 0.25){fprintf(fp, "\r\n Brudd i hele Sloyfe %d: %s", i+1, ctime(&seconds));}//Kun en beskjed som blir loggført med klokketid.
                    else if(a >=0.88){fprintf(fp, "\r\n Brudd i R1 og R2 i Sloyfe %d: %s", i+1, ctime(&seconds));}//Kun en beskjed som blir loggført med klokketid.
                    fclose(fp);//Stenger filen fp.
                    b[i+i]=1;// Led på bargraf med element nr i+i blir satt til en for å indikere feil på R1 i denne sløyfen. Partall, altså b0, b2, b4 og b6.
                    b[i+i+1]=1;// Led på bargraf med element nr i+i+1 blir satt til en for å indikere feil på R2 i denne sløyfen. Oddetall altså b1, b3, b5 og b7.
                }
                break;// Ferdig med hva som er blitt bedt av den og avlutter case 4 går tilbake til for løkken.
            }
        }
    }
}