#include "mbed.h"
#include <iostream>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>

using namespace std;

// Interaktive knapper
InterruptIn knappSpiller1(p5);
InterruptIn knappSpiller2(p6);
InterruptIn knappAvslutt(p7);

// Porter til "spillelys"
DigitalOut myled(LED1);
DigitalOut bargraph[5] = {p26, p27, p28, p29, p30};
DigitalOut bsone[4] = {p21, p22, p23, p24};
DigitalOut led1(LED1), led2(LED2);
BusOut buss(p26, p27, p28, p29, p30);

Serial pc(USBTX, USBRX);

/* ------------------ */

const int SPILLER_1 = 0, SPILLER_2 = 1;         // Spillere
const int FOROVER = 0, BAKOVER = 1;             // Lysretning
const int ANTALL_LYSBLINK = 4;                  // Lysblink ved tap
const int VENTETID_LYS_TAP = 250;               // Varighet av lysblink ved tap

const int VANSKELIGHETSGRAD_LETT = 400;         //
const int VANSKELIGHETSGRAD_MEDIUM = 250;       // ventetid i ms
const int VANSKELIGHETSGRAD_VANSKELIG = 150;
int lyskjappere = 0;           // input fra tera term
int ventetidmult = 0;          // variabelen i ventetiden som blir trekt ifra
int lyspaa = 0;                // velger om ventetidmult skal være på eller av

/* ------------------ */
///////////////////////////////////////////////////////////////////////////////////
int scoreSpiller1 = 0;
int scoreSpiller2 = 0;
int vanskelighetsgrad;
int serveSide = SPILLER_1;   // Hvilken side ballen skal(serves start å tapt runde)
float ventetid;              // Ventetid i ms, justeres i starten.
bool gyldigSpiller1 = false;
bool gyldigSpiller2 = false; // Brukes til å sjekke om skuddet er gyldig.
bool treffSpiller1 = false;
bool treffSpiller2 = false;  // sjekker om spilleren traff ballen innenfor tiden
bool spillTapt = false;      // Holder styr på om spillet er tapt eller ikke.

/* ------------------ */

// Loop for lysdiodene
void loopLys(int retning)
{
    if(retning == FOROVER) {
        for(int a = 0; a < 5; a++) {
            if(spillTapt) {
                break;
            }
            bargraph[a] = 1;
            wait_ms(ventetid-ventetidmult*10);
            bargraph[a] = 0;
        }
    } else if(retning == BAKOVER) {
        for(int a = 4; a >= 0; a--) {
            if(spillTapt) {
                break;
            }
            bargraph[a] = 1;
            wait_ms(ventetid-ventetidmult*10);
            bargraph[a] = 0;
        }
    } else {
        cout << "ERROR: Lysretning ikke valgt." << endl;
        exit(1);
    }
}

///////////////////////////////////////////////////////////////////////////////////
// Lysblink ved tapt runde.
void TapLys()
{
    treffSpiller1 = false;//resetter spiller treff til 0 så det ikke skal bli loop
    treffSpiller2 = false;
    bsone[0] = 1;
    bsone[1] = 0;
    bsone[2] = 0;
    bsone[3] = 1;
    for(int i = 0; i < ANTALL_LYSBLINK; i++) {
        bargraph[0] = 1;
        bargraph[1] = 1;
        bargraph[2] = 1;
        bargraph[3] = 1;
        bargraph[4] = 1;
        wait_ms(VENTETID_LYS_TAP);
        bargraph[0] = 0;
        bargraph[1] = 0;
        bargraph[2] = 0;
        bargraph[3] = 0;
        bargraph[4] = 0;
        wait_ms(VENTETID_LYS_TAP);
    }

}



void ServeSpiller1()
{
    bsone[0] = 0;
    bsone[1] = 1;
    bsone[2] = 1;
    bsone[3] = 1;
    loopLys(BAKOVER);
    bsone[0] = 1;
    bsone[1] = 0;
    loopLys(BAKOVER);
    bsone[1] = 1;
    bsone[2] = 0;
    loopLys(BAKOVER);
    bsone[2] = 1;
    bsone[3] = 0;
    loopLys(BAKOVER);

}

void ServeSpiller2()
{
    bsone[0] = 1;
    bsone[1] = 1;
    bsone[2] = 1;
    bsone[3] = 0;
    loopLys(FOROVER);
    bsone[2] = 0;
    bsone[3] = 1;
    loopLys(FOROVER);
    bsone[1] = 0;
    bsone[2] = 1;
    loopLys(FOROVER);
    bsone[0] = 0;
    bsone[1] = 1;
    loopLys(FOROVER);

}
// Kjøres når en spiller taper. Poeng til motstanderen og print score i konsollen.
void TaptSpill (int spiller)
{
    spillTapt = true;
    cout << "//" << endl;
    cout << "Runde avsluttet. ";
    if (spiller == SPILLER_1) {
        scoreSpiller2++;
        cout << "Spiller 2 scoret." << endl;
    } else {
        scoreSpiller1++;
        cout << "Spiller 1 scoret." << endl;
    }
    cout << "Stilling: SPILLER 1 -- " << scoreSpiller1 << ":"
         << scoreSpiller2 << " -- SPILLER 2" << endl;
    cout << "//" << endl;
    TapLys();
}
///////////////////////////////////////////////////////////////////////////////////
void SkuddSpiller1()
{
    // Deaktiverer skuddknappene.
    knappSpiller1.rise(NULL);
    knappSpiller2.rise(NULL);

    if (gyldigSpiller1) {           // Om skuddet er gyldig registereres det...
        gyldigSpiller1 = false;
        treffSpiller1 = true;
        treffSpiller2 = false;
    } else {
        TaptSpill(SPILLER_1);       // ...ellers taper spilleren.
    }
}

void SkuddSpiller2()
{
    // Deaktiverer skuddknappene.
    knappSpiller1.rise(NULL);
    knappSpiller2.rise(NULL);

    if (gyldigSpiller2) {           // Om skuddet er gyldig registereres det...
        gyldigSpiller2 = false;
        treffSpiller2 = true;
        treffSpiller1 = false;
    } else {
        TaptSpill(SPILLER_2);       // ...ellers taper spilleren.
    }
}

void Avslutt()
{
    cout << "----" << endl;
    cout << "Spill avsluttet." << endl;
    cout << "Stilling: SPILLER 1 -- " << scoreSpiller1 << ":" << scoreSpiller2 << " -- SPILLER 2" << endl;
    cout << "----" << endl;
    exit(0);
}

int main()
{
    // Aktiverer avslutt-knappen.
    knappAvslutt.rise(&Avslutt);

    cout << "1 - Vanskelig: " << VANSKELIGHETSGRAD_VANSKELIG << "ms" << endl;   //
    cout << "2 - Middels: " << VANSKELIGHETSGRAD_MEDIUM << "ms" << endl;        // Printer vanskelighetsgradene
    cout << "3 - Lett: " << VANSKELIGHETSGRAD_LETT << "ms" << endl;             //
start:
    cout << "Tast inn vanskelighetsgrad og tast ENTER: ";
    cin >> vanskelighetsgrad;                                                   // Henter brukerens valg.
    cout << vanskelighetsgrad << endl;
    cout << "skal lyset bli kjappere etter hver runde? 1 = ja og 2 = nei ";
    cin >> lyskjappere;
    cout << lyskjappere << endl;                                        // Og printer valget tilbake.

    // Setter vanskelighetsgraden på spillet.

    if(lyskjappere == 1) {
        lyspaa = 1;
    } else if (lyskjappere == 2) {
        lyspaa = 0;
    }
    if(vanskelighetsgrad == 1) {
        ventetid = VANSKELIGHETSGRAD_VANSKELIG;
    } else if (vanskelighetsgrad == 2) {
        ventetid = VANSKELIGHETSGRAD_MEDIUM;
    } else if (vanskelighetsgrad == 3) {
        ventetid = VANSKELIGHETSGRAD_LETT;
    } else {
        cout << "Vennligst velg et tall mellom 1-3." << endl;   // Om ikke valget er gyldig, sendes
        goto start;                                             // spilleren tilbake til starten.
    }

    cout << "----" << endl;
    cout << "SPILL START" << endl;
    cout << "----" << endl;

    while(1) {

        if (lyspaa == 1) {
            ventetidmult++;
        }
        // Aktiverer skuddknappene.
        knappSpiller1.rise(&SkuddSpiller1);
        knappSpiller2.rise(&SkuddSpiller2);

        spillTapt = false;                  // Resetter variabelen så den kan brukes på nytt.
        switch(serveSide) {                 // Undersøker hvilken side som skal serve.
            case SPILLER_1:
                ServeSpiller1();                //
                gyldigSpiller2 = true;          // Når lyset har kommet til motstanderens side
                wait_ms(ventetid);              // aktiveres tidsrommet som motstanderen kan skyte i.
                gyldigSpiller2 = false;         //
                if(!spillTapt) {
                    if(!treffSpiller2) {        // Om ikke spilleren treffer ballen, taper spilleren.
                        TaptSpill(SPILLER_2);   //
                    }
                }
                break;
            case SPILLER_2:
                ServeSpiller2();                //
                gyldigSpiller1 = true;          //
                wait_ms(ventetid);              // Samme som over, for motsatt side.
                gyldigSpiller1 = false;         //
                if(!spillTapt) {
                    if(!treffSpiller1) {        //
                        TaptSpill(SPILLER_1);   //
                    }
                }
                break;
        }
        if(serveSide == SPILLER_1) {        // Etter ballen har blitt skutt én vei,
            serveSide = SPILLER_2;          // byttes servesiden.
        } else {
            serveSide = SPILLER_1;
        }
    }
}