// ESP8266 Static page WEB server to control Mbed

#include "mbed.h"
#include "algorithm.h"
#include "MAX30102.h"
#include "MAX30101.h"

#define MAX_BRIGHTNESS 255
Serial pc(USBTX, USBRX);
Serial esp(p13, p14); 
//Serial esp(p28, p27); // tx, rx


// Standard Mbed LED definitions
DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  led4(LED4);

// some test values to show on web page
AnalogIn   Ain1(p18);
AnalogIn   LM35B(p19);
AnalogIn   LM35A(p20);
DigitalIn  INT(p8);
DigitalIn  INT1(p7);
/*
char ssid[32] = "hsd";     // enter WiFi router ssid inside the quotes
char pwd [32] = "austin123"; // enter WiFi router password inside the quotes
*/

uint32_t aun_ir_buffer[500]; //IR LED sensor data
int32_t n_ir_buffer_length;    //data length
uint32_t aun_red_buffer[500];    //Red LED sensor data
int32_t n_sp02; //SPO2 value
int8_t ch_spo2_valid;   //indicator to show if the SP02 calculation is valid
int32_t n_heart_rate;   //heart rate value
int8_t  ch_hr_valid;    //indicator to show if the heart rate calculation is valid
uint8_t uch_dummy;

uint32_t aun_ir_buffer1[500]; //IR LED sensor data
int32_t n_ir_buffer_length1;    //data length
uint32_t aun_red_buffer1[500];    //Red LED sensor data
int32_t n_sp021; //SPO2 value
int8_t ch_spo2_valid1;   //indicator to show if the SP02 calculation is valid
int32_t n_heart_rate1;   //heart rate value
int8_t  ch_hr_valid1;    //indicator to show if the heart rate calculation is valid
uint8_t uch_dummy1;


char uploadTimeOut=1;
Timer timer1second;

float temperature, AdcIn, Ht;
float R1=100000, R2=10000; // resistor values to give a 10:1 reduction of measured AnalogIn voltage
char Vcc[10];
char TempA[10];
char TempB[10];
char Null[10];

float f_temp;
uint32_t un_min, un_max, un_prev_data;  //variables to calculate the on-board LED brightness that reflects the heartbeats

float f_temp1;
uint32_t un_min1, un_max1, un_prev_data1;  //variables to calculate the on-board LED brightness that reflects the heartbeats
int i1;
int32_t n_brightness1;

int i;
int32_t n_brightness;

// things for sending/receiving data over serial
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 4095;
char tx_buffer[buffer_size+1];
char rx_buffer[buffer_size+1];
void Tx_interrupt();
void Rx_interrupt();
void send_line();
void read_line();

int DataRX;
int update;
int count;
char cmdbuff[1024];
char replybuff[4096];
char webdata[4096]; // This may need to be bigger depending on WEB browser used
char webbuff[4096];     // Currently using 1986 characters, Increase this if more web page data added
char timebuf[30];
void SendCMD(),getreply(),ReadWebData(),startserver();
void gettime(),setRTC(),gettemp(),getbattery();
char rx_line[1024];
int port        =80;  // set server port
int SERVtimeout =5;    // set server timeout in seconds in case link breaks.
struct tm t;
// manual set RTC values
int minute      =20;    // 0-59
int hour        =11;    // 2-23
int dayofmonth  =13;    // 1-31
int month       =4;     // 1-12
int year        =19;    // last 2 digits

void gettemp()
{
    float temp_C , temp_F, average[10], averageTemp;
    float tempB_C , tempB_F, averageB[10], averageTempB;
    int index;
    
    averageTemp=0;
            for(index=0; index<10; index++)
            {
                average[index]=LM35A.read();
                     //wait(0.02);
            }
            for(index=0; index<10; index++)
            {
                averageTemp  = (averageTemp +(average[index]/10));
            }
            temp_C=(averageTemp*3.685*100);
            temp_F=(((9.0*temp_C)/5.0) + 32.0);
            sprintf(TempA,"%2.3f",temp_C);
            
    averageTempB=0;  
            for(index=0; index<10; index++)
            {
                average[index]=LM35B.read();
                     //wait(0.02);
            }
            for(index=0; index<10; index++)
            {
                averageTempB  = (averageTempB +(averageB[index]/10));
            }
            tempB_C=(averageTempB*3.685*100);
            tempB_F=(((9.0*tempB_C)/5.0) + 32.0);
            sprintf(TempB,"%2.3f",tempB_C);
            
    pc.printf("Temperature of Patient 1 is %.2f C, %.2f F \n\r ", temp_C,temp_F);
    pc.printf("Temperature of Patient 1 is %.2f C, %.2f F \n\r ", tempB_C,tempB_F);
}


void heartbeatInitA()
{
     maxim_max30102_reset(); //resets the MAX30102
     wait(1);
     //read and clear status register
    maxim_max30102_read_reg(0,&uch_dummy);
    
    //while(pc.readable()==0)
    {
       // pc.printf("\x1B[2J");  //clear terminal program screen
        pc.printf("Press any key to start conversion\n\r");
        wait(1);
    }
    uch_dummy=getchar();
    
    maxim_max30102_init();  //initializes the MAX30102
          
    n_brightness=0;
    un_min=0x3FFFF;
    un_max=0;
  
    n_ir_buffer_length=500; //buffer length of 100 stores 5 seconds of samples running at 100sps
    
    //read the first 500 samples, and determine the signal range
    for(i=0;i<n_ir_buffer_length;i++)
    {
        while(INT.read()==1);   //wait until the interrupt pin asserts
        
        maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));  //read from MAX30102 FIFO
            
        if(un_min>aun_red_buffer[i])
            un_min=aun_red_buffer[i];    //update signal min
        if(un_max<aun_red_buffer[i])
            un_max=aun_red_buffer[i];    //update signal max
        pc.printf("red=");
        pc.printf("%i", aun_red_buffer[i]);
        pc.printf(", ir=");
        pc.printf("%i\n\r", aun_ir_buffer[i]);
    }
    un_prev_data=aun_red_buffer[i];

    //calculate heart rate and SpO2 after first 500 samples (first 5 seconds of samples)
    maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid);     
     
}


void heartbeatInitB()
{
 maxim_max30101_reset(); //resets the MAX30102
     wait(1);
     //read and clear status register
  
    
    maxim_max30101_init();  //initializes the MAX30102
          
    n_brightness1=0;
    un_min1=0x3FFFF;
    un_max1=0;
  
    n_ir_buffer_length1=500; //buffer length of 100 stores 5 seconds of samples running at 100sps
    
    //read the first 500 samples, and determine the signal range
    for(i=0;i<n_ir_buffer_length1;i++)
    {
        while(INT1.read()==1);   //wait until the interrupt pin asserts
        
        maxim_max30101_read_fifo(((aun_red_buffer1)+i), ((aun_ir_buffer1)+i));  //read from MAX30102 FIFO
            
        if(un_min1>aun_red_buffer1[i])
            un_min1=aun_red_buffer1[i];    //update signal min
        if(un_max1<aun_red_buffer1[i])
            un_max1=aun_red_buffer1[i];    //update signal max
        pc.printf("red=");
        pc.printf("%i", aun_red_buffer1[i]);
        pc.printf(", ir=");
        pc.printf("%i\n\r", aun_ir_buffer1[i]);
    }
    un_prev_data1=aun_red_buffer1[i];

    //calculate heart rate and SpO2 after first 500 samples (first 5 seconds of samples)
    maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer1, n_ir_buffer_length1, aun_red_buffer1, &n_sp021, &ch_spo2_valid1, &n_heart_rate1, &ch_hr_valid1);      
}

void heartbeatUpdateA()
{
        i=0;
        un_min=0x3FFFF;
        un_max=0;

        //dumping the first 100 sets of samples in the memory and shift the last 400 sets of samples to the top
        for(i=100;i<500;i++)
        {
            aun_red_buffer[i-100]=aun_red_buffer[i];
            aun_ir_buffer[i-100]=aun_ir_buffer[i];
            
            //update the signal min and max
            if(un_min>aun_red_buffer[i])
            un_min=aun_red_buffer[i];
            if(un_max<aun_red_buffer[i])
            un_max=aun_red_buffer[i];
            
        }
        
        //take 100 sets of samples before calculating the heart rate.
        for(i=400;i<500;i++)
        {
            un_prev_data=aun_red_buffer[i-1];
            while(INT.read()==1);
            maxim_max30102_read_fifo((aun_red_buffer+i), (aun_ir_buffer+i));
        
            if(aun_red_buffer[i]>un_prev_data)
            {
                f_temp=aun_red_buffer[i]-un_prev_data;
                f_temp/=(un_max-un_min);
                f_temp*=MAX_BRIGHTNESS;
                n_brightness-=(int)f_temp;
                if(n_brightness<0)
                    n_brightness=0;
            }
            else
            {
                f_temp=un_prev_data-aun_red_buffer[i];
                f_temp/=(un_max-un_min);
                f_temp*=MAX_BRIGHTNESS;
                n_brightness+=(int)f_temp;
                if(n_brightness>MAX_BRIGHTNESS)
                    n_brightness=MAX_BRIGHTNESS;
            }
        //pc.printf("red=%i, ir=%i, HR=%i,HRvalid=%i,SpO2=%i,SPO2Valid=%i\n\r",aun_red_buffer[i],aun_ir_buffer[i],n_heart_rate, ch_hr_valid, n_sp02, ch_spo2_valid);
         
        }
        maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer, n_ir_buffer_length, aun_red_buffer, &n_sp02, &ch_spo2_valid, &n_heart_rate, &ch_hr_valid); 
    sprintf(Vcc,"%i",n_heart_rate);
                
}

void heartbeatUpdateB()
{
        i=0;
        un_min1=0x3FFFF;
        un_max1=0;

        //dumping the first 100 sets of samples in the memory and shift the last 400 sets of samples to the top
        for(i=100;i<500;i++)
        {
            aun_red_buffer1[i-100]=aun_red_buffer1[i];
            aun_ir_buffer1[i-100]=aun_ir_buffer1[i];
            
            //update the signal min and max
            if(un_min1>aun_red_buffer1[i])
            un_min1=aun_red_buffer1[i];
            if(un_max1<aun_red_buffer1[i])
            un_max1=aun_red_buffer1[i];
        }
        
        //take 100 sets of samples before calculating the heart rate.
        for(i=400;i<500;i++)
        {
            un_prev_data1=aun_red_buffer1[i-1];
            while(INT1.read()==1);
            maxim_max30101_read_fifo((aun_red_buffer1+i), (aun_ir_buffer1+i));
        
            if(aun_red_buffer1[i]>un_prev_data1)
            {
                f_temp1=aun_red_buffer1[i]-un_prev_data1;
                f_temp1/=(un_max1-un_min1);
                f_temp1*=MAX_BRIGHTNESS;
                n_brightness1-=(int)f_temp1;
                if(n_brightness1<0)
                    n_brightness1=0;
            }
            else
            {
                f_temp1=un_prev_data1-aun_red_buffer1[i];
                f_temp1/=(un_max1-un_min1);
                f_temp1*=MAX_BRIGHTNESS;
                n_brightness1+=(int)f_temp1;
                if(n_brightness1>MAX_BRIGHTNESS)
                    n_brightness1=MAX_BRIGHTNESS;
            }
        //pc.printf("red=%i, ir=%i, HR=%i,HRvalid=%i,SpO2=%i,SPO2Valid=%i\n\r",aun_red_buffer[i],aun_ir_buffer[i],n_heart_rate, ch_hr_valid, n_sp02, ch_spo2_valid);
         
        }
        maxim_heart_rate_and_oxygen_saturation(aun_ir_buffer1, n_ir_buffer_length1, aun_red_buffer1, &n_sp021, &ch_spo2_valid1, &n_heart_rate1, &ch_hr_valid1); 
        sprintf(Vcc,"%i",n_heart_rate1);
                
}

int main()
{
    pc.baud(115200);
    esp.baud(9600);
    led1=1,led2=0,led3=0, led4=0;
    // Setup a serial interrupt function to receive data
    esp.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    esp.attach(&Tx_interrupt, Serial::TxIrq);
    if (time(NULL) < 1420070400) {
        setRTC();
    }
    startserver();
    DataRX=0;
    count=0;
    heartbeatInitB();
    heartbeatInitA();
    timer1second.start(); 
    while(1) {
        if(DataRX==1) 
        {
            ReadWebData();
            esp.attach(&Rx_interrupt, Serial::RxIrq);
        }

        heartbeatUpdateB();
        heartbeatUpdateA();
        
        if(timer1second.read()>2)
        {   
            timer1second.reset();
         
            gettime();
            gettemp();
           // getbattery();
           
            count++;
            sprintf(cmdbuff, "count,time,analog1,analog2=%d,\"%s\",\"%s\",\"%s\"\r\n",count,timebuf,TempA,Vcc);
            
            SendCMD();
            getreply();
            
            update=0;   
      
        }
    }
}

// Reads and processes GET and POST web data
void ReadWebData()
{
    wait_ms(200);
    esp.attach(NULL,Serial::RxIrq);
    DataRX=0;
    memset(webdata, '\0', sizeof(webdata));
    strcpy(webdata, rx_buffer);
    memset(rx_buffer, '\0', sizeof(rx_buffer));
    rx_in = 0;
    rx_out = 0;
    // check web data for form information
    if( strstr(webdata, "check=led1v") != NULL ) {
        led1=!led1;
    }
    if( strstr(webdata, "check=led2v") != NULL ) {
        led2=!led2;
    }
    if( strstr(webdata, "check=led3v") != NULL ) {
        led3=!led3;
    }
    if( strstr(webdata, "check=led4v") != NULL ) {
        led4=!led4;
    }
    if( strstr(webdata, "POST") != NULL ) { // set update flag if POST request
        update=1;
    }
    if( strstr(webdata, "GET") != NULL && strstr(webdata, "favicon") == NULL ) { // set update flag for GET request but do not want to update for favicon requests
        update=1;
    }
}
// Starts webserver
void startserver()
{
    gettime();
    gettemp();
    getbattery();
    pc.printf("++++++++++ Resetting ESP ++++++++++\r\n");
    strcpy(cmdbuff,"node.restart()\r\n");
    SendCMD();
    wait(2);
    getreply();
    
    pc.printf("\n++++++++++ Starting Server ++++++++++\r\n> ");

    // initial values
    sprintf(cmdbuff, "count,time,analog1,analog2=0,\"%s\",\"%s\",\"%s\"\r\n",timebuf,TempA,Vcc);
    SendCMD();
    getreply();
    wait(0.5);

    //create server
    sprintf(cmdbuff, "srv=net.createServer(net.TCP,%d)\r\n",SERVtimeout);
    SendCMD();
    getreply();
    wait(0.5);
    strcpy(cmdbuff,"srv:listen(80,function(conn)\r\n");
    SendCMD();
    getreply();
    wait(0.3);
        strcpy(cmdbuff,"conn:on(\"receive\",function(conn,payload) \r\n");
        SendCMD();
        getreply();
        wait(0.3);
        
        //print data to mbed
        strcpy(cmdbuff,"print(payload)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
       
        //web page data
        strcpy(cmdbuff,"conn:send('<!DOCTYPE html><html><meta http-equiv=\"refresh\" content=\"2\"><body><h1>Meditek Web Monitor</h1>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        strcpy(cmdbuff,"conn:send('Hit count: '..count..'')\r\n");
        SendCMD();
        getreply();
        wait(0.2);
        strcpy(cmdbuff,"conn:send('<br>Last hit (based on mbed RTC time): '..time..'<br><hr>')\r\n");
        SendCMD();
        getreply();
        wait(0.4);
        
        strcpy(cmdbuff,"conn:send('Current Temp is : '..analog1..' C<br>Current HeartRate is : '..analog2..' count/min<br><hr>')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff,"conn:send('<form method=\"POST\"')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led1v\"> flip LED1')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led2v\"> flip LED2')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led3v\"> flip LED3')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><input type=\"checkbox\" name=\"check\" value=\"led4v\"> flip LED4')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff,"conn:send('<p><input type=\"submit\" value=\"send-refresh\"></form>')\r\n");
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "conn:send('<p><h2>How to use:</h2><ul><li>Select a checkbox to flip on/off</li><li>Click Send-Refresh to send data and refresh values</li></ul></body></html>')\r\n");
        SendCMD();
        getreply();
        wait(0.5); 
        // end web page data
        strcpy(cmdbuff, "conn:on(\"sent\",function(conn) conn:close() end)\r\n"); // close current connection
        SendCMD();
        getreply();
        wait(0.3);
        strcpy(cmdbuff, "end)\r\n");
        SendCMD();
        getreply();
        wait(0.2);
    strcpy(cmdbuff, "end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);

    strcpy(cmdbuff, "tmr.alarm(0, 1000, 1, function()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "if wifi.sta.getip() == nil then\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "print(\"Connecting to AP...\\n\")\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "else\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff, "ip, nm, gw=wifi.sta.getip()\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"print(\"IP Address: \",ip)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"tmr.stop(0)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    strcpy(cmdbuff,"end)\r\n");
    SendCMD();
    getreply();
    wait(0.2);
    
    pc.printf("\n\n++++++++++ Ready ++++++++++\r\n\n");
}


// ESP Command data send
void SendCMD()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (cmdbuff[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = cmdbuff[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (esp.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
// Send first character to start tx interrupts, if stopped
        esp.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}

// Get Command and ESP status replies
void getreply()
{
    read_line();
    sscanf(rx_line,replybuff);
}
 
// Read a line from the large rx buffer from rx interrupt routine
void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}
 
 
// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    DataRX=1;
    //led3=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((esp.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = esp.getc();
// Uncomment to Echo to USB serial to watch data flow
        pc.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    //led3=0;
    return;
}
 
 
// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((esp.writeable()) && (tx_in != tx_out)) {
        esp.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    //led2=0;
    return;
}

void gettime()
{
    time_t seconds = time(NULL);
    strftime(timebuf,50,"%H:%M:%S %a %d %b %y", localtime(&seconds));
}

void setRTC()
{
    t.tm_sec = (0);             // 0-59
    t.tm_min = (minute);        // 0-59
    t.tm_hour = (hour);         // 0-23
    t.tm_mday = (dayofmonth);   // 1-31
    t.tm_mon = (month-1);       // 0-11  "0" = Jan, -1 added for Mbed RCT clock format
    t.tm_year = ((year)+100);   // year since 1900,  current DCF year + 100 + 1900 = correct year
    set_time(mktime(&t));       // set RTC clock
}
// Analog in example
void getbattery()
{
    
}
// Temperature example

