#include "mbed.h"
#include "music.h"
#include "C12832.h"


AnalogIn pot1(p19);
AnalogIn pot2(p20);
AnalogIn mic(p17);
AnalogOut voice(p18);
PwmOut speaker(p26);
DigitalIn down(p12);
DigitalIn left(p13);
DigitalIn center(p14);
DigitalIn up(p15);
DigitalIn right(p16);
I2C master(p9, p10);
C12832 lcd(p5, p7, p6, p8, p11);

static char addr = 0x42;
static char read = 0x01;
unsigned char tempo;
char freqLocal;
char freqSend;
float note;

Serial term(USBTX, USBRX);


float fu = 2;
float ha = fu/2;
float qu = fu/4;
float tq = fu*3/4;
float ei = fu/8;
float si = fu / 16;


int aliveBackNotes[] = {
    //Page1
    R,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,R,
    R,R,R,R,
    R,R,R,D3,D3,B2,B2,
    //Page2
    D3,D3,B2,B2,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,
    A2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,E3,E3,E3,F3,G3,A2,A2,A2,B2,C3,A2,
    //Page3
    Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,F3,F3,R,C3,C3,R,Bb2,Bb2,R,F3,F3,R,
    F3,F3,R,C3,C3,R,Bb2,Bb2,R,F3,F3,R,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,
    F3,F3,E3,E3,D3,D3,C2,C2,Bb2,F3,A2,E3,D3,D3,Bb2,Bb2,D3,D3,Bb2,Bb2,
    D3,D2,B2,B2,
    //Page2
    D3,D3,B2,B2,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,
    A2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,E3,E3,E3,F3,G3,A2,A2,A2,B2,C3,A2,
    //Page3
    Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,F3,F3,R,C3,C3,R,Bb2,Bb2,R,F3,F3,R,
    F3,F3,R,C3,C3,R,Bb2,Bb2,R,F3,F3,R,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,
    F3,F3,E3,E3,D3,D3,C2,C2,Bb2,F3,A2,E3,
    //still alives
    D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,D3,D3,B2,B2,
    D3,D3,B2,B2,D3,D3,B2,B2,D3,D3,B2,B2,D3,D3,B2,B2,D3,R
};

float aliveBackBeat[] = {
    // R ,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    ha,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei, ei,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei, ei,ei,
//                          A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,
//                          A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,
//                          A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,R,
    ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ei,ei,ei ,ei,ha,
//                           R, R, R, R,
    fu,fu,fu,fu,
//                           R, R, R, D3  ,D3, B2  ,B2,
    fu,fu,fu,qu+ei,ei,qu+ei,ei,
//                          //Page2
//                          D3   ,D3,B2,B2,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    qu+ei,ei,ei,ei,ei,ei,ei ,ei,ei,ei, ei,ei,
//                          A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,
    ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,
//                          A2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,   D3,D3,   B2,B2,   D3,D3,   B2,B2,
    ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   E3,E3,E3,F3,G3,   A2,A2,A2,B2,C3,A2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,ei,ei,qu,qu+ei,ei,ei,ei,ei,ei,
//                          //Page3
//                          Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,F3,F3, R,C3,C3, R,Bb2,Bb2, R,F3,F3, R,
    qu,ei ,ei ,ei ,ei ,ei ,ei ,ei,ei,ei,ei,ei,ei,ei ,ei ,ei,ei,ei,ei,
//                          F3,F3, R,C3,C3, R,Bb2,Bb2, R,F3,F3, R,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,
    ei,ei,ei,ei,ei,ei, ei, ei,ei,ei,ei,ei, ei, ei, ei, ei, ei, ei, ei, ei,
//                          F3,F3,E3,E3,D3,D3,C2,C2,Bb2,F3,A2,E3,   D3,D3,  Bb2,Bb2,  D3,D3,  Bb2,Bb2,
    ei,ei,ei,ei,ei,ei,ei,ei, qu,qu,qu,qu,ei+qu,ei,qu+ei,ei,qu+ei,ei,qu+ei, ei,
//                             D3,D2,   B2,B2,
    qu+ei,ei,qu+ei,ei,
//                          //Page2
//                          D3   ,D3,B2,B2,A2,D3,Fs3,D3,B2,D3,Fs3,D3,
    qu+ei,ei,ei,ei,ei,ei,ei ,ei,ei,ei, ei,ei,
//                          A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,B2,D3,Fs3,D3,
    ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,
//                          A2,D3,Fs3,D3,A2,D3,Fs3,D3,A2,D3,Fs3,D3,B2,D3,Fs3,D3,   D3,D3,   B2,B2,   D3,D3,   B2,B2,
    ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,ei,ei, ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   E3,E3,E3,F3,G3,   A2,A2,A2,B2,C3,A2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,ei,ei,qu,qu+ei,ei,ei,ei,ei,ei,
//                          //Page3
//                          Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,F3,F3, R,C3,C3, R,Bb2,Bb2, R,F3,F3, R,
    qu,ei ,ei ,ei ,ei ,ei ,ei ,ei,ei,ei,ei,ei,ei,ei ,ei ,ei,ei,ei,ei,
//                          F3,F3, R,C3,C3, R,Bb2,Bb2, R,F3,F3, R,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,Bb2,
    ei,ei,ei,ei,ei,ei, ei, ei,ei,ei,ei,ei, ei, ei, ei, ei, ei, ei, ei, ei,
//                          F3,F3,E3,E3,D3,D3,C2,C2,Bb2,F3,A2,E3,
    ei,ei,ei,ei,ei,ei,ei,ei, qu,qu,qu,qu,
//                          //still alives
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,
//                             D3,D3,   B2,B2,   D3,D3,   B2,B2,D3, R,
    qu+ei,ei,qu+ei,ei,qu+ei,ei,qu+ei,ei,ha,ha
};


int aliveNotes[] = {    G4,Fs4,E4,E4,Fs4,R,R,R,A3,G4,Fs4,E4,E4,E4,Fs4,D4,E4,A3,R,//18                       //1
                        A3,A3,E4,Fs4,G4,G4,Fs4,Cs4,Cs4,D4,E4,A3,A3,A3,Fs4,Fs4,//16                          //2
                        R,G4,Fs4,E4,E4,Fs4,R,R,R,A3,G4,Fs4,E4,E4,E4,Fs4,D4,D4,E4,A3,                         //3
                        R,R,E4,Fs4,G4,G4,Fs4,Cs4,Cs4,D4,E4,E4,A3,D4,E4,F4,E4,D4,C4,R,A3,Bb3,                //4
                        C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,A3,Bb3,C4,F4,G4,F4,E4,D4,D4,D4,F4,F4,G4,A4,           //5
                        Bb4,Bb4,A4,G4,F4,G4,A4,A4,G4,F4,E4,C4,D4,F4,F4,E4,E4,E4, Fs4,Fs4,R,R,//A4,D5,Fs5,D5,B4,D5,Fs5,D5, FAKE BACKBEAT //6
                        //A4,D5,Fs5,D5,B4,D5,Fs5,D4,A4,D5,Fs5,D5,B4,D5,Fs5,D4, FAKE BACKBEAT
                        //VERSE2 sheet2
                        R,R,A3,G4,Fs4,E4,E4,E4,Fs4,Fs4,R, //1
                        R,R,A3,G4,Fs4,E4,E4,E4,Fs4,D4,D4,E4,A3,A3,R,E4,Fs4,G4,G4,Fs4, //2
                        Cs4,D4,E4,E4,A3,A3,A3,Fs4,Fs4,R,R,R,A3,G4,Fs4,E4,E4,Fs4,R,R, //3
                        R,R,A3,G4,Fs4,E4 ,E4 ,E4,Fs4,D4,E4,Fs4,A3, //4
                        R,R,E4,Fs4,G4,G4,E4,Cs4,D4,E4,E4,A3,D4,E4, //5
                        F4,E4,D4,C4,C4,A3,Bb3,C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,A3,Bb3, //sheet3 1
                        C4,F4,G4,F4,E4,D4,D4,E4,F4,F4,G4,A4,Bb4,Bb4,A4,A4,G4,F4,G4, //sheet3 2
                        A4,A4,G4,F4,F4,D4,C4,D4,F4,F4,E4,E4,E4,Fs4,Fs4,Fs4,R,R,R,       //sheet3 3
                        //VERSE3
                        R,R,A3,G4,Fs4,E4,E4,E4,Fs4,Fs4,R,
                        R,R,A3,G4,Fs4,E4,E4,E4,Fs4,D4,D4,E4,A3,A3,R,E4,Fs4,G4,G4,Fs4,
                        Cs4,D4,E4,E4,A3,A3,A3,Fs4,Fs4,R,R,R,A3,G4,Fs4,E4,E4,Fs4,R,R,
                        R,R,A3,G4,Fs4,E4 ,E4 ,E4,Fs4,D4,E4,Fs4,A3,A3,
                        R,E4,Fs4,G4,G4,E4,Cs4,D4,E4,E4,A3,D4,E4,
                        F4,E4,D4,C4,C4,A3,Bb3,C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,A3,Bb3,
                        C4,F4,G4,F4,E4,D4,D4,E4,F4,F4,G4,A4,Bb4,Bb4,A4,A4,G4,F4,G4,
                        A4,A4,G4,F4,F4,D4,C4,D4,F4,F4,E4,E4,F4,Fs4,Fs4,
                        //end still alives
                        R,R,A4,A4,A4,B4,A4,Fs4,D4,D4,E4,Fs4,Fs4,
                        R,R,A4,A4,A4,B4,A4,Fs4,D4,D4,E4,Fs4,Fs4,
                        R,R,A4,A4,A4,B4,A4,Fs4,D4,D4,E4,Fs4,Fs4,
                        R,R,A4,A4,A4,B4,A4,Fs4,D4,D4,E4,Fs4,Fs4,
                        R,R,A4,A4,A4,B4,A4,Fs4,D4,D4,E4,Fs4,Fs4,
                        //
                        R,R,G4,A4,A4,A4,R,R,G4,Fs4,Fs4,Fs4,R

                   };
float aliveBeat[] = {   ei,ei ,ei,ei,ha ,ha,qu,ei,ei,ei,ei ,ei,ei,qu+ei,qu ,ei,ei,ei,tq, //17
                        //its hard to overstate my satisfaction
                        // A3,A3,E4,Fs4,G4,G4,Fs4,Cs4,Cs4,D4   ,E4,A3,A3,A3,Fs4  ,Fs4,
                        ei,ei,qu,ei ,ei,qu,ei ,ei ,ei ,qu+ei,qu,ei,ei,ei,qu+ei,ha,//17
                        //aperture science we do what we must because we can
                        // R ,G4,Fs4,E4,E4,Fs4,R ,R ,R ,A3,G4,Fs4,E4,E4,E4,G4,D4,D4,E4,A3,
                        ha,ei,ei ,ei,ei,ha ,ha,qu,ei,ei,ei,ei ,ei,ei,qu,ei,ei,qu,ei,ei,//20
                        //for the good of all of us except the ones who are dead but theres
                        // R ,R ,E4,Fs4,G4,G4,Fs4,Cs4,Cs4,D4,E4,E4,A3,D4,E4,F4,E4,D4,C4,R ,A3,Bb3,
                        ha,ha,qu,ei ,ei,qu,ei ,ei ,qu ,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei ,ei,
                        //no sense crying over every mistake you just keep on trying till you runout of cake and the
                        // C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,A3,Bb3,C4,F4,G4,F4,E4,D4,D4,D4,F4,F4,G4,A4,
                        qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ei,ei ,qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ei,ei,
                        //science gets done, and you make a neat gun for the people who are still alive.
                        //  Bb4,Bb4,A4,G4,F4,G4,A4,A4,G4,F4,E4,C4,D4,F4,F4,E4,E4,E4, Fs4,Fs4, R, R,   //A4,D5,Fs5,D5,B4,D5,Fs5,D5,
                        ei ,ei ,qu,qu,ei,ei,ei,ei,qu,qu,ei,ei,ei,ei,ei,ei,ei,ei ,ei ,ei ,ha,ha,//ei,ei,ei,ei,ei,ei,ei,ei,FAKE BACKBEAT
                        // ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei, FAKE BACKBEAT
                        //R  R
                        //sheet2
                        //im not even angry
                        //  R ,R ,A3,G4,Fs4,E4,E4,E4,Fs4,Fs4,R, //1
                        qu,ei,ei,ei,ei ,ei,ei,si,ei ,ei ,ha ,
                        //im being so sincere right now. even through you
                        //  R ,R ,A3,G4,Fs4,E4,E4,E4,Fs4,D4,D4,E4,A3,A3,R,E4,Fs4,G4,G4,Fs4, //2
                        qu,ei,ei,ei,ei ,ei,ei,qu,ei ,ei,ei,qu,ei,ha,ha,qu,ei,ei,qu,qu ,
                        //you broke my heart and killed me. and tore me to pieces
                        // Cs4,D4,E4,E4,A3,A3,A3,Fs4,Fs4,R,R,R,A3,G4,Fs4,E4,E4,Fs4,R,R, //3
                        qu,ei,ei,qu,ei,ei,ei,qu+ei,qu,qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ha,
                        //and threw every puiece into a fire
                        //  R ,R ,A3,G4,Fs4,E4,E4,E4,Fs4,D4,E4,Fs4,A3, //4
                        qu,ei,ei,ei,ei ,ei,ei,qu,ei ,ei,qu,ei ,ei,
                        //as they burned it hurt because i was so
                        //  R ,E4,Fs4,G4,G4,E4,Cs4,D4,E4,E4,A3,D4,E4, //5
                        ha,ha,qu ,ei,ei,qu,qu ,qu,ei,ei,ei,ei,ei,ei,
                        //sheet3
                        //happy for you, now these points of data make a beautiful line and we're
                        //  F4,E4,D4,C4,C4,A3,Bb3,C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,A3,Bb3, //sheet3 1
                        ei,ei,ei,ei,qu,ei,ei ,qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ei,ei ,
                        //out of beta, we're releasing on time. so im GLaD i got burned. think of
                        //  C4,F4,G4,F4,E4,D4,D4,E4,F4,F4,G4,A4,Bb4,Bb4,A4,A4,G4,F4,G4, //sheet3 2
                        qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ei,ei,ei ,ei ,ei,ei,qu,ei,ei,
                        //all the things we learned for the people who are still alive.
                        //  A4,A4,G4,F4,F4,D4,C4,D4,F4,F4,E4,E4,E4,Fs4,Fs4,Fs4, R, R, R,       //sheet3 3
                        ei,ei,ei,ei,qu,ei,ei,ei,ei,ei,ei,ei,ei,ei ,ei ,ha ,ha,ha,ha,
                        //repete for verse 3
                        //sheet2
                        //Go head and leave me
                        //  R ,R ,A3,G4,Fs4,E4,E4,E4,Fs4,Fs4,R, //1
                        qu,ei,ei,ei,ei ,ei,ei,si,ei ,ei ,ha ,
                        //I think i prefer to stay inside. maybe you'll find
                        //  R ,R ,A3,G4,Fs4,E4,E4,E4,Fs4,D4,D4,E4,A3,A3,R,E4,Fs4,G4,G4,Fs4, //2
                        qu,ei,ei,ei,ei ,ei,ei,qu,ei ,ei,ei,qu,ei,ha,ha,qu,ei,ei,qu,qu ,
                        //someone else to help you. maybe black mesa
                        // Cs4,D4,E4,E4,A3,A3,A3,Fs4,Fs4,R,R,R,A3,G4,Fs4,E4,E4,Fs4,R,R, //3
                        qu,ei,ei,qu,ei,ei,ei,qu+ei,qu,qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ha,
                        //that was a joke, haha fat chance
                        //  R ,R ,A3,G4,Fs4,E4,E4,E4,Fs4,D4,E4,Fs4,A3, //4
                        qu,ei,ei,ei,ei ,ei,ei,qu,ei ,ei,qu,ei ,ei,
                        //anyway this cake is great , its so del
                        //  R ,E4,Fs4,G4,G4,E4,Cs4,D4,E4,E4,A3,D4,E4, //5
                        ha,ha,qu ,ei,ei,qu,qu ,qu,ei,ei,ei,ei,ei,ei,
                        //sheet3
                        //icious and moist look at me still talking when theres science to do when i
                        //  F4,E4,D4,C4,C4,A3,Bb3,C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,A3,Bb3, //sheet3 1
                        ei,ei,ei,ei,qu,ei,ei ,qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ei,ei ,
                        //look out there it makes me glad im not you. i've experiments to run there is
                        //  C4,F4,G4,F4,E4,D4,D4,E4,F4,F4,G4,A4,Bb4,Bb4,A4,A4,G4,F4,G4, //sheet3 2
                        qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,ei,ei,ei ,ei ,ei,ei,qu,ei,ei,
                        //research to be done on the people who are still alive
                        //  A4,A4,G4,F4,F4,D4,C4,D4,F4,F4,E4,E4,E4,Fs4,Fs4,Fs4,        //sheet3 3
                        ei,ei,ei,ei,qu,ei,ei,ei,ei,ei,ei,ei,ei,ei ,ei ,ha ,
                        //still alives repeted
                        ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,
                        ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,
                        ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,
                        ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,
                        ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,
                        //last few alives
                        qu,ei,ei,ei,ei,qu,qu,ei,ei,ei,ei,ha,ha

                    };
//this was a trimpuh im making a note here, huge succes
//     G4,Fs4,E4,E4,Fs4,R ,R ,R ,   A3,G4,Fs4,E4,E4,E4   ,Fs4,D4,E4,A3,R,
float aliveBeatLyrics[] = { -1,  ei,ei ,ei,ei,ha ,ha,qu,ei,-1,ei,ei, ei,ei,ei,qu+ei,qu ,ei,ei,ei,tq, //17
                            //its hard to overstate my satisfaction
                            //    A3,A3,E4,Fs4,G4,G4,Fs4,Cs4,Cs4,D4   ,E4,A3,A3,A3,Fs4  ,Fs4,
                            -1,ei,ei,qu,ei ,ei,qu,ei ,ei ,ei ,qu+ei,qu,ei,ei,ei,qu+ei,ha,//17
                            //aperture science we do what we must because we can
                            //    R ,G4,Fs4,E4,E4,Fs4,R ,R ,R ,   A3,G4,Fs4,E4,E4,E4,   G4,D4,D4,E4,A3,
                            -1,ha,ei,ei ,ei,ei,ha ,ha,qu,ei,-1,ei,ei,ei ,ei,ei,qu,-1,ei,ei,qu,ei,ei,//20
                            //for the good of all of us except the ones who are dead but theres
                            // R ,R ,   E4,Fs4,G4,G4,Fs4,Cs4,Cs4,   D4,E4,E4,A3,D4,E4,F4,E4,D4,C4,R ,   A3,Bb3,
                            ha,ha,-1,qu,ei ,ei,qu,ei ,ei ,qu ,-1,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,-1,ei, ei,
                            //no sense crying over every mistake you just keep on trying till you runout of cake and the
                            // C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,A3,Bb3,C4,F4,G4,F4,E4,D4,D4,D4,F4,F4,G4,A4,
                            qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,-1,ei,ei ,qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,-1,ei,ei,
                            //science gets done, and you make a neat gun for the people who are still alive.
                            //  Bb4,Bb4,A4,G4,F4,G4,A4,A4,G4,F4,E4,C4,D4,F4,F4,E4,E4,E4, Fs4,Fs4, R, R,   //A4,D5,Fs5,D5,B4,D5,Fs5,D5,
                            ei ,ei ,qu,qu,-1,ei,ei,ei,ei,qu,qu,-1,ei,ei,ei,ei,ei,ei,ei,ei ,ei ,ei ,ha,ha,-1,//ei,ei,ei,ei,ei,ei,ei,ei,FAKE BACKBEAT
                            // ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei, FAKE BACKBEAT
                            //R  R
                            //sheet2
                            //im not even angry
                            // R ,R ,   A3,G4,Fs4,E4,E4,E4,Fs4,Fs4,R, //1
                            qu,ei,-1,ei,ei,ei ,ei,ei,si,ei ,ei ,ha ,
                            //im being so sincere right now. even through you
                            //  R ,R ,   A3,G4,Fs4,E4,E4,E4,Fs4,D4,D4,E4,A3,A3, R,   E4,Fs4,G4,G4,Fs4, //2
                            qu,ei,-1,ei,ei,ei ,ei,ei,qu,ei ,ei,ei,qu,ei,ha,ha,-1,qu,ei,ei,qu,qu ,
                            //you broke my heart and killed me. and tore me to pieces
                            // Cs4,D4,E4,E4,A3,A3,A3,Fs4,Fs4,R,R,R,   A3,G4,Fs4,E4,E4,Fs4,R,R, //3
                            qu,ei,ei,qu,ei,-1,ei,ei,qu+ei,qu,qu,qu,ei,-1,ei,ei,ei,ei,ei,qu,qu,ha,
                            //and threw every puiece into a fire
                            //  R ,R ,   A3,G4,Fs4,E4,E4,E4,Fs4,D4,E4,Fs4,A3, //4
                            qu,ei,-1,ei,ei,ei ,ei,ei,qu,ei ,ei,qu,ei ,ei,
                            //as they burned it hurt because i was so
                            //  R ,   E4,Fs4,G4,G4,E4,Cs4,D4,E4,E4,A3,D4,E4, //5
                            ha,-1,ha,qu ,ei,ei,qu,qu ,-1,qu,ei,ei,ei,ei,ei,ei,
                            //sheet3
                            //happy for you, now these points of data make a beautiful line and we're
                            //  F4,E4,D4,C4,C4,   A3,Bb3,C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,   A3,Bb3, //sheet3 1
                            ei,ei,ei,ei,qu,-1,ei,ei ,qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,-1,ei,ei ,
                            //out of beta, we're releasing on time. so im GLaD i got burned. think of
                            //  C4,F4,G4,F4,   E4,D4,D4,E4,F4,F4,   G4,A4,Bb4,Bb4,A4,A4,G4,   F4,G4, //sheet3 2
                            qu,qu,ei,ei,-1,ei,ei,ei,ei,qu,qu,-1,ei,ei,ei ,ei ,ei,ei,qu,-1,ei,ei,
                            //all the things we learned for the people who are still alive.
                            //  A4,A4,G4,F4,F4,   D4,C4,D4,F4,F4,E4,E4,E4,Fs4,Fs4,Fs4, R, R, R,       //sheet3 3
                            ei,ei,ei,ei,qu,-1,ei,ei,ei,ei,ei,ei,ei,ei,ei ,ei ,ha ,-1,ha,ha,ha,
                            //repete for verse 3
                            //sheet2
                            //Go head and leave me
                            //  R ,R ,   A3,G4,Fs4,E4,E4,E4,Fs4,Fs4,R, //1
                            qu,ei,-1,ei,ei,ei ,ei,ei,si,ei ,ei ,ha ,-1,
                            //I think i prefer to stay inside. maybe you'll find
                            //  R ,R ,A3,G4,Fs4,E4,E4,E4,Fs4,D4,D4,E4,A3,A3, R,   E4,Fs4,G4,G4,Fs4, //2
                            qu,ei,ei,ei,ei ,ei,ei,qu,ei ,ei,ei,qu,ei,ha,ha,-1,qu,ei,ei,qu,qu ,
                            //someone else to help you. maybe black mesa
                            // Cs4,D4,E4,E4,A3,A3,A3,Fs4,Fs4,R,R,R,    A3,G4,Fs4,E4,E4,Fs4,R,R, //3
                            qu,ei,ei,qu,ei,ei,ei,qu+ei,qu,qu,qu,-1,ei,ei,ei,ei,ei,ei,qu,qu,ha,
                            //that was a joke, haha fat chance
                            //  R ,R ,   A3,G4,Fs4,E4,E4,E4,   Fs4,D4,E4,Fs4,A3, //4
                            qu,ei,-1,ei,ei,ei ,ei,ei,qu,-1,ei ,ei,qu,ei ,ei,-1,
                            //anyway this cake is great , its so del
                            //  R ,E4,Fs4,G4,G4,E4,Cs4,D4,E4,E4,A3,D4,E4, //5
                            ha,ha,qu ,ei,ei,qu,qu ,qu,ei,ei,ei,-1,ei,ei,ei,
                            //sheet3
                            //icious and moist look at me still talking when theres science to do when i
                            //  F4,E4,D4,C4,C4,   A3,Bb3,C4,F4,E4,D4,D4,C4,D4,C4,C4,C4,   A3,Bb3, //sheet3 1
                            ei,ei,ei,ei,qu,-1,ei,ei ,qu,qu,ei,-1,ei,ei,ei,ei,ei,qu,qu,-1,ei,ei ,
                            //look out there it makes me glad im not you. i've experiments to run there is
                            //  C4,F4,G4,F4,E4,D4,D4,E4,F4,F4,   G4,A4,Bb4,Bb4,A4,A4,G4,   F4,G4, //sheet3 2
                            qu,qu,ei,ei,ei,ei,ei,ei,qu,qu,-1,ei,ei,ei ,ei ,ei,ei,qu,-1,ei,ei,
                            //research to be done on the people who are still alive
                            //  A4,A4,G4,F4,F4,   D4,C4,D4,F4,F4,E4,E4,E4,Fs4,Fs4,Fs4,        //sheet3 3
                            ei,ei,ei,ei,qu,-1,ei,ei,ei,ei,ei,ei,ei,ei,ei ,ei ,ha ,
                            //still alives repeted
                            -1,ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,-1,
                            ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,-1,
                            ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,-1,
                            ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,-1,
                            ha,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,ei,-1,
                            //last few alives
                            qu,ei,ei,ei,ei,qu,qu,ei,ei,ei,ei,ha,ha

                          };


void playAlive()
{
    for (int i = 0; i <= sizeof(aliveNotes) / sizeof(aliveNotes[0]); i++) {
        freqLocal = aliveNotes[i];
        note = notes[freqLocal];
        speaker.period( 1 / (2 * note));
        speaker = .5;
        wait(aliveBeat[i]);
    }
    speaker = 0;
}
void sendAliveBackBeat()
{
    master.frequency(1000);
    for (int i = 0; i <= sizeof(aliveBackNotes) / sizeof(aliveBackNotes[0]); i++) {
        freqLocal = aliveBackNotes[i];
        master.start();
        master.write(addr);
        master.write(freqLocal);
        master.stop();
        note = notes[freqLocal];
        wait(aliveBackBeat[i]);
        //term.printf("Note num: %d\r\n", freq);
    }
    speaker = 0;
    master.start();
    master.write(addr);
    master.write(0xFF);
    master.stop();
}



int main()
{
    while (1) {
        if(left) {
            float topBeat=aliveBeatLyrics[1];
            float backBeat=aliveBackBeat[0];
            int j=0;
            int n=0;
            int lyricLine =-1;
            float modifier =0;
            master.frequency(1000);
            lcd.setmode(XOR);      
            for (int i = 0; n <= sizeof(aliveNotes) / sizeof(aliveNotes[0]); ) {
                modifier = pot1.read();
                modifier = modifier *4;
                //term.printf("pot1.read() = %f \r\n",modifier);
                if (aliveBeatLyrics[i]<0) {
                  //  term.printf("C0: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);
                    lcd.cls();
                    lyricLine++;
                    i++;
                    lcd.printf(lyrics[lyricLine]);
                    lcd.printf("\r \n \r \n \r\n");
                 //   term.printf("reprintingLines\r\n");
                  //  term.printf("C0: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);

                } else {
                    freqLocal = aliveNotes[n];
                    freqSend = aliveBackNotes[j];
                    master.start();
                    master.write(addr);
                    master.write(freqSend);
                    master.stop();
                    note = notes[freqLocal];
                    //term.printf("Note num: %d\r\n", freq);
                    speaker.period( 1 / (2 * note));
                    speaker = .5;
                    if(topBeat>backBeat) {
                        wait(backBeat*modifier);
                        topBeat=topBeat-backBeat;
                   //     term.printf("C1: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);
                        backBeat=aliveBackBeat[j];
                        j++;
                   //     term.printf("C1: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);
                    } else if(backBeat>topBeat) {

                        wait(topBeat*modifier);
                        backBeat=backBeat-topBeat;
                    //    term.printf("C2: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);
                        topBeat=aliveBeatLyrics[i];
                        i++;
                        n++;
                     //   term.printf("C2: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);

                    } else if(backBeat==topBeat) {
                        wait(topBeat*modifier);
                     //   term.printf("C3: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);
                        topBeat=aliveBeatLyrics[i];
                        backBeat=aliveBackBeat[j];
                        i++;
                        n++;
                        j++;
                     //   term.printf("C3: i = %d \r\n    n = %d \r\n    backBeat = %f \r\n    topBeat = %f \r\n",i,n,backBeat,topBeat);

                    }
                }
            }
            speaker = 0;
            master.start();
            master.write(addr);
            master.write(0xFF);
            master.stop();
        }
        if (up) {
            master.frequency(1000);
            for (int i = 0; i <= sizeof(aliveNotes) / sizeof(aliveNotes[0]); i++) {
                freqLocal = aliveNotes[i];
                master.start();
                master.write(addr);
                master.write(freqLocal);
                master.stop();
                note = notes[freqLocal];
                //term.printf("Note num: %d\r\n", freq);
                speaker.period( 1 / (2 * note));
                speaker = .5;
                wait(aliveBeat[i]);
            }
            speaker = 0;
            master.start();
            master.write(addr);
            master.write(0xFF);
            master.stop();
        }
        if (down) {
            master.start();
            master.write(addr | read);
            freqLocal = 0;
            int prev = -1;
            while (freqLocal != 0xFF) {
                freqLocal = master.read(addr);
            //    term.printf("Note Received: %d\n\r", freqLocal);
                if (freqLocal != prev) {
                    note = notes[freqLocal];
                    speaker.period(1 / (2 * note));
                    speaker = .5;
                }
                prev = freqLocal;
            }
            speaker = 0;
            master.stop();
        }
        if (center) {
            for (int i = 0; i <= sizeof(aliveNotes) / sizeof(aliveNotes[0]); i++) {
                freqLocal = aliveNotes[i];
                note = notes[freqLocal];
                speaker.period( 1 / (2 * note));
                speaker = .5;
                wait(aliveBeat[i]);
            }
            speaker = 0;
        }
    }
}
