#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);
Timeout ender;
Timer timer;
Serial term(USBTX, USBRX);
InterruptIn iFrackedUp(p14);

char sents[][65] = {"Jackdaws love my big sphinx of quartz. ",
                    "The quick brown fox jumped over the lazy dog. ",
                    "Cwm fjordbank glyphs vext quiz. ",
                    "Pack my box with five dozen liquor jugs. ",
                    "A quick movement of the enemy will jeopardize six gunboats. ",
                    "The five boxing wizards jump quickly. ",
                    "Crazy Fredericka bought many very exquisite opal jewels. ",
                    "Amazingly few discotheques provide jukeboxes. ",
                    "Sphinx of black quartz, judge my vow! ",
                    "Brawny gods just flocked up to quiz and vex him. "};

int wordsTyped;
int lettersTotal;
int lettersCorrect;
int reset = true;

void game() {
    lcd.cls();
    lcd.printf("WPM: %.2f\n", (float)wordsTyped);
    lcd.printf("Accuracy: %.2f%%\n", (float)(lettersCorrect)/lettersTotal*100);
    ender.detach();
}

void frack() {
    lcd.cls();
    float wpm = 60 * wordsTyped / timer.read();
    lcd.printf("WPM: %.2f\n", wpm);
    lcd.printf("Accuracy: %.2f%%\n", (float)(lettersCorrect)/lettersTotal*100);
}

int main() 
{
    timer.start();
    if (reset) {
        lettersTotal = 0;
        lettersCorrect = 0;
        wordsTyped = 1;
        ender.attach(&game, 60);
        iFrackedUp.rise(&frack);
        reset = false;
        timer.reset();
        char prev = ' '; 
        char let = ' '; 
        while (1)
        {
            for (int i = 0; i < sizeof(sents)/sizeof(*sents); i++) {
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("%s\n", sents[i]);
                for (int j = 0; j < sizeof(sents[i])/sizeof(*(sents[i])); j++) {
                    if (sents[i][j] == '\0')
                        break;
                    prev = let; 
                    let = term.getc();
//                    if (let == 0x08)
//                    {
//                        j -= 2; 
//                        if (j < 0) j = 0; 
//                    }
//                    else
                    {
                        lettersTotal++;
                        if (sents[i][j] == let)
                            lettersCorrect++;
                    }
                    if (' ' == let && ' ' != prev)
                        wordsTyped++;
                }
            }
        }
    }
}
