#include "mbed.h"
#include "music.h"

float song[];
float beat[];

I2CSlace i2c(p9, p10);
PwmOut spkr(p26);



int main() {
    i2c.address(0x42);
    while(1) 
    {
        int recv = i2c.receive();
        unsigned char note = i2c.read();
        switch(recv) {
            case I2CSlave::WriteAddressed:
                // receiving song from master
                if(note == 0xFF) spkr = 0;
                spkr.period(1/notes[note]);
                spkr = 0.5f;
                break;
            case I2CSlave::ReadAddressed: 
                // sending song to master 
                for(int i = 0; i < sizeof(...); i++)
                {
                    note = song[i];
                    i2c.write(note);
                    spkr = 0.5f;
                    spkr.period(1/notes[note]);
                    wait(beat[i]);   
                }
                spkr = 0;
                break;
        }
    }
}
