#include "mbed.h"
#include "MFRC522.h"

#define MF_RESET    D8  // pin du Nucleo branchée à la pin RST du RC522

const char bonUID[4] = {0x90, 0xCF, 0x94, 0x75};

MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);

DigitalOut led_1(D2);  // LED verte à la pin D2
DigitalOut led_2(D3);  // LED rouge à la pin D3

int main(void) {

  RfChip.PCD_Init();

  while (true) {
    
    int refus = 0;  // demeure nul si l'UID est bon
    
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      wait_ms(500);
      continue;
    }

    if ( ! RfChip.PICC_ReadCardSerial())
    {
      wait_ms(500);
      continue;
    }
         
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      if (RfChip.uid.uidByte[i] != bonUID[i]) {
          refus++;
        }
    }
    //printf("%d\n",refus);
    printf("%d%d%d%d\n",RfChip.uid.uidByte[0],RfChip.uid.uidByte[1],RfChip.uid.uidByte[2],RfChip.uid.uidByte[3]);
    /*printf("%d%d%d%d\n",bonUID[0],bonUID[1],bonUID[2],bonUID[3]);
    printf("%d\n",RfChip.uid.size);*/
    if (refus == 4) // UID accepté
    {
        printf("DATA1 OK \n");
        printf("Temp = %d \n",RfChip.uid.uidByte[0]);
        printf("Hum = %d \n",RfChip.uid.uidByte[1]);
        printf("Lux = %d \n",RfChip.uid.uidByte[2]);
        printf("water = %d \n",RfChip.uid.uidByte[3]);
        // on allume la LED verte pendant quelques secondes
    led_1 = 1; // On allume la LED 1
    wait_ms(5000);
    led_1 = 0; // On éteint la LED 1
    }
    else  {  // UID refusé
        // on allume la LED rouge pendant quelques secondes
        printf("DATA Error\n");
    led_2 = 1;
    wait_ms(5000);
    led_2 = 0;
    }     
  }
}