#include "mbed.h"
#include "ColorMbed.h"

SPI dot_matrix(D11,NC,D13); //mosi miso sclk
DigitalOut lat(PA_12);
DigitalOut sb(PA_11);
DigitalOut rst(PB_12);
BusOut open_line(D2,D3,D4,D5,D6,D7,D8,D9);
              //c0 c1 c2 c3 c4 c5 c6 c7 dont foget d7
uint8_t temp;
uint8_t position[8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
int line[8] = {1,2,4,8,16,32,64,128};

void ColorMbed::init(){
  dot_matrix.frequency(1000000);
  uint8_t wb[3] = {255,255,255};
  rst = 1;
  wait(0.5);
  rst = 0;
  wait(0.5);
  rst = 1;
  wait(0.5);
  sb = 0; // 6 bit
  for(int i = 0; i<8; i++){
    dot_matrix.write(wb[0]);
    dot_matrix.write(wb[1]);
    dot_matrix.write(wb[2]);
  }
  open_line = 0;
  sb = 1; // 8 bit
}

// *********************** configur later *********************************
void ColorMbed::display_dot(int row,int col ,uint8_t *color){
  //for(int j = 0; j<8;j++){
    temp = position[col];
    for(int i = 0 ; i< 8 ; i++){
      if(temp & 0x80){
        dot_matrix.write(color[0]);
        dot_matrix.write(color[1]);
        dot_matrix.write(color[2]);
      }
      else{
        dot_matrix.write(0);
        dot_matrix.write(0);
        dot_matrix.write(0);
      }
      temp = temp << 1;
    }
    lat = 1;
    lat = 0;
    open_line = line[row];
 
    open_line = 0;
    
  //}
}

// void ColorMbed::display_ship(int row,int column,int type,uint8_t *color){
//   if(type == 1){
//
//   }
//   else if(type == 2){
//
//   }
// }

void ColorMbed::display_pic(uint8_t *pic,uint8_t *color){
  for(int j = 0;j<8;j++){
    temp = pic[j];
    for(int i = 0; i<8; i++){
      if(temp & 0x80){
        dot_matrix.write(color[0]);
        dot_matrix.write(color[1]);
        dot_matrix.write(color[2]);
      }
      else{
        dot_matrix.write(0);
        dot_matrix.write(0);
        dot_matrix.write(0);
      }
      temp = temp << 1;
    }
    lat = 1;
    lat = 0;
    open_line = line[j];
    wait(0.001);
    open_line = 0;
  }
}

// *********************** private function *********************************


int ColorMbed::_power(int number , int power){
  int i = 0;
  int number1 = number;
  if(power == 0){return 1;}
  for(i = 1 ; i <= power ; i++ ){
    if(power == 1){return number;}
    if(i == 1){number = number * 1;}
    else{number1 = number1 * number;}
  }
return number1;
}
