/*******************************************************************************************
 *
 * University of York Robot Lab Pi Swarm Library: 433MHz Alpha Transceiver Driver
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 *
 * Version 0.6  February 2014
 *
 * Designed for use with the Pi Swarm Board (enhanced MBED sensor board) v1.2
 *
 ******************************************************************************************/

#ifndef ALPHA433_H
#define ALPHA433_H


//
// Defines
//
#define ALPHA433_FREQUENCY_315     0x0000
#define ALPHA433_FREQUENCY_433     0x0010
#define ALPHA433_FREQUENCY_868     0x0020
#define ALPHA433_FREQUENCY_915     0x0030
#define ALPHA433_CRYSTAL_LOAD_85   0x0000
#define ALPHA433_CRYSTAL_LOAD_90   0x0001
#define ALPHA433_CRYSTAL_LOAD_95   0x0002
#define ALPHA433_CRYSTAL_LOAD_100  0x0003
#define ALPHA433_CRYSTAL_LOAD_105  0x0004
#define ALPHA433_CRYSTAL_LOAD_110  0x0005
#define ALPHA433_CRYSTAL_LOAD_115  0x0006
#define ALPHA433_CRYSTAL_LOAD_120  0x0007
#define ALPHA433_CRYSTAL_LOAD_125  0x0008
#define ALPHA433_CRYSTAL_LOAD_130  0x0009
#define ALPHA433_CRYSTAL_LOAD_135  0x000A
#define ALPHA433_CRYSTAL_LOAD_140  0x000B
#define ALPHA433_CRYSTAL_LOAD_145  0x000C
#define ALPHA433_CRYSTAL_LOAD_150  0x000D
#define ALPHA433_CRYSTAL_LOAD_155  0x000E
#define ALPHA433_CRYSTAL_LOAD_160  0x000F
#define ALPHA433_USE_FIFO_YES      0x00C0
#define ALPHA433_USE_FIFO_NO       0x0000
#define ALPHA433_PIN20_INTERRUPT_IN    0x0000
#define ALPHA433_PIN20_VDI_OUT         0x0400
#define ALPHA433_VDI_RESPONSE_FAST     0x0000
#define ALPHA433_VDI_RESPONSE_MEDIUM   0x0100
#define ALPHA433_VDI_RESPONSE_SLOW     0x0200
#define ALPHA433_VDI_RESPONSE_ALWAYS   0x0300
#define ALPHA433_BANDWIDTH_400         0x0020
#define ALPHA433_BANDWIDTH_340         0x0040
#define ALPHA433_BANDWIDTH_270         0x0060
#define ALPHA433_BANDWIDTH_200         0x0080
#define ALPHA433_BANDWIDTH_134         0x00A0
#define ALPHA433_BANDWIDTH_67          0x00C0
#define ALPHA433_LNA_GAIN_0            0x0000
#define ALPHA433_LNA_GAIN_6            0x0080
#define ALPHA433_LNA_GAIN_14           0x0100
#define ALPHA433_LNA_GAIN_20           0x0180
#define ALPHA433_RSSI_103              0x0000
#define ALPHA433_RSSI_97               0x0001
#define ALPHA433_RSSI_91               0x0002
#define ALPHA433_RSSI_85               0x0003
#define ALPHA433_RSSI_79               0x0004
#define ALPHA433_RSSI_73               0x0005
#define ALPHA433_RSSI_67               0x0006
#define ALPHA433_RSSI_61               0x0007
#define ALPHA433_CLOCK_RECOVERY_AUTO   0x0080
#define ALPHA433_CLOCK_RECOVERY_FAST   0x0040
#define ALPHA433_CLOCK_RECOVERY_SLOW   0x0000
#define ALPHA433_FILTER_DIGITAL        0x0000
#define ALPHA433_FILTER_ANALOG         0x0010
#define ALPHA433_DQD_0                 0x0000
#define ALPHA433_DQD_1                 0x0001
#define ALPHA433_DQD_2                 0x0002
#define ALPHA433_DQD_3                 0x0003
#define ALPHA433_DQD_4                 0x0004
#define ALPHA433_DQD_5                 0x0005
#define ALPHA433_DQD_6                 0x0006
#define ALPHA433_DQD_7                 0x0007
#define ALPHA433_FIFO_LEVEL_0          0x0000
#define ALPHA433_FIFO_LEVEL_1          0x0010
#define ALPHA433_FIFO_LEVEL_2          0x0020
#define ALPHA433_FIFO_LEVEL_3          0x0030
#define ALPHA433_FIFO_LEVEL_4          0x0040
#define ALPHA433_FIFO_LEVEL_5          0x0050
#define ALPHA433_FIFO_LEVEL_6          0x0060
#define ALPHA433_FIFO_LEVEL_7          0x0070
#define ALPHA433_FIFO_LEVEL_8          0x0080
#define ALPHA433_FIFO_LEVEL_9          0x0090
#define ALPHA433_FIFO_LEVEL_10         0x00A0
#define ALPHA433_FIFO_LEVEL_11         0x00B0
#define ALPHA433_FIFO_LEVEL_12         0x00C0
#define ALPHA433_FIFO_LEVEL_13         0x00D0
#define ALPHA433_FIFO_LEVEL_14         0x00E0
#define ALPHA433_FIFO_LEVEL_15         0x00F0
#define ALPHA433_FIFO_FILL_PATTERN     0x0000
#define ALPHA433_FIFO_FILL_ALWAYS      0x0004
#define ALPHA433_HI_SENS_RESET_ENABLE  0x0000
#define ALPHA433_HI_SENS_RESET_DISABLE 0x0001
#define ALPHA433_AFC_MODE_NOAUTO       0x0000
#define ALPHA433_AFC_MODE_ONCE         0x0040
#define ALPHA433_AFC_MODE_VDI          0x0080
#define ALPHA433_AFC_MODE_INDEPENDENT  0x00C0
#define ALPHA433_AFC_RANGE_3TO4        0x0030
#define ALPHA433_AFC_RANGE_7TO8        0x0020
#define ALPHA433_AFC_RANGE_15TO16      0x0010
#define ALPHA433_AFC_RANGE_NO_RES      0x0000
#define ALPHA433_AFC_FINE_ENABLE       0x0004
#define ALPHA433_AFC_FINE_DISABLE      0x0000
#define ALPHA433_AFC_ENABLE            0x0003
#define ALPHA433_AFC_DISABLE           0x0000
#define ALPHA433_MOD_POLARITY_P        0x0000
#define ALPHA433_MOD_POLARITY_N        0x0100
#define ALPHA433_MOD_FREQUENCY_15       0x0000
#define ALPHA433_MOD_FREQUENCY_30       0x0010
#define ALPHA433_MOD_FREQUENCY_45       0x0020
#define ALPHA433_MOD_FREQUENCY_60       0x0030
#define ALPHA433_MOD_FREQUENCY_75       0x0040
#define ALPHA433_MOD_FREQUENCY_90       0x0050
#define ALPHA433_MOD_FREQUENCY_105      0x0060
#define ALPHA433_MOD_FREQUENCY_120      0x0070
#define ALPHA433_MOD_FREQUENCY_135      0x0080
#define ALPHA433_MOD_FREQUENCY_150      0x0090
#define ALPHA433_MOD_FREQUENCY_165      0x00A0
#define ALPHA433_MOD_FREQUENCY_180      0x00B0
#define ALPHA433_MOD_FREQUENCY_195      0x00C0
#define ALPHA433_MOD_FREQUENCY_210      0x00D0
#define ALPHA433_MOD_FREQUENCY_225      0x00E0
#define ALPHA433_MOD_FREQUENCY_240      0x00F0
#define ALPHA433_TX_POWER_0            0x0000
#define ALPHA433_TX_POWER_3            0x0001
#define ALPHA433_TX_POWER_6            0x0002
#define ALPHA433_TX_POWER_9            0x0003
#define ALPHA433_TX_POWER_12           0x0004
#define ALPHA433_TX_POWER_15           0x0005
#define ALPHA433_TX_POWER_18           0x0006
#define ALPHA433_TX_POWER_21           0x0007
#define ALPHA433_CLK_OUT_1             0x0000
#define ALPHA433_CLK_OUT_125           0x0020
#define ALPHA433_CLK_OUT_166           0x0040
#define ALPHA433_CLK_OUT_2             0x0060
#define ALPHA433_CLK_OUT_25            0x0080
#define ALPHA433_CLK_OUT_333           0x00A0
#define ALPHA433_CLK_OUT_5             0x00C0
#define ALPHA433_CLK_OUT_10            0x00E0
#define ALPHA433_LOW_BAT22             0x0000
#define ALPHA433_STATUS_TX_NEXT_BYTE           0x8000
#define ALPHA433_STATUS_FIFO_LIMIT_REACHED     0x8000
#define ALPHA433_STATUS_POWER_ON_RESET         0x4000
#define ALPHA433_STATUS_RX_OVERFLOW            0x2000
#define ALPHA433_STATUS_TX_UNDERRUN            0x2000
#define ALPHA433_STATUS_WAKEUP                 0x1000
#define ALPHA433_STATUS_EXT                    0x0800
#define ALPHA433_STATUS_LOW_BATTERY            0x0400
#define ALPHA433_STATUS_FIFO_EMPTY             0x0200
#define ALPHA433_STATUS_STRONG_SIGNAL          0x0100
#define ALPHA433_STATUS_RSSI                   0x0100
#define ALPHA433_STATUS_DQD                    0x0080
#define ALPHA433_STATUS_CLOCK_LOCKED           0x0040
#define ALPHA433_TRANSMIT_OK                   0
#define ALPHA433_TRANSMIT_TIMEOUT              1
#define ALPHA433_TRANSMIT_PARITY_ERROR         2
#define ALPHA433_RECEIVE_OK                    0
#define ALPHA433_RECEIVE_TIMEOUT               1
#define ALPHA433_RECEIVE_PARITY_ERROR          2
#define ALPHA433_NODATA            0
#define ALPHA433_DATA_AVAIABLE     1
#define ALPHA433_MODE_TRANSMITTING         1
#define ALPHA433_MODE_RECEIVING            2
#define ALPHA433_MODE_SWITCHING            0

// ----------------------------- default user configuration --------------------------------

#define ALPHA433_FREQUENCY         ALPHA433_FREQUENCY_433
#define ALPHA433_CRYSTAL_LOAD      ALPHA433_CRYSTAL_LOAD_100
#define ALPHA433_USE_FIFO          ALPHA433_USE_FIFO_YES
#define ALPHA433_PIN20             ALPHA433_PIN20_INTERRUPT_IN
#define ALPHA433_VDI_RESPONSE      ALPHA433_VDI_RESPONSE_SLOW
#define ALPHA433_BANDWIDTH         ALPHA433_BANDWIDTH_134
#define ALPHA433_LNA_GAIN          ALPHA433_LNA_GAIN_0
#define ALPHA433_RSSI              ALPHA433_RSSI_97
#define ALPHA433_CLOCK_RECOVERY    ALPHA433_CLOCK_RECOVERY_SLOW
#define ALPHA433_FILTER            ALPHA433_FILTER_DIGITAL
#define ALPHA433_DQD               ALPHA433_DQD_4
#define ALPHA433_FIFO_LEVEL        ALPHA433_FIFO_LEVEL_8
#define ALPHA433_FIFO_FILL         ALPHA433_FIFO_FILL_PATTERN
#define ALPHA433_HI_SENS_RESET     ALPHA433_HI_SENS_RESET_DISABLE
#define ALPHA433_AFC_MODE          ALPHA433_AFC_MODE_INDEPENDENT
#define ALPHA433_AFC_RANGE         ALPHA433_AFC_RANGE_3TO4
#define ALPHA433_AFC_FINE_MODE     ALPHA433_AFC_FINE_DISABLE
#define ALPHA433_AFC               ALPHA433_AFC_DISABLE
#define ALPHA433_MOD_POLARITY      ALPHA433_MOD_POLARITY_P
#define ALPHA433_MOD_FREQUENCY     ALPHA433_MOD_FREQUENCY_90
#define ALPHA433_TX_POWER          ALPHA433_TX_POWER_0
#define ALPHA433_CLK_OUT           ALPHA433_CLK_OUT_2
#define ALPHA433_LOW_BAT           ALPHA433_LOW_BAT22
#define ALPHA433_TIMEOUT   100
#define TIMEOUT 8.0

class Alpha433 : public Stream
{

// Public Functions

public:

    /** Create the alpha433 object connected to the default pins
      *
      * @param mosi pin - default is p5
      * @param miso pin - default is p6
      * @param sck pin - default is p7
      * @param fss pin - default is p8
      * @param nirq pin - default is p11
      */
    Alpha433();

    /** Create the alpha433 object connected to specific pins
     *
     */
    Alpha433(PinName mosi, PinName miso, PinName sck, PinName fss, PinName nirq);


// Send a string to the RF transmitter
    unsigned long sendString(char ucCount, char* ucBuffer);

// Enable RF Transmitter
    void enableTransmitter(void);

// Disable RF Transmitter
    void disableTransmitter(void);

// Enable RF Receiver
    void enableReceiver(void);

// Disable RF Receiver
    void disableReceiver(void);

// SSI FiFo Clear
    void clearBuffer(void);

// Reset RF
    void rf_reset(void);

// Initialise RF
    void rf_init(void);

// RF Interrupt
    void interrupt(void);

// RF Set Datarate
    void setDatarate(unsigned long ulValue);

// RF Set Frequency
    void setFrequency(unsigned long ulValue);

// Enable RF Receiver FiFo fill
    void enableFifoFill(void);

// Disable RF Receiver FiFo fill
    void disableFifoFill(void);

// Handle new RF Data
    void dataAvailable(char cCount, char* cBuffer);

// Read status byte
    int readStatusByte();

// Reset timeout: stops hanging on bad receive; resets alpha 433
    void timeout();

private :

    SPI _spi;
    DigitalOut _fss;
    DigitalIn _nirq_test;
    InterruptIn _nirq;

    //Write a byte (data) to address
    void _write(int address);

    //Read a byte (return val) from address
    int _read(int address);

    virtual int _putc(int c);
    virtual int _getc();

};


// These counters are used to monitor the RF transceiver operations
extern volatile int gi_RF_messages_sent;
extern volatile int gi_RF_messages_received;
extern volatile int gi_RF_bytes_sent;
extern volatile int gi_RF_bytes_received;
extern volatile int gi_RF_reset_cycles;
extern volatile int gi_RF_received_length_error;
extern volatile int gi_RF_received_checksum_failure;
extern volatile int gi_RF_received_invalid_sender;
extern volatile int gi_RF_received_invalid_target;
extern volatile int gi_RF_received_invalid_format;
extern volatile int gi_RF_received_not_for_me;
extern volatile int gi_RF_received_broadcast;
extern volatile int gi_RF_received_targeted_to_me;
extern volatile int gi_RF_received_unexpected_response;
extern volatile int gi_RF_received_invalid_response;
extern volatile int gi_RF_commands_actioned;
extern volatile int gi_RF_commands_invalid;
extern volatile int gi_RF_commands_blocked;
extern volatile int gi_RF_requests_actioned;
extern volatile int gi_RF_commands_sent;
extern volatile int gi_RF_responses_sent;

#endif // ALPHA433_H