/*******************************************************************************************
 *
 * University of York Robot Lab Pi Swarm Library: Swarm Communications Handler
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 *
 * Version 0.5  February 2014
 *
 * Designed for use with the Pi Swarm Board (enhanced MBED sensor board) v1.2
 *
 ******************************************************************************************/

#ifndef COMMUNICATIONS_H
#define COMMUNICATIONS_H

// The swarm_member struct is used by the communication stack to store the status and results for RF commands and requests
// that have been sent.  An array of [SWARM_SIZE] swarm_members is created.  This contains a status flag for all of the 
// standard requests and commands and a set of variables for data which can be collected.  
//
// The status flags are set to the following values:
// 0 : "unused"  - before any requests are sent
// 1 : "waiting" - a request or command has been sent and the result is not yet known
// 2 : "received" - a valid response to a request or command has been received
// 3 : "invalid" - an invalid response to a request or command has been received 
struct swarm_member {
    char status_rf_request_null;
    char status_rf_request_left_motor_speed;
    char status_rf_request_right_motor_speed;
    char status_rf_request_button_state;
    char status_rf_request_led_colour;
    char status_rf_request_led_states;
    char status_rf_request_battery;
    char status_rf_request_light_sensor;
    char status_rf_request_accelerometer;
    char status_rf_request_gyroscope;
    char status_rf_request_background_ir;
    char status_rf_request_reflected_ir;
    char status_rf_request_distance_ir;
    char status_rf_request_line_following_ir;
    char status_rf_request_uptime;
    char status_rf_command_stop;
    char status_rf_command_forward;
    char status_rf_command_backward;
    char status_rf_command_left;
    char status_rf_command_right;
    char status_rf_command_left_motor;
    char status_rf_command_right_motor;
    char status_rf_command_oled_colour;
    char status_rf_command_cled_colour;
    char status_rf_command_oled_state;
    char status_rf_command_cled_state;
    char status_rf_command_set_oled;
    char status_rf_command_play_tune;
    char status_rf_command_sync_time;
    float left_motor_speed;
    float right_motor_speed;
    char button_state;
    char outer_led_colour [3];
    char center_led_colour [3];
    char led_states[2];
    float battery;
    float light_sensor;
    float accelerometer[3];
    float gyro;
    unsigned short background_ir[8];
    unsigned short reflected_ir[8];
    float distance_ir[8];
};

void send_rf_message(char target, char command, char * data, char length);
void setup_communications(void);
void decodeMessage(char sender, char target, char id, char command, char * data, char length);
void send_response(char target, char is_broadcast, char success, char id, char is_command, char function, char * data, char length);
void tdma_response();
void handle_command(char sender, char is_broadcast, char request_response, char id, char function, char * data, char length);
void handle_request(char sender, char is_broadcast, char request_response, char id, char function);
void processRadioData(char * data, char length);
void errormessage(int index);
void handle_response(char sender, char is_broadcast, char success, char id, char is_command, char function, char * data, char length);

void send_rf_request_null ( char target );
void send_rf_request_left_motor_speed ( char target );
void send_rf_request_right_motor_speed ( char target );
void send_rf_request_button_state ( char target );
void send_rf_request_led_colour ( char target );
void send_rf_request_led_states ( char target );
void send_rf_request_battery ( char target );
void send_rf_request_light_sensor ( char target );
void send_rf_request_accelerometer ( char target );
void send_rf_request_gyroscope ( char target );
void send_rf_request_background_ir ( char target );
void send_rf_request_reflected_ir ( char target );
void send_rf_request_distance_ir ( char target );
void send_rf_request_line_following_ir ( char target );
void send_rf_request_uptime ( char target );
void send_rf_command_stop ( char target, char request_response );
void send_rf_command_forward ( char target, char request_response, float speed );
void send_rf_command_backward ( char target, char request_response, float speed );
void send_rf_command_left ( char target, char request_response, float speed );
void send_rf_command_right ( char target, char request_response, float speed );
void send_rf_command_left_motor ( char target, char request_response, float speed );
void send_rf_command_right_motor ( char target, char request_response, float speed );
void send_rf_command_oled_colour ( char target, char request_response, char red, char green, char blue );
void send_rf_command_cled_colour ( char target, char request_response, char red, char green, char blue );
void send_rf_command_oled_state ( char target, char request_response, char led0, char led1, char led2, char led3, char led4, char led5, char led6, char led7, char led8, char led9 );
void send_rf_command_cled_state ( char target, char request_response, char enable );
void send_rf_command_set_oled ( char target, char request_response, char oled, char enable );
void send_rf_command_play_tune ( char target, char request_response, char * data, char length );
void send_rf_command_sync_time ( char target, char request_response );


const char * const requests_array[] = { "Req.Ack", "Req.LM", "Req.RM", "Req.But","Req.LEDCol","Req.LED","Req.Lgt","Req.Acc","Req.Gyro","Req.BIR","Req.RIR","Req.DIR","Req.LFS","Req.UpT","Req.???","Req.???"};
const char * const commands_array[] = { "Cm.Stop","Cm.Fward","Cm.Bward","Cm.Left","Cm.Right","Cm.LMot","Cm.RMot","Cm.OLEDC","Cm.CLEDC","Cm.OLEDS","Cm.CLEDS","Cm.SetLED","Cm.Play","Cm.Sync","Cm.???","Cm.???"};

#endif //COMMUNICATIONS_H