/* University of York Robotics Laboratory MBED Library: Display Driver
 * 
 * File: display.cpp
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 * 
 * October 2013
 *
 * Driver for the Midas 20x4 I2C LCD Display (MCCOG42005A6W-BNMLWI) LCD
 *
 * Farnell part 2218946 
 *
 */ 
 
#include "mbed.h"
#include "display.h"

Display::Display(PinName sda, PinName scl, PinName reset) :  Stream("display"), _i2c(sda,scl), _reset(reset)  {
  
}

Display::Display() :  Stream("display"), _i2c(p9,p10), _reset(p12)  {
  
}

int Display::i2c_message(char byte){
   char bytes [2];
   bytes[0]=0x80;
   bytes[1]=byte;
   return _i2c.write(LCD_ADDRESS,bytes,2);  
}

int Display::disp_putc(int c){
   char message [2];
   message[0]=0x40;
   message[1]=c;
   _i2c.write(LCD_ADDRESS,message,2);
   return c;
}



void Display::init_display(){
   //Set initial states: display on, cursor off
   display_on = 1;
   cursor_on = 1;
   blink_on  = 1;
    
   _reset=1;
   wait(0.02);
   //Set reset low
   _reset=0;
   wait(0.001);
   _reset=1;
   wait(0.03);
   i2c_message(0x3a); 
   i2c_message(0x1e); 
   i2c_message(0x39); 
   i2c_message(0x1c); 
   i2c_message(0x79); 
   i2c_message(0x5d); 
   i2c_message(0x6d); 
   _set_display();
   clear_display(); 
} 

void Display::write_string(char * message, char length){
   char to_send [length+1];
   to_send[0]=0x40;
   for(int i=0;i<length;i++){
     to_send[i+1] = message[i];
   }
   _i2c.write(LCD_ADDRESS,to_send,length+1);
}

void Display::set_position(char row, char column){
  if(row < 4 && column < 20){
    char pos = 128 +((row * 32)+column);
    i2c_message(pos);
  }
}

void Display::set_cursor(char enable){
  cursor_on=enable;
  _set_display();
}

void Display::set_blink(char enable){
  blink_on=enable;
    _set_display();
}

void Display::set_display(char enable){
  display_on=enable;
    _set_display();
}

void Display::clear_display(){
  i2c_message(0x01);
}

void Display::home(){
  i2c_message(0x02);
}


void Display::_set_display(){
    char mode = 8;
    if(display_on>0) mode += 4;
    if(cursor_on>0) mode += 2;
    if(blink_on>0) mode ++;
    i2c_message(mode);
}


int Display::_putc (int c) {
    disp_putc(c);
    return(c);
}

int Display::_getc (void) {
    char r = 0;
    return(r);
}
 
 
/* Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */