#include "mbed.h"
#include "VL53L0X.h"
#include "DetectHumanClass.h"

DetectHumanClass::DetectHumanClass(PinName pir_a,
                                   PinName pir_b,
                                   I2C* i2c,
                                   Timer* timer,
                                   PinName tx,
                                   PinName rx)
    : pir_a_pin_(pir_a),
      pir_b_pin_(pir_b),
      i2c(i2c),
      timer(timer),
      tof_(i2c,timer),
      pc(tx,rx)
{
    detect_sensor_state_ = POWER_ON;
}

bool DetectHumanClass::SettingSensor()
{
    pir_a_pin_.mode(PullDown);//setting pir snsr
    pir_b_pin_.mode(PullDown);//setting pir snsr

    tof_.init();//setting tof snsr
    tof_.setTimeout(500);//setting tof snsr
    tof_.setSignalRateLimit(0.1);//setting tof snsr
    tof_.setVcselPulsePeriod(VL53L0X::VcselPeriodPreRange,18);//setting tof snsr
    tof_.setVcselPulsePeriod(VL53L0X::VcselPeriodFinalRange,14);//setting tof snsr

    detect_sensor_state_ = SETTING_COMPLETE;//change the detect_state

    return true;
}


bool DetectHumanClass::CalibrateSensor()//checking the initial tof snsr value for zero setting
{
    calibrationed_distance = tof_.readRangeSingleMillimeters();
    printf("calibrationed_distance %u\n\r",calibrationed_distance);
    if(calibrationed_distance > 8000) {
        detect_sensor_state_ = TOF_CALIBRATION_FIN;
        printf("*******calibration finished*******\n\r");
        printf("*******no wall state*******\n\r",calibrationed_distance);
        calibrationed_distance = 8000;
        return true;
    }
    if(calibrationed_distance < MAX_TOF_THRESHOLD && calibrationed_distance > MIN_TOF_THRESHOLD) {
        detect_sensor_state_ = TOF_CALIBRATION_FIN; //change the detect_state
        printf("*******calibration finished*******\n\r");
        printf("*******calibrationed_value %u*******\n\r",calibrationed_distance);
        //*** make reaction for if success to calibration" ***//

        return true;
    } else {
        printf("calibation fail\n\r");
        //*** make reaction for if fail to calibration" ***//

    }
    wait(2);// add for testing
}


bool DetectHumanClass::DetectPIRState()
{

    bool a = pir_a_pin_.read();
    bool b = pir_b_pin_.read();

    if(a||b) {
        printf("PiR snsr is detected \n\r");
        detect_sensor_state_ = PIR_DETECTED;//change the detect_state
        wait(2);
        return true;
    } else {
        detect_sensor_state_ = TOF_CALIBRATION_FIN;
    }

    printf("PiR snsr is low, device checking heat source\n\r");
    wait(2); // add for testing
}

bool DetectHumanClass::DetectTOFState()
{
    uint16_t distance = tof_.readRangeSingleMillimeters();
    printf("distance %u\n\r",distance);
    //algoritm
    if((distance < calibrationed_distance*0.9) && (distance > MIN_TOF_THRESHOLD)) {
        detect_sensor_state_ = TOF_DETECTED;//change the detect_state
        printf("*******TOF detected*******\n\r");
        printf("*******detected Value = %u*******\n\n\n\r",distance);
        return true;
    } else {
        detect_sensor_state_ = TOF_CALIBRATION_FIN;//change the detect_state
        printf("TOF non detected \n\n\n\r");
        return false;
    }
    wait(2);// for adding test
}

int DetectHumanClass::get_detect_state_()
{
    return detect_sensor_state_;
}

int DetectHumanClass::init() 
{
    detect_sensor_state_ = TOF_CALIBRATION_FIN;
}
        