/* NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
#include <stdio.h>
#include <stdlib.h>
#include "mbed.h"
#include "detect.h"
#include "info.h"
#include "tts.h"
#include "push.h"
#include "setting.h"
#include "ShiftRegisterControlClass.h"

#define TEST_MODE 0
#define DEMO_MODE 1

#define MODE TEST_MODE

WizFi310Interface wifiInterface(D1, D0, D7, D6, D8, NC, 115200);
ShiftRegisterControlClass m_register(PC_10, PC_11, PC_12);
VS1053 *player = new VS1053(PA_08, PA_07, PA_06, PA_00, PA_05, PA_01, PA_02); // mosi, miso, sck, cs, bsync, dreq, rst

int main()
{
    //Start Goout
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    
    m_register.BlinkLed();
    m_register.TurnOnLed(m_register.kPowerLedByte);
    
    //Wifi AP Mode Start
    wifiInterface.connectAP(AP_SSID, AP_PASSWORD, AP_SECURITY);
    
    char buf[MAX_BUF_SIZE] = "";
    char id[MAX_ID_SIZE] = "";
    char pwd[MAX_PWD_SIZE] = "";

    //Wifi AP Mode Server Start
    TCPServer srv;
    TCPSocket clt_sock;
    
    //Wifi AP Mode Server init
    srv.open(&wifiInterface);
    srv.set_blocking(true);
    srv.bind(8080);
    srv.listen();
    srv.accept(&clt_sock);

    //Wifi AP Mode Server recv Wifi config info
    while (true)
    {
        int n = clt_sock.recv(buf, MAX_BUF_SIZE);
        if( n < 0 )
        {
            clt_sock.close();
            srv.close();
        }
        if( n > 0 )
        {
            buf[n] = '\0';
            clt_sock.send(buf, n);
            break;
        }
    }
    
    //Wifi AP Mode Server response Wifi config info
    sendMacResponse(wifiInterface, clt_sock);
    processWiFiJson(buf, pwd, id);
    
    //free wifi AP Server
    clt_sock.close();
    srv.close();
    
#if MODE == DEMO_MODE
    //Decoder Init
    //VS1053 *player = new VS1053(PA_08, PA_07, PA_06, PA_00, PA_05, PA_01, PA_02); // mosi, miso, sck, cs, bsync, dreq, rst
    player->hardwareReset(); //Make a reset to the VS1053 board
    player->modeSwitch();    //Patch the VS1054 board to play MP3 files (very important!).
#endif
    
    //Wifi Station(Client) Mode start
    wifiInterface.connect(buf, pwd, STA_SECURITY);
    m_register.TurnOnLed(m_register.kWifiLedByte);
    TCPSocket *socket = new TCPSocket(&wifiInterface);
    
#if MODE == DEMO_MODE
    //detecting start
    detecting(player, socket, buf, id, m_register);
#endif

#if MODE == TEST_MODE
    //recv tts text
    recvInfo(socket, buf, id, m_register);
    //recv tts data and play
    playTTS(socket, buf); 
    //recv android app push notification
    requestNoti(socket, id, buf);
#endif
    
    //free wifi
    socket->close();
    wifiInterface.disconnect();

#if MODE == DEMO_MODE
    //free decoder
    player->sendCancel();
    player->stop();
#endif
    
    printf("D\n");
    delete socket;
    
    m_register.BlackOutLed();
}
