#include "detect.h"
#include "info.h"
#include "tts.h"
#include "push.h"


I2C m_i2c(PA_10 , PA_09);
Timer m_timer;

DetectHumanClass detect(PC_15,
                         PC_14,
                         &m_i2c,
                         &m_timer,
                         USBTX,
                         USBRX);

void detecting(VS1053 *player, TCPSocket *socket, char* buf, char* id, ShiftRegisterControlClass led) 
{   
    while(1) {
        while(1) {
            int sensor_state = detect.get_detect_state_();
            if(sensor_state == detect.POWER_ON) {
                detect.SettingSensor();
            } else if(sensor_state == detect.SETTING_COMPLETE) {
                detect.CalibrateSensor();
            } else if(sensor_state == detect.TOF_CALIBRATION_FIN) {
                detect.DetectPIRState();
            } else if(sensor_state == detect.PIR_DETECTED) {
                detect.DetectTOFState();
            } else if(sensor_state == detect.TOF_DETECTED) {
                break;
            }
        }
        detect.init();
        printf("detect!\n");
        
        recvInfo(socket, buf, id, led);
        playTTS(player, socket, buf); 
        requestNoti(socket, id, buf);
    }
}