#ifndef DETECTHUMANCLASS_H
#define DETECTHUMANCLASS_H

#include "mbed.h"
#include "VL53L0X.h"


class DetectHumanClass
{
public:
    enum SensorState {
        POWER_ON = 0,
        SETTING_COMPLETE = 1,
        TOF_CALIBRATION_FIN = 2,
        PIR_DETECTED = 3,
        TOF_DETECTED = 4
    };

    enum Threshold {
        MIN_TOF_THRESHOLD = 0,
        MAX_TOF_THRESHOLD = 2000
    };

    DetectHumanClass(PinName pir_a_port,
                     PinName pir_b_port,
                     I2C*,
                     Timer*,
                     PinName tx,
                     PinName rx);//constructor


    bool SettingSensor();//declare in/out port
    bool CalibrateSensor();//calibration TOF sensor
    bool DetectPIRState();//Detecting pir sensor
    int get_detect_state_();//for using main logic
    int init();//for using main logic
    bool DetectTOFState();//if detectPIRstate return true, activating TOF sensor

    int detect_sensor_state_ ;//detect_stata variables mattching the SensorState enum
    uint16_t calibrationed_distance;




private:
    DigitalIn pir_a_pin_;
    DigitalIn pir_b_pin_;
    Serial pc;
    VL53L0X tof_;
    I2C* i2c;
    Timer* timer;
};

#endif