#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11); 
LM75B sensor(p28, p27);
PwmOut speaker(p26);
float T;

void play_tone(float frequency, float volume, int interval, int rest) {
    speaker.period(1.0 / frequency);
    speaker = volume;
    wait(interval);
    speaker = 0.0; 
    wait(rest);
}

int main ()
{
    while (1) {
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp = %.1f\n", sensor.temp());
        T = sensor.temp();
        wait(0.5);
        if (T>26.5 && T< 26.5+1)
        {
        play_tone(250, 0.5, 1, 0);
        }
        else if (T>26.5+1 && T< 26.5+2)
        {
        play_tone(500, 0.5, 1, 0);
        }
        else if (T>26.5+2 && T< 26.5+3)
        {
        play_tone(1000, 0.5, 1, 0);
        }
}
}
