#ifndef __RECEIVER__H_
#define __RECEIVER__H_

#include "mbed.h"
#include "iSerial.h"
#include "Command.h"
#include "communication.h"
#define RS485_DELAY 90
#define RS485_DIRC PB_5
#define FLOAT_CONVERTER 10000

class Bear_Receiver
{
private:
    COMMUNICATION *com;

public:
    Bear_Receiver(PinName,PinName,int);
    void FloatSep(float,uint8_t*,uint8_t*);

    //Receiver
    uint8_t ReceiveCommand(uint8_t*,uint8_t*,uint8_t*);
    //Sender
    uint8_t sendMotorPos(uint8_t,float,float);
    uint8_t sendUpMotorKpKiKd(uint8_t,float,float,float);
    uint8_t sendLowMotorKpKiKd(uint8_t,float,float,float);
    uint8_t sendUpMargin(uint8_t,float);
    uint8_t sendLowMargin(uint8_t,float);
    uint8_t sendHeight(uint8_t,uint8_t*);
    uint8_t sendWheelPos(uint8_t,uint8_t*);
    uint8_t sendMagData(uint8_t,uint8_t*);
    uint8_t sendOffset(uint8_t,uint8_t*);
    uint8_t sendBodyWidth(uint8_t,uint8_t*);
    uint8_t sendUpAngleRange(uint8_t,uint8_t*);
    uint8_t sendLowAngleRange(uint8_t,uint8_t*);
    uint8_t sendUpLinkLength(uint8_t,uint8_t*);
    uint8_t sendLowLinkLength(uint8_t,uint8_t*);
};

#endif
