/***************************************
Example Application for the Adafruit ST7735 TFT Shield
on the ON Semiconductor NCS36510 mbed Board
***************************************/

#include "mbed.h"
#include "Adafruit_ST7735.h"
#include "SDFileSystem.h"
#include <string>
#include <sstream>

using namespace std;


DigitalOut led1(LED1);
AnalogIn adc_in_3(A3);
AnalogIn adc_in_2(A2);

SDFileSystem sd(D11, D12, D13, D4, "SD"); // the pinout on the mbed // mosi, miso, sclk, cs
Adafruit_ST7735 tft(D11, D12, D13, D10, D6, D9); // MOSI, MISO, SCLK, SSEL, TFT_DC, TFT_RST

Serial PC(USBTX, USBRX);


int main() {
    PC.printf("start");
        
    tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab
    tft.fillScreen(ST7735_BLACK);
    tft.DrawBitmapFile("/SD/ON.bmp"); //Note, this must be a 24-bit Bitmap file, with a resolution less than 128x160 pixels
    
    float a, b;
    uint32_t file_index = 0;
  
    while (true) {
        
        stringstream temp_str;
        temp_str<<(file_index);
        string filename_str = "/SD/data" + temp_str.str() + ".csv";
        const char* filename_cstr = filename_str.c_str();
        FILE *fp = fopen(filename_cstr, "w");
        led1=1;
       
        
        uint32_t i = 0;
        while (i < 50){
            a = adc_in_3.read(); /* Read the converted analog value */ 
            b = adc_in_2.read();
            fprintf(fp,"%f\n", a);
            tft.setTextColor(ST7735_GREEN, ST7735_BLACK); //(Text Color, Background color)
            tft.setTextCursor(0, 120);
            tft.printf("ADC 3: %f\n\rADC 2: %f\n\r",  (a), (b)); 
            if (a < 0.1){tft.printf("Joystick: LEFT   ");}
            else if (a > 0.1 && a < .2){tft.printf("Joystick: DOWN   ");}
            else if (a > 0.2 && a < .3){tft.printf("Joystick: PUSHED   ");}
            else if (a > 0.3 && a < .65){tft.printf("Joystick: RIGHT   ");}
            else if (a > 0.65 && a < .725){tft.printf("Joystick: UP      ");}
            else if (a > 0.725){tft.printf("Joystick: DEFAULT");}
            wait_ms(.5); 
            i++;
        }
        fclose(fp);
        led1=0;
        file_index++;
       
        
    }
}

