#include "mbed.h"
#include "BMP180.h"

#define PIN_SDA D4
#define PIN_SCL D5
Serial pc(SERIAL_TX,SERIAL_RX,921600);

int main(){
    BMP180 bmp180(PIN_SDA,PIN_SCL);
    float pressure,temperature;
    printf("\rstart!\n\r");
    bmp180.Initialize(27,BMP180_OSS_ULTRA_LOW_POWER);//27は府大の海抜高度
    printf("initialization complete!\n\r");
    
    for(int i=0;i<100;i++){
        if(bmp180.ReadData(&temperature,&pressure)){
            printf("%3d:Pressure(hPa)\t:%.2f\n\r",i,pressure);
            printf("%3d:Temperature(C)\t:%.2f\n\r",i,temperature);
            printf("--------------------------------\n\r");
            wait(1);
        }
    }
    
    printf("complete!\n\r");
    
    return 0;
}