#include "mbed.h"

#define SI_pin p12
#define CLK_pin p13
#define AO_pin p15

#define HIGH 0x1
#define LOW 0x0


DigitalOut SI (SI_pin);
DigitalOut CLK (CLK_pin);
AnalogIn AO(p15);
AnalogIn AC(p18);

float data[128];
int line[128]; 
Serial pc(USBTX, USBRX, 115200);

void CamInit();
void ScanFrame();

int main() {
    pc.printf("Starting...\n");
    CamInit();
 //   SI = HIGH;
  //  CLK = HIGH;
    while(1) {
      ScanFrame();
      /*for (int i = 0; i < 128; i+=2)
      {
      pc.printf("%i ", (int)(data[i] * 4096 / 100));
      } */
      for (int i = 0; i < 128; i++)
      if (data[i] < AC)
        pc.printf("O");
        else
        pc.printf(" ");
       // wait_ms(0);
      pc.printf("\n");  
    
    }
}

void CamInit()
{   
    SI = HIGH;
    CLK = HIGH;
    wait_us(5);
    SI = LOW;
    CLK = LOW;
    wait_us(5);
    
    for (int i = 0; i < 128; i++)
        {
        CLK = HIGH;
        wait_us(5);
        CLK = LOW;  
        wait_us(5); 
        }
}

void ScanFrame()
{
    SI = HIGH;
    CLK = HIGH;
    wait_us(5);
    SI = LOW;
    CLK = LOW;
    wait_us(5);
    
    for (int i = 0;i < 128; i++)
        {
            data[i] = AO;
            CLK = HIGH;
            wait_us(5);
            CLK = LOW;  
            wait_us(5);
        }
}




