#include "mbed.h"
#include "nexpaq_mdk.h"

PwmOut ledR(P2_4);
PwmOut ledG(P2_5);
PwmOut ledB(P2_6);
AnalogIn aIn0(AIN_0);
AnalogIn aIn1(AIN_1);
AnalogIn aIn2(AIN_2);
AnalogIn aIn3(AIN_3);
AnalogIn aIn4(AIN_4);
AnalogIn aIn5(AIN_5);
DigitalInOut digPin[] = {DigitalInOut(P0_1),DigitalInOut(P0_0),DigitalInOut(P1_2),DigitalInOut(P1_1),
                         DigitalInOut(P1_0),DigitalInOut(P1_3),DigitalInOut(P1_7),DigitalInOut(P1_6),
                         DigitalInOut(P3_0),DigitalInOut(P3_1),DigitalInOut(P3_4),DigitalInOut(P3_5),
                         DigitalInOut(P0_2),DigitalInOut(P0_3),DigitalInOut(P4_0),DigitalInOut(P4_1)
                        };

/***** Definitions *****/
#define		FUNCTION_TABLE_NUM					2
#define		UUID_NUM							16			// UUID number is 16, don't change it
#define     LOOP_DELAY                          1000

/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
void my_function_CMD_2702(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
    {0x2700, my_function_CMD_2700},		// Command -> function
    {0x2702, my_function_CMD_2702},		// Command -> function
};

unsigned char dataOut[10];

/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    ledR = 1.0f - (pData[0] / 255.0f);
    ledG = 1.0f - (pData[1] / 255.0f);
    ledB = 1.0f - (pData[2] / 255.0f);
    np_api_upload(0x2701, &response, 1);
}

void my_function_CMD_2702(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    int pinIndex = pData[0];
    int pinMode = pData[1];
    switch(pinMode) {
        case 0:
        case 1:
            digPin[pinIndex].mode(PullNone);
            digPin[pinIndex].input();
            break;
        case 2:
            digPin[pinIndex].mode(PullDown);
            digPin[pinIndex].input();
            break;
        case 3:
            digPin[pinIndex].mode(PullUp);
            digPin[pinIndex].input();
            break;
        case 4:
            digPin[pinIndex]=0;
            digPin[pinIndex].output();
            break;
        case 5:
            digPin[pinIndex]=1;
            digPin[pinIndex].output();
            break;
    }
    np_api_upload(0x2703, &response, 1);
}

void sendStatus()
{
    np_api_upload(0x2800, dataOut, 10);
}

/******************************************************************************/
void app_setup()
{
    int i = 0;
//	np_api_set_app_version(0, 0, 3);
    if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
        // Register failed handle code
    }
    ledR = 1.0f;
    ledG = 1.0f;
    ledB = 1.0f;
    for (i = 0; i < 16; i++) {
        digPin[i].mode(PullUp);
        digPin[i].input();
    }
    for (i = 0; i < 10; i++) {
        dataOut[i] = 0xFF;
    }
}

void app_loop()
{
    int anaData;
    anaData = aIn4.read_u16();
    dataOut[0] = anaData;
    dataOut[1] = anaData>>8;
    anaData = aIn5.read_u16();
    dataOut[2] = anaData;
    dataOut[3] = anaData>>8;
    anaData = aIn2.read_u16();
    anaData = anaData/10;
    dataOut[4] = anaData;
    dataOut[5] = anaData>>8;
    anaData = aIn3.read_u16();
    anaData = anaData/10;
    dataOut[6] = anaData;
    dataOut[7] = anaData>>8;

    dataOut[8] = (digPin[7].read()<<7) +
                 (digPin[6].read()<<6) +
                 (digPin[5].read()<<5) +
                 (digPin[4].read()<<4) +
                 (digPin[3].read()<<3) +
                 (digPin[2].read()<<2) +
                 (digPin[1].read()<<1) +
                 (digPin[0].read());
    dataOut[9] = (digPin[15].read()<<7) +
                 (digPin[14].read()<<6) +
                 (digPin[13].read()<<5) +
                 (digPin[12].read()<<4) +
                 (digPin[11].read()<<3) +
                 (digPin[10].read()<<2) +
                 (digPin[9].read()<<1) +
                 (digPin[8].read());
    sendStatus();
}

int main(void)
{
    np_api_init();
    app_setup();
    np_api_start();
    while(1) {
        app_loop();
        np_api_bsl_chk();
        Thread::wait(LOOP_DELAY);
    }
    return 0;
}
