#include "mbed.h"
#include "nexpaq_mdk.h"
#include "MAX44000.h"

MAX44000 max44000(P1_6, P1_7);
PwmOut ledR(P2_4);
PwmOut ledG(P2_5);
PwmOut ledB(P2_6);
DigitalIn button(P0_1, PullUp);

/***** Definitions *****/
#define		FUNCTION_TABLE_NUM					2
#define		UUID_NUM							16			// UUID number is 16, don't change it
#define     LOOP_DELAY                          100
#define     PROX_THRESHOLD                      10
#define     ALS_INTERVAL                        10          // about once per second

/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
void my_function_CMD_2702(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
    {0x2700, my_function_CMD_2700},		// Command -> function
    {0x2702, my_function_CMD_2702},		// Command -> function
};

int alsCnt = 0;
int prxThrsh = PROX_THRESHOLD ;
int lastPrx = 0;
unsigned char prxPress = 0x02;
int lastBtn = 1;
unsigned char btnPress = 0x01;

/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    ledR = 1.0f - (pData[0] / 255.0f);
    ledG = 1.0f - (pData[1] / 255.0f);
    ledB = 1.0f - (pData[2] / 255.0f);
    np_api_upload(0x2701, &response, 1);
}

void my_function_CMD_2702(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    prxThrsh = pData[0] ;
    np_api_upload(0x2703, &response, 1);
}

void sendALS()
{
    unsigned char pData[3];
    max44000.writeReg(MAX44000::REG_MAIN_CONFIG, 0x20);
    pData[0] = 10;
    pData[1] = max44000.readReg(MAX44000::REG_ALS_DATA_HIGH);
    pData[2] = max44000.readReg(MAX44000::REG_ALS_DATA_LOW);
    np_api_upload(0x2800, pData, 3);
    max44000.writeReg(MAX44000::REG_MAIN_CONFIG, 0x30);
}

/******************************************************************************/
void app_setup()
{
//	np_api_set_app_version(0, 0, 3);
    if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
        // Register failed handle code
    }
    max44000.init(MAX44000::MODE_ALS_PROX, MAX44000::ALSTIM_64X, MAX44000::ALSPGA_1X, MAX44000::DRV_10);
    ledR = 1.0f;
    ledG = 1.0f;
    ledB = 1.0f;
}

void app_loop()
{
    int proxData = max44000.readReg(MAX44000::REG_PRX_DATA);
    if (proxData > prxThrsh) {
        if (!lastPrx) {
            np_api_upload(0x2800, &prxPress, 1);
        }
        lastPrx = 1;
    } else {
        lastPrx = 0;
    }

    if (!button && lastBtn) {
        np_api_upload(0x2800, &btnPress, 1);
    }
    lastBtn = button;

    alsCnt += 1;
    if (alsCnt > ALS_INTERVAL) {
        sendALS();
        alsCnt = 0;
    }
}

int main(void)
{
    np_api_init();
    app_setup();
    np_api_start();
    while(1) {
        app_loop();
        np_api_bsl_chk();
        Thread::wait(LOOP_DELAY);
    }
    return 0;
}
