/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
/******************* Murata Manufacturing Co.,Ltd. 2014 *****************
 *
 * Filename:   Endpoint.cpp
 *
 * Purpose:    This module has implementation of socket end point.
 *              
 * $Author: kishino $
 *
 * $Date: 2014/03/26 $
 *
 * $Revision: 0.0.0.1 $
 * ***********************************************************************/
#include "Socket.h"
#include "Endpoint.h"
#include <cstring>
#include <cstdio>

Endpoint::Endpoint()
{
    reset_address();
}

Endpoint::~Endpoint()
{
}

void Endpoint::reset_address(void)
{
    mIpAddress[0] = '\0';
}

int Endpoint::set_address(const char* host_p, const int port)
{
    reset_address();
    
    strcpy( mIpAddress, host_p );
    mPort = port;
    
    return 0;
}

char* Endpoint::get_address()
{
    return mIpAddress;
}

int   Endpoint::get_port()
{
    return mPort;
}
