#include "YDwifiUartCommand.h"

using namespace murata_wifi;

void C_YDwifiUartCommand::setCommandID( unsigned char cmd_id )
{
    mCommandID = cmd_id;
}

unsigned char C_YDwifiUartCommand::getCommandID()
{
    return mCommandID;
}

void C_YDwifiUartCommand::setCommandSID( unsigned char cmd_sid )
{
    mCommandSID = cmd_sid;
}

unsigned char C_YDwifiUartCommand::getCommandSID()
{
    return mCommandSID;
}

void C_YDwifiUartCommand::setCommandStatus( unsigned char status )
{
    mCommandStatus = status;
}

unsigned char C_YDwifiUartCommand::getCommandStatus()
{
    return mCommandStatus;
}

void C_YDwifiUartCommand::setResponseBuf( unsigned char *buf_p )
{
    mResponseBuf_p = buf_p;
}

unsigned char *C_YDwifiUartCommand::getResponseBuf()
{
    return mResponseBuf_p;
}

void C_YDwifiUartCommand::setScanResultHandler( void (*handler_p)(tagSCAN_RESULT_T *scan_result) )
{
    mScanResultHandler_p = handler_p;
}


int C_YDwifiUartCommand::wait()
{
    int ret = 0;

    // Get thread ID
    mCommandThreadID = osThreadGetId();
    
    // Signal flags that are reported as event are automatically cleared.
    osEvent event_ret = osSignalWait( UART_COMMAND_SIGNAL, UART_COMMAND_WAIT_TIMEOUT);
    if( event_ret.status != osEventSignal )
    {
        ret = -1;
    }

    return ret;
}

int C_YDwifiUartCommand::signal()
{
    // set signal
    return osSignalSet(mCommandThreadID, UART_COMMAND_SIGNAL);
}

bool C_YDwifiUartCommand::isWaitingCommand( unsigned int command_id, unsigned char *payload_p )
{
    bool ret = false;

    if( (command_id == getCommandID())
        && (payload_p[0] == (getCommandSID() | 0x80) ) )
    {
        ret = true;
    }
    return ret;
}

void C_YDwifiUartCommand::scanResultIndicate( unsigned char *payload_p, int payload_len )
{
    if( (payload_p == NULL) || (mScanResultHandler_p == NULL) )
    {
        return;
    }
    
    tagSCAN_RESULT_T scan_result;
    int ap_count  = payload_p[2];
    
    if( ap_count == 0 )
    {
        mScanResultHandler_p( NULL );
    }
    
    unsigned char *ap_info_p = &payload_p[3];
    int ap_info_idx = 0;

    for( int i = 0; i < ap_count; i++ )
    {
        scan_result.channel = ap_info_p[ap_info_idx];
        ap_info_idx++;
        scan_result.rssi    = (signed)ap_info_p[ap_info_idx];
        ap_info_idx++;
        scan_result.security= ap_info_p[ap_info_idx];
        ap_info_idx++;
        memcpy( scan_result.bssid, &ap_info_p[ap_info_idx], BSSID_MAC_LENTH );
        ap_info_idx += BSSID_MAC_LENTH;
        scan_result.network_type= ap_info_p[ap_info_idx];
        ap_info_idx++;
        scan_result.max_rate= ap_info_p[ap_info_idx];
        ap_info_idx++;
        ap_info_idx++;  // reserved
        strcpy( scan_result.ssid, (char *)&ap_info_p[ap_info_idx] );
        ap_info_idx += strlen( (char *)&ap_info_p[ap_info_idx] );
        ap_info_idx++;
        
        // Scanresult callback
        mScanResultHandler_p( &scan_result );
    }
}
