#ifndef _SNIC_WIFI_H_
#define _SNIC_WIFI_H_

#include "mbed.h"
#include "rtos.h"
#include "RawSerial.h"

#include "SNICwifiUartCommand.h"
//#include "CBuffer.h"

namespace murata_wifi
{
#define UART_REQUEST_PAYLOAD_MAX 256

#define MEMPOOL_BLOCK_SIZE  2048
#define MEMPOOL_PAYLOAD_NUM 1
typedef struct
{
    unsigned char buf[MEMPOOL_BLOCK_SIZE];
}tagMEMPOOL_BLOCK_T;

/** Wi-Fi security
 */
typedef enum SECURITY {
    /** Securiry Open */
    e_SEC_OPEN       = 0x00,
    /** Securiry WEP */
    e_SEC_WEP        = 0x01,
    /** Securiry WPA-PSK(TKIP) */
    e_SEC_WPA_TKIP   = 0x02,
    /** Securiry WPA2-PSK(AES) */
    e_SEC_WPA2_AES   = 0x04,
    /** Securiry WPA2-PSK(TKIP/AES) */
    e_SEC_WPA2_MIXED = 0x06,
    /** Securiry WPA-PSK(AES) */
    e_SEC_WPA_AES    = 0x07
}E_SECURITY;

/** Wi-Fi Network type
 */
typedef enum NETWORK_TYPE {
    /** Infrastructure */
    e_INFRA = 0,
    /** Adhoc */
    e_ADHOC = 1
}E_NETWORK_TYPE;

/** Wi-Fi status
 */
typedef enum WIFI_STATUS {
    /** Wi-Fi OFF */
    e_STATUS_OFF = 0,
    /** No network */
    e_NO_NETWORK,
    /** Connected to AP (STA mode) */
    e_STA_JOINED,
    /** Started  on AP mode */
    e_AP_STARTED
}E_WIFI_STATUS;

/** GEN_FW_VER_GET_REQ Command */
typedef struct 
{
    unsigned char cmd_sid;
    unsigned char seq;
}tagGEN_FW_VER_GET_REQ_T;

/** SNIC_INIT_REQ */
typedef struct
{
    unsigned char  cmd_sid;
    unsigned char  seq;
    unsigned short buf_size;
}tagSNIC_INIT_REQ_T;

/** WIFI_ON_REQ Command */
typedef struct 
{
    unsigned char cmd_sid;
    unsigned char seq;
    char country[COUNTRYC_CODE_LENTH];
}tagWIFI_ON_REQ_T;

/** WIFI_OFF_REQ Command */
typedef struct 
{
    unsigned char cmd_sid;
    unsigned char seq;
}tagWIFI_OFF_REQ_T;

/** WIFI_DISCONNECT_REQ Command */
typedef struct 
{
    unsigned char cmd_sid;
    unsigned char seq;
}tagWIFI_DISCONNECT_REQ_T;

/** WIFI_GET_STA_RSSI_REQ Command */
typedef struct 
{
    unsigned char cmd_sid;
    unsigned char seq;
}tagWIFI_GET_STA_RSSI_REQ_T;

/** WIFI_GET_STATUS_REQ Command */
typedef struct 
{
    unsigned char cmd_sid;
    unsigned char seq;
    unsigned char interface;
}tagWIFI_GET_STATUS_REQ_T;

/** WIFI_SCAN_REQ Command */
typedef struct 
{
    unsigned char cmd_sid;
    unsigned char seq;
    unsigned char scan_type;
    unsigned char bss_type;
    unsigned char bssid[BSSID_MAC_LENTH];
    unsigned char chan_list;
    unsigned char ssid[SSID_MAX_LENGTH+1];
}tagWIFI_SCAN_REQ_T;

/** C_SNICwifi class
 */
class C_SNICwifi
{

public:
    C_SNICwifiUartCommand mUartCommand;

    /** Get buffer for command from memory pool.
        @return Pointer of buffer
     */
    tagMEMPOOL_BLOCK_T *getAlocCmdBuf();
    
    /** Release buffer to memory pool.
        @param buf_p Pointer of buffer
     */
    void freeCmdBuf( tagMEMPOOL_BLOCK_T *buf_p );

    /** Initialize UART
    */
    int initUart( PinName tx, PinName rx, int baud );

    /** Send data to UART
        @param len  Length of send data
        @param data Pointer of send data
        @return 0:success/other:fail
    */
    int sendUart( unsigned int len, unsigned char *data );

    /** Preparation of the UART command
        @param cmd_id           UART Command ID
        @param cmd_sid          UART Command  SubID
        @param req_buf_p        Pointer of UART request buffer
        @param req_buf_len      Length of UART request buffer
        @param response_buf_p   Pointer of UART response buffer
        @param command_p        Pointer of UART command[output]
        @return Length of UART command.
    */
    unsigned int preparationSendCommand( unsigned char cmd_id, unsigned char cmd_sid
                                , unsigned char *req_buf_p,    unsigned int req_buf_len
                                , unsigned char *response_buf_p, unsigned char *command_p );

    /** Get an instance of the C_SNICwifi class.
        @return Instance of the C_SNICwifi class
        @note   Please do not create an instance in the default constructor this class.
                Please use this method when you want to get an instance.
    */
    static C_SNICwifi *getInstance();

protected:
    static C_SNICwifi     *mInstance_p;
    Thread                *mUartRecvThread_p;
    RawSerial             *mUart_p;
    Mutex                 mUartMutex;
//    DigitalInOut        mModuleReset;
 
private:
    /** MemoryPool for payload of UART response */
    MemoryPool<tagMEMPOOL_BLOCK_T, MEMPOOL_PAYLOAD_NUM>     mMemPoolPayload;
  
    /** Constructor
     */
    C_SNICwifi();

    /** Receiving thread of UART
    */
    static void uartRecvThread( void const *args_p );
};
}

#endif