#include "mbed.h"
#include "SNICwifi.h"
#include "SNICwifi_uartmsg.h"
#include <string>
//#include <algorithm>

using namespace murata_wifi;

#define UART_RECVBUF_SIZE   2048
typedef struct
{
    unsigned char buf[UART_RECVBUF_SIZE];
    unsigned int  size;
    bool          is_receive;
}tagUART_RECVBUF_T;
tagUART_RECVBUF_T   gUART_RCVBUF;
unsigned char   gUART_TEMP_BUF[UART_RECVBUF_SIZE];

C_SNICwifi *C_SNICwifi::mInstance_p = NULL;

C_SNICwifi *C_SNICwifi::getInstance()
{
    if( mInstance_p == NULL )
    {
        mInstance_p = new C_SNICwifi();
    }
    return mInstance_p;
}

C_SNICwifi::C_SNICwifi()
{
    mUartRecvThread_p = NULL;
}

int C_SNICwifi::initUart(PinName tx, PinName rx, int baud)
{
    printf("[C_SNICwifi::initUart]1\r\n");
    
    mUartRequestSeq   = 0;

    mUart_p = new RawSerial( tx, rx );
    mUart_p->baud( baud );
    mUart_p->format(8, SerialBase::None, 1);

    printf("[C_SNICwifi::initUart]2\r\n");
    // Initialize uart
    gUART_RCVBUF.is_receive = false;
    gUART_RCVBUF.size       = 0;

    // Create UART recv thread
    mUartRecvThread_p = new Thread( C_SNICwifi::uartRecvThread );
    printf("[C_SNICwifi::initUart]3\r\n");
    if( mUartRecvThread_p == NULL )
    {
        printf("[C_SNICwifi::initUart] thread cread failed\r\n");
        return -1;
    }

    return 0;
}

unsigned int C_SNICwifi::preparationSendCommand( unsigned char cmd_id, unsigned char cmd_sid
                                            , unsigned char *req_buf_p,    unsigned int req_buf_len
                                            , unsigned char *response_buf_p, unsigned char *command_p )
{
    unsigned char  payload_array[UART_REQUEST_PAYLOAD_MAX];
    unsigned short payload_len;
    unsigned int   command_len = 0;
    
    // Make command payload
    payload_len = C_SNIC_UartMsg::makePayload( req_buf_len, req_buf_p, payload_array );
    // Make all command request
    command_len = C_SNIC_UartMsg::makeRequest( cmd_id, payload_array, payload_len, command_p );

    // Set data for response
    mUartCommand.setCommandID( cmd_id );
    mUartCommand.setCommandSID( cmd_sid );
    mUartCommand.setResponseBuf( response_buf_p );
    
    return command_len;
}

int C_SNICwifi::sendUart( unsigned int len, unsigned char *data )
{
    int ret = 0;
    
    mUartMutex.lock();
    for( int i = 0; i < len; i++ )
    {
        // Write to UART
        ret = mUart_p->putc( data[i] );
        if( ret == -1 )
        {
            ret = -1;
            break;
        }
    }
    mUartMutex.unlock();
    return ret;
}

tagMEMPOOL_BLOCK_T *C_SNICwifi::getAlocCmdBuf()
{
    // Get buffer from MemoryPool
    return mMemPoolPayload.alloc();
}

void C_SNICwifi::freeCmdBuf( tagMEMPOOL_BLOCK_T *buf_p )
{
    mMemPoolPayload.free( buf_p );
}

void C_SNICwifi::uartRecvThread (void const *args_p) {

    C_SNICwifi *instance_p = C_SNICwifi::getInstance();
    if ( instance_p == NULL )
    {
        printf("Socket constructor error: no wifly instance available!\r\n");
    }

    int recvdata = 0;
    int i;
    
    /* UART recv thread main loop */
    for (;;) 
    {
        while( instance_p->mUart_p->readable() )
        {
            // Receive data from UART.
            instance_p->mUartMutex.lock();
            recvdata = instance_p->mUart_p->getc();
            instance_p->mUartMutex.unlock();

            // Check UART receiving flg
            if( gUART_RCVBUF.is_receive )
            {
                gUART_RCVBUF.buf[ gUART_RCVBUF.size ] = (unsigned char)recvdata;
                gUART_RCVBUF.size++;
                // Check  received data is EOM.
                if( recvdata == UART_CMD_EOM )
                {
/*
                    printf("[recv]\r\n");
                    for( i = 0; i < gUART_RCVBUF.size; i++ )
                    {
                        printf("%02x ", gUART_RCVBUF.buf[i]);
                    }
                    printf("\r\n");
*/
                    unsigned char command_id;
                    // Get payload from received data from UART.
                    int payload_len = C_SNIC_UartMsg::getResponsePayload( gUART_RCVBUF.size, gUART_RCVBUF.buf
                                                            , &command_id, gUART_TEMP_BUF );
/*
                    printf("[payload]\r\n");
                    for( i = 0; i < payload_len; i++ )
                    {
                        printf("%02x ", gUART_TEMP_BUF[i]);
                    }
                    printf("\r\n");
*/
                    // Check scan results indication 
                    if( (command_id == UART_CMD_ID_WIFI) || (gUART_TEMP_BUF[0] == UART_CMD_SID_WIFI_SCAN_RESULT_IND) )
                    {
                        // Scan result indicate
                        instance_p->mUartCommand.scanResultIndicate( gUART_TEMP_BUF, payload_len );
                    }
                    
                    // Checks in the command which is waiting.
                    if( instance_p->mUartCommand.isWaitingCommand(command_id, gUART_TEMP_BUF) )
                    {
                        // Get buffer for payload data
                        unsigned char *payload_buf_p = instance_p->mUartCommand.getResponseBuf();
                        if( payload_buf_p != NULL )
                        {
                            memcpy( payload_buf_p, gUART_TEMP_BUF, payload_len );
                            instance_p->mUartCommand.setResponseBuf( NULL );
                        }
                        // Set status
                        instance_p->mUartCommand.setCommandStatus( gUART_TEMP_BUF[2] );
                        // Set signal for command response wait.
                        instance_p->mUartCommand.signal();
                    }

                    gUART_RCVBUF.size = 0;
                    gUART_RCVBUF.is_receive = false;
                }
            }
            else
            {
                // Check  received data is SOM.
                if( recvdata == UART_CMD_SOM )
                {
                    gUART_RCVBUF.size = 0;
                    gUART_RCVBUF.buf[ gUART_RCVBUF.size ] = (unsigned char)recvdata;
                    gUART_RCVBUF.size++;
                    gUART_RCVBUF.is_receive = true;
                }
            }
//            Thread::yield();
        }
        Thread::yield();
    }
}

