#ifndef _SNIC_WIFI_H_
#define _SNIC_WIFI_H_

#include "mbed.h"
#include "rtos.h"
#include "RawSerial.h"

#include "SNICwifiUartCommand.h"
//#include "CBuffer.h"

namespace murata_wifi
{

#define MEMPOOL_BLOCK_SIZE  2048
#define MEMPOOL_PAYLOAD_NUM 1
typedef struct
{
    unsigned char buf[MEMPOOL_BLOCK_SIZE];
}tagMEMPOOL_BLOCK_T;

/** C_SNICwifi class
 */
class C_SNICwifi
{

public:
    /** Wi-Fi security
     */
    typedef enum SECURITY {
        /** Securiry Open */
        e_SEC_OPEN       = 0x00,
        /** Securiry WEP */
        e_SEC_WEP        = 0x01,
        /** Securiry WPA-PSK(TKIP) */
        e_SEC_WPA_TKIP   = 0x02,
        /** Securiry WPA2-PSK(AES) */
        e_SEC_WPA2_AES   = 0x04,
        /** Securiry WPA2-PSK(TKIP/AES) */
        e_SEC_WPA2_MIXED = 0x06,
        /** Securiry WPA-PSK(AES) */
        e_SEC_WPA_AES    = 0x07
    }E_SECURITY;

    /** Wi-Fi Network type
     */
    typedef enum NETWORK_TYPE {
        /** Infrastructure */
        e_INFRA = 0,
        /** Adhoc */
        e_ADHOC = 1
    }E_NETWORK_TYPE;

    /** Wi-Fi status
     */
    typedef enum WIFI_STATUS {
        /** Wi-Fi OFF */
        e_STATUS_OFF = 0,
        /** No network */
        e_NO_NETWORK,
        /** Connected to AP (STA mode) */
        e_STA_JOINED,
        /** Started  on AP mode */
        e_AP_STARTED
    }E_WIFI_STATUS;

    /** Get buffer for command from memory pool.
        @return Pointer of buffer
     */
    tagMEMPOOL_BLOCK_T *getAlocCmdBuf();
    
    /** Release buffer to memory pool.
        @param buf_p Pointer of buffer
     */
    void freeCmdBuf( tagMEMPOOL_BLOCK_T *buf_p );

protected:
    /** GEN_FW_VER_GET_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
    }tagGEN_FW_VER_GET_REQ_T;
    
    /** SNIC_INIT_REQ */
    typedef struct
    {
        unsigned char  cmd_sid;
        unsigned char  seq;
        unsigned short buf_size;
    }tagSNIC_INIT_REQ_T;

    /** WIFI_ON_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
        char country[COUNTRYC_CODE_LENTH];
    }tagWIFI_ON_REQ_T;

    /** WIFI_OFF_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
    }tagWIFI_OFF_REQ_T;

    /** WIFI_DISCONNECT_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
    }tagWIFI_DISCONNECT_REQ_T;

    /** WIFI_GET_STA_RSSI_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
    }tagWIFI_GET_STA_RSSI_REQ_T;

    /** WIFI_GET_STATUS_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
        unsigned char interface;
    }tagWIFI_GET_STATUS_REQ_T;

    /** WIFI_SCAN_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
        unsigned char scan_type;
        unsigned char bss_type;
        unsigned char bssid[BSSID_MAC_LENTH];
        unsigned char chan_list;
        unsigned char ssid[SSID_MAX_LENGTH+1];
    }tagWIFI_SCAN_REQ_T;

    static C_SNICwifi     *mInstance_p;
    Thread              *mUartRecvThread_p;
    Mutex               mUartMutex;
//    DigitalInOut        mModuleReset;
    C_SNICwifiUartCommand mUartCommand;
    RawSerial           mUart;
    
    /** Constructor
     * \param tx mbed pin to use for tx line of Serial interface
     * \param rx mbed pin to use for rx line of Serial interface
     * \param cts mbed pin to use for cts line of Serial interface
     * \param rts mbed pin to use for rts line of Serial interface
     * \param reset reset pin of the wifi module
     * \param alarm alarm pin of the wifi module
     * \param baud baud rate of Serial interface
     */
    C_SNICwifi (PinName tx, PinName rx, PinName cts, PinName rts, PinName reset, PinName alarm, int baud);

    /** Initialize UART
    */
    int initUart();

    static C_SNICwifi * getInstance() {
        return mInstance_p;
    };

    /** Send data to UART
        @param len  Length of send data
        @param data Pointer of send data
        @return 0:success/other:fail
    */
    int sendUart( unsigned int len, unsigned char *data );

    /** Receiving thread of UART
    */
    static void uartRecvThread( void const *args_p );
  
private:
    /** MemoryPool for payload of UART response */
    MemoryPool<tagMEMPOOL_BLOCK_T, MEMPOOL_PAYLOAD_NUM>     mMemPoolPayload;
  
};
}

#endif