#ifndef _YD_WIFI_H_
#define _YD_WIFI_H_

#include "mbed.h"
#include "rtos.h"
#include "RawSerial.h"

#include "YDwifiUartCommand.h"
//#include "CBuffer.h"

namespace murata_wifi
{

/** C_YDwifi class
 */
class C_YDwifi
{

public:
    /** Wi-Fi security
     */
    typedef enum SECURITY {
        /** Securiry Open */
        e_SEC_OPEN       = 0x00,
        /** Securiry WEP */
        e_SEC_WEP        = 0x01,
        /** Securiry WPA-PSK(TKIP) */
        e_SEC_WPA_TKIP   = 0x02,
        /** Securiry WPA2-PSK(AES) */
        e_SEC_WPA2_AES   = 0x04,
        /** Securiry WPA2-PSK(TKIP/AES) */
        e_SEC_WPA2_MIXED = 0x06,
        /** Securiry WPA-PSK(AES) */
        e_SEC_WPA_AES    = 0x07
    }E_SECURITY;

    /** Wi-Fi Network type
     */
    typedef enum NETWORK_TYPE {
        /** Infrastructure */
        e_INFRA = 0,
        /** Adhoc */
        e_ADHOC = 1
    }E_NETWORK_TYPE;

    // ----- YDwifi.cpp -----
    /** Constructor
     * \param tx mbed pin to use for tx line of Serial interface
     * \param rx mbed pin to use for rx line of Serial interface
     * \param cts mbed pin to use for cts line of Serial interface
     * \param rts mbed pin to use for rts line of Serial interface
     * \param reset reset pin of the wifi module
     * \param alarm alarm pin of the wifi module
     * \param baud baud rate of Serial interface
     */
    C_YDwifi (PinName tx, PinName rx, PinName cts, PinName rts, PinName reset, PinName alarm, int baud);

    int initUart();

    static C_YDwifi * getInstance() {
        return mInstance_p;
    };
    Thread          *mUartRecvThread_p;

    /** Send data to UART
        @param len  Length of send data
        @param data Pointer of send data
        @return 0:success/other:fail
    */
    int sendUart( unsigned int len, unsigned char *data );

    
protected:
    /** GEN_FW_VER_GET_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
    }tagGEN_FW_VER_GET_REQ_T;

    /** WIFI_DISCONNECT_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
    }tagWIFI_DISCONNECT_REQ_T;

    /** WIFI_SCAN_REQ Command */
    typedef struct 
    {
        unsigned char cmd_sid;
        unsigned char seq;
        unsigned char scan_type;
        unsigned char bss_type;
        unsigned char bssid[BSSID_MAC_LENTH];
        unsigned char chan_list;
        unsigned char ssid[SSID_MAX_LENGTH+1];
    }tagWIFI_SCAN_REQ_T;

    static C_YDwifi *mInstance_p;
    
    Mutex               mUartMutex;
    DigitalInOut        mModuleReset;
    C_YDwifiUartCommand mUartCommand;
    RawSerial           mUart;
    
    static void uartRecvThread( void const *args_p );
    
};
}

#endif