#include "mbed.h"
#include "YDwifi.h"
#include "YDwifi_uartmsg.h"
#include <string>
//#include <algorithm>

using namespace murata_wifi;

#define UART_RECVBUF_SIZE   2048
typedef struct
{
    unsigned char buf[UART_RECVBUF_SIZE];
    unsigned int  size;
    bool          is_receive;
}tagUART_RECVBUF_T;
tagUART_RECVBUF_T   gUART_RCVBUF;
unsigned char   gUART_TEMP_BUF[UART_RECVBUF_SIZE];

C_YDwifi *C_YDwifi::mInstance_p;

C_YDwifi::C_YDwifi(PinName tx, PinName rx, PinName cts, PinName rts, PinName reset, PinName alarm, int baud):
    mUart(tx, rx), mModuleReset(reset)
{
    mUartRecvThread_p = NULL;
    mInstance_p       = this;
    mUartRequestSeq   = 0;

    // Initialize uart
    gUART_RCVBUF.is_receive = false;
    gUART_RCVBUF.size       = 0;
    mUart.baud( 115200 );
    mUart.format(8, SerialBase::None, 1);
}

int C_YDwifi::initUart()
{
    // Create UART recv thread
    mUartRecvThread_p = new Thread( C_YDwifi::uartRecvThread );
    if( mUartRecvThread_p == NULL )
    {
        printf("[C_YDwifi::initUart] thread cread failed\r\n");
        return -1;
    }

    return 0;
}

int C_YDwifi::sendUart( unsigned int len, unsigned char *data )
{
    int ret = 0;
    
    mUartMutex.lock();
    for( int i = 0; i < len; i++ )
    {
        // Write to UART
        ret = mUart.putc( data[i] );
        if( ret == -1 )
        {
            ret = -1;
            break;
        }
    }
    mUartMutex.unlock();
    return ret;
}

void C_YDwifi::uartRecvThread (void const *args_p) {

    C_YDwifi *instance_p = C_YDwifi::getInstance();
    if ( instance_p == NULL )
    {
        printf("Socket constructor error: no wifly instance available!\r\n");
    }

    int recvdata = 0;
    int i;
    
    /* UART recv thread main loop */
    for (;;) 
    {
        while( instance_p->mUart.readable() )
        {
            // Receive data from UART.
            instance_p->mUartMutex.lock();
            recvdata = instance_p->mUart.getc();
            instance_p->mUartMutex.unlock();
            
            // Check UART receiving flg
            if( gUART_RCVBUF.is_receive )
            {
                gUART_RCVBUF.buf[ gUART_RCVBUF.size ] = (unsigned char)recvdata;
                gUART_RCVBUF.size++;
                // Check  received data is EOM.
                if( recvdata == UART_CMD_EOM )
                {
/*
                    printf("[recv]\r\n");
                    for( i = 0; i < gUART_RCVBUF.size; i++ )
                    {
                        printf("%02x ", gUART_RCVBUF.buf[i]);
                    }
                    printf("\r\n");
*/                  
                    unsigned char command_id;
                    // Get payload from received data from UART.
                    int payload_len = C_YD_UartMsg::getResponsePayload( gUART_RCVBUF.size, gUART_RCVBUF.buf
                                                            , &command_id, gUART_TEMP_BUF );
/*
                    printf("[payload]\r\n");
                    for( i = 0; i < payload_len; i++ )
                    {
                        printf("%02x ", gUART_TEMP_BUF[i]);
                    }
                    printf("\r\n");
*/                    
                    // Check scan results indication 
                    if( (command_id == UART_CMD_ID_WIFI) || (gUART_TEMP_BUF[0] == UART_CMD_SID_WIFI_SCAN_RESULT_IND) )
                    {
                        // Scan result indicate
                        instance_p->mUartCommand.scanResultIndicate( gUART_TEMP_BUF, payload_len );
                    }
                    
                    // Checks in the command which is waiting.
                    if( instance_p->mUartCommand.isWaitingCommand(command_id, gUART_TEMP_BUF) )
                    {
                        // Get buffer for payload data
                        unsigned char *payload_buf_p = instance_p->mUartCommand.getResponseBuf();
                        if( payload_buf_p != NULL )
                        {
                            memcpy( payload_buf_p, gUART_TEMP_BUF, payload_len );
                            instance_p->mUartCommand.setResponseBuf( NULL );
                        }
                        // Set status
                        instance_p->mUartCommand.setCommandStatus( gUART_TEMP_BUF[2] );
                        // Set signal for command response wait.
                        instance_p->mUartCommand.signal();
                    }

                    gUART_RCVBUF.size = 0;
                    gUART_RCVBUF.is_receive = false;
                }
            }
            else
            {
                // Check  received data is SOM.
                if( recvdata == UART_CMD_SOM )
                {
                    gUART_RCVBUF.size = 0;
                    gUART_RCVBUF.buf[ gUART_RCVBUF.size ] = (unsigned char)recvdata;
                    gUART_RCVBUF.size++;
                    gUART_RCVBUF.is_receive = true;
                }
            }
        }
        Thread::yield();
    }
}

